/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.quicksight.model.AccessDeniedException;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.DomainNotWhitelistedException;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.IdentityTypeNotSupportedException;
import software.amazon.awssdk.services.quicksight.model.InternalFailureException;
import software.amazon.awssdk.services.quicksight.model.InvalidNextTokenException;
import software.amazon.awssdk.services.quicksight.model.InvalidParameterValueException;
import software.amazon.awssdk.services.quicksight.model.LimitExceededException;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.PreconditionNotMetException;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.services.quicksight.model.QuickSightUserNotFoundException;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceExistsException;
import software.amazon.awssdk.services.quicksight.model.ResourceNotFoundException;
import software.amazon.awssdk.services.quicksight.model.ResourceUnavailableException;
import software.amazon.awssdk.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import software.amazon.awssdk.services.quicksight.model.ThrottlingException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedUserEditionException;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;

/**
 * Service client for accessing Amazon QuickSight. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon QuickSight API Reference</fullname>
 * <p>
 * Amazon QuickSight is a fast, cloud-powered BI service that makes it easy to build visualizations, perform ad hoc
 * analysis, and quickly get business insights from your data. This API interface reference contains documentation for a
 * programming interface that you can use to manage Amazon QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface QuickSightClient extends SdkClient {
    String SERVICE_NAME = "quicksight";

    /**
     * Create a {@link QuickSightClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QuickSightClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QuickSightClient}.
     */
    static QuickSightClientBuilder builder() {
        return new DefaultQuickSightClientBuilder();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceExistsException
     *         The resource specified doesn't exist.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, LimitExceededException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request. The
     *        request object for this operation.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceExistsException
     *         The resource specified doesn't exist.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, PreconditionNotMetException, LimitExceededException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * The response is the group member object.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return Result of the CreateGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGroupMembershipResponse createGroupMembership(CreateGroupMembershipRequest createGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * The response is the group member object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupMembershipRequest#builder()}
     * </p>
     *
     * @param createGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGroupMembershipResponse createGroupMembership(
            Consumer<CreateGroupMembershipRequest.Builder> createGroupMembershipRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return createGroupMembership(CreateGroupMembershipRequest.builder().applyMutation(createGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return Result of the DeleteGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGroupMembershipResponse deleteGroupMembership(DeleteGroupMembershipRequest deleteGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGroupMembershipRequest#builder()}
     * </p>
     *
     * @param deleteGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGroupMembershipResponse deleteGroupMembership(
            Consumer<DeleteGroupMembershipRequest.Builder> deleteGroupMembershipRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteGroupMembership(DeleteGroupMembershipRequest.builder().applyMutation(deleteGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt; </i> </code>.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt; </i> </code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is the group object.
     * </p>
     *
     * @param describeGroupRequest
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is the group object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGroupRequest.Builder} to create a request.
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupResponse describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon Resource Name (ARN), AWS Identity and Access
     * Management (IAM) role, and email address.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon Resource Name (ARN), AWS Identity and Access
     * Management (IAM) role, and email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return Result of the DescribeUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Generates an embedded URL and authorization code. Before this can work properly, you need to configure the
     * dashboards and user permissions first.
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     * @return Result of the GetDashboardEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceExistsException
     *         The resource specified doesn't exist.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws DomainNotWhitelistedException
     *         The domain specified is not on the allowlist. All domains for embedded dashboards must be added to the
     *         approved list by an Amazon QuickSight admin.
     * @throws QuickSightUserNotFoundException
     *         The user is not found. This could happen in any operation that requires finding a user based on the
     *         provided user name, such as DeleteUser, DescribeUser, and so on.
     * @throws IdentityTypeNotSupportedException
     *         The identity type specified is not supported. Supported identity types include: IAM and QUICKSIGHT.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session is invalid. The session lifetime must be
     *         between 15 and 600 minutes.
     * @throws UnsupportedUserEditionException
     *         Indicates that you are calling an operation on an Amazon QuickSight subscription where the edition does
     *         not include support for that operation. Amazon QuickSight currently has Standard Edition and Enterprise
     *         Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDashboardEmbedUrlResponse getDashboardEmbedUrl(GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, PreconditionNotMetException, DomainNotWhitelistedException, QuickSightUserNotFoundException,
            IdentityTypeNotSupportedException, SessionLifetimeInMinutesInvalidException, UnsupportedUserEditionException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an embedded URL and authorization code. Before this can work properly, you need to configure the
     * dashboards and user permissions first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDashboardEmbedUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetDashboardEmbedUrlRequest#builder()}
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetDashboardEmbedUrlRequest.Builder} to create a
     *        request.
     * @return Result of the GetDashboardEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceExistsException
     *         The resource specified doesn't exist.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws DomainNotWhitelistedException
     *         The domain specified is not on the allowlist. All domains for embedded dashboards must be added to the
     *         approved list by an Amazon QuickSight admin.
     * @throws QuickSightUserNotFoundException
     *         The user is not found. This could happen in any operation that requires finding a user based on the
     *         provided user name, such as DeleteUser, DescribeUser, and so on.
     * @throws IdentityTypeNotSupportedException
     *         The identity type specified is not supported. Supported identity types include: IAM and QUICKSIGHT.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session is invalid. The session lifetime must be
     *         between 15 and 600 minutes.
     * @throws UnsupportedUserEditionException
     *         Indicates that you are calling an operation on an Amazon QuickSight subscription where the edition does
     *         not include support for that operation. Amazon QuickSight currently has Standard Edition and Enterprise
     *         Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDashboardEmbedUrlResponse getDashboardEmbedUrl(
            Consumer<GetDashboardEmbedUrlRequest.Builder> getDashboardEmbedUrlRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, DomainNotWhitelistedException, QuickSightUserNotFoundException,
            IdentityTypeNotSupportedException, SessionLifetimeInMinutesInvalidException, UnsupportedUserEditionException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return getDashboardEmbedUrl(GetDashboardEmbedUrlRequest.builder().applyMutation(getDashboardEmbedUrlRequest).build());
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a list of group member objects.
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return Result of the ListGroupMemberships operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsResponse listGroupMemberships(ListGroupMembershipsRequest listGroupMembershipsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a list of group member objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupMembershipsRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsRequest.Builder} to create a
     *        request.
     * @return Result of the ListGroupMemberships operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsResponse listGroupMemberships(
            Consumer<ListGroupMembershipsRequest.Builder> listGroupMembershipsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listGroupMemberships(ListGroupMembershipsRequest.builder().applyMutation(listGroupMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*</code>.
     * </p>
     * <p>
     * The response is a list of group objects.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*</code>.
     * </p>
     * <p>
     * The response is a list of group objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return Result of the ListGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that a user is part of.
     * </p>
     *
     * @param listUserGroupsRequest
     * @return Result of the ListUserGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserGroupsResponse listUserGroups(ListUserGroupsRequest listUserGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that a user is part of.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserGroupsRequest#builder()}
     * </p>
     *
     * @param listUserGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserGroupsRequest.Builder} to create a request.
     * @return Result of the ListUserGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserGroupsResponse listUserGroups(Consumer<ListUserGroupsRequest.Builder> listUserGroupsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return listUserGroups(ListUserGroupsRequest.builder().applyMutation(listUserGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>*</i> </code>.
     * </p>
     * <p>
     * The response is a list of user objects, containing each user's Amazon Resource Name (ARN), AWS Identity and
     * Access Management (IAM) role, and email address.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>*</i> </code>.
     * </p>
     * <p>
     * The response is a list of user objects, containing each user's Amazon Resource Name (ARN), AWS Identity and
     * Access Management (IAM) role, and email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return Result of the ListUsers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the Amazon Resource Name (ARN) for the IAM user or role, and the session name.
     * </p>
     * <p>
     * The condition keys are <code>quicksight:IamArn</code> and <code>quicksight:SessionName</code>.
     * </p>
     *
     * @param registerUserRequest
     * @return Result of the RegisterUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified doesn't exist.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterUserResponse registerUser(RegisterUserRequest registerUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the Amazon Resource Name (ARN) for the IAM user or role, and the session name.
     * </p>
     * <p>
     * The condition keys are <code>quicksight:IamArn</code> and <code>quicksight:SessionName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterUserRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterUserRequest#builder()}
     * </p>
     *
     * @param registerUserRequest
     *        A {@link Consumer} that will call methods on {@link RegisterUserRequest.Builder} to create a request.
     * @return Result of the RegisterUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified doesn't exist.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterUserResponse registerUser(Consumer<RegisterUserRequest.Builder> registerUserRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            LimitExceededException, ResourceExistsException, PreconditionNotMetException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return registerUser(RegisterUserRequest.builder().applyMutation(registerUserRequest).build());
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this.
     * @throws InvalidParameterValueException
     *         One or more parameters don't have a valid value.
     * @throws ResourceNotFoundException
     *         One or more resources couldn't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("quicksight");
    }
}
