/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupMembershipsResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListGroupMembershipsResponse.Builder, ListGroupMembershipsResponse> {
    private static final SdkField<List<GroupMember>> GROUP_MEMBER_LIST_FIELD = SdkField
            .<List<GroupMember>> builder(MarshallingType.LIST)
            .getter(getter(ListGroupMembershipsResponse::groupMemberList))
            .setter(setter(Builder::groupMemberList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMemberList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGroupMembershipsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGroupMembershipsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListGroupMembershipsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_MEMBER_LIST_FIELD,
            NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final List<GroupMember> groupMemberList;

    private final String nextToken;

    private final String requestId;

    private final Integer status;

    private ListGroupMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.groupMemberList = builder.groupMemberList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The list of the members of the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of the members of the group.
     */
    public List<GroupMember> groupMemberList() {
        return groupMemberList;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent request.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The http status of the request.
     * </p>
     * 
     * @return The http status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupMemberList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembershipsResponse)) {
            return false;
        }
        ListGroupMembershipsResponse other = (ListGroupMembershipsResponse) obj;
        return Objects.equals(groupMemberList(), other.groupMemberList()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    @Override
    public String toString() {
        return ToString.builder("ListGroupMembershipsResponse").add("GroupMemberList", groupMemberList())
                .add("NextToken", nextToken()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupMemberList":
            return Optional.ofNullable(clazz.cast(groupMemberList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembershipsResponse, T> g) {
        return obj -> g.apply((ListGroupMembershipsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupMembershipsResponse> {
        /**
         * <p>
         * The list of the members of the group.
         * </p>
         * 
         * @param groupMemberList
         *        The list of the members of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupMemberList(Collection<GroupMember> groupMemberList);

        /**
         * <p>
         * The list of the members of the group.
         * </p>
         * 
         * @param groupMemberList
         *        The list of the members of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupMemberList(GroupMember... groupMemberList);

        /**
         * <p>
         * The list of the members of the group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupMember>.Builder} avoiding the need to
         * create one manually via {@link List<GroupMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupMember>.Builder#build()} is called immediately and its
         * result is passed to {@link #groupMemberList(List<GroupMember>)}.
         * 
         * @param groupMemberList
         *        a consumer that will call methods on {@link List<GroupMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupMemberList(List<GroupMember>)
         */
        Builder groupMemberList(Consumer<GroupMember.Builder>... groupMemberList);

        /**
         * <p>
         * A pagination token that can be used in a subsequent request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The http status of the request.
         * </p>
         * 
         * @param status
         *        The http status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<GroupMember> groupMemberList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembershipsResponse model) {
            super(model);
            groupMemberList(model.groupMemberList);
            nextToken(model.nextToken);
            requestId(model.requestId);
            status(model.status);
        }

        public final Collection<GroupMember.Builder> getGroupMemberList() {
            return groupMemberList != null ? groupMemberList.stream().map(GroupMember::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder groupMemberList(Collection<GroupMember> groupMemberList) {
            this.groupMemberList = GroupMemberListCopier.copy(groupMemberList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupMemberList(GroupMember... groupMemberList) {
            groupMemberList(Arrays.asList(groupMemberList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupMemberList(Consumer<GroupMember.Builder>... groupMemberList) {
            groupMemberList(Stream.of(groupMemberList).map(c -> GroupMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGroupMemberList(Collection<GroupMember.BuilderImpl> groupMemberList) {
            this.groupMemberList = GroupMemberListCopier.copyFromBuilder(groupMemberList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListGroupMembershipsResponse build() {
            return new ListGroupMembershipsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
