/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.TagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.TagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.UntagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.UntagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher;

/**
 * Service client for accessing Amazon QuickSight asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon QuickSight API Reference</fullname>
 * <p>
 * Amazon QuickSight is a fully managed, serverless, cloud business intelligence service that makes it easy to extend
 * data and insights to every user in your organization. This API interface reference contains documentation for a
 * programming interface that you can use to manage Amazon QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface QuickSightAsyncClient extends SdkClient {
    String SERVICE_NAME = "quicksight";

    /**
     * Create a {@link QuickSightAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QuickSightAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QuickSightAsyncClient}.
     */
    static QuickSightAsyncClientBuilder builder() {
        return new DefaultQuickSightAsyncClientBuilder();
    }

    /**
     * <p>
     * Cancels an on-going ingestion of data into SPICE.
     * </p>
     *
     * @param cancelIngestionRequest
     * @return A Java Future containing the result of the CancelIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CancelIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelIngestionResponse> cancelIngestion(CancelIngestionRequest cancelIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an on-going ingestion of data into SPICE.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link CancelIngestionRequest#builder()}
     * </p>
     *
     * @param cancelIngestionRequest
     *        A {@link Consumer} that will call methods on {@link CancelIngestionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CancelIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelIngestionResponse> cancelIngestion(
            Consumer<CancelIngestionRequest.Builder> cancelIngestionRequest) {
        return cancelIngestion(CancelIngestionRequest.builder().applyMutation(cancelIngestionRequest).build());
    }

    /**
     * <p>
     * Creates a dashboard from a template. To first create a template, see the CreateTemplate API.
     * </p>
     * <p>
     * A dashboard is an entity in QuickSight which identifies Quicksight reports, created from analyses. QuickSight
     * dashboards are sharable. With the right permissions, you can create scheduled email reports from them. The
     * <code>CreateDashboard</code>, <code>DescribeDashboard</code> and <code>ListDashboardsByUser</code> APIs act on
     * the dashboard entity. If you have the correct permissions, you can create a dashboard from a template that exists
     * in a different AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-dashboard --cli-input-json file://create-dashboard.json</code>
     * </p>
     *
     * @param createDashboardRequest
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dashboard from a template. To first create a template, see the CreateTemplate API.
     * </p>
     * <p>
     * A dashboard is an entity in QuickSight which identifies Quicksight reports, created from analyses. QuickSight
     * dashboards are sharable. With the right permissions, you can create scheduled email reports from them. The
     * <code>CreateDashboard</code>, <code>DescribeDashboard</code> and <code>ListDashboardsByUser</code> APIs act on
     * the dashboard entity. If you have the correct permissions, you can create a dashboard from a template that exists
     * in a different AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-dashboard --cli-input-json file://create-dashboard.json</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDashboardRequest#builder()}
     * </p>
     *
     * @param createDashboardRequest
     *        A {@link Consumer} that will call methods on {@link CreateDashboardRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDashboardResponse> createDashboard(
            Consumer<CreateDashboardRequest.Builder> createDashboardRequest) {
        return createDashboard(CreateDashboardRequest.builder().applyMutation(createDashboardRequest).build());
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     * <p>
     * <code>--name='My dataset' \</code>
     * </p>
     * <p>
     * <code>--import-mode=SPICE \</code>
     * </p>
     * <p>
     * <code>--physical-table-map='{</code>
     * </p>
     * <p>
     * <code> "physical-table-id": {</code>
     * </p>
     * <p>
     * <code> "RelationalTable": {</code>
     * </p>
     * <p>
     * <code> "DataSourceArn": "arn:aws:quicksight:us-west-2:111111111111:datasource/data-source-id",</code>
     * </p>
     * <p>
     * <code> "Name": "table1",</code>
     * </p>
     * <p>
     * <code> "InputColumns": [</code>
     * </p>
     * <p>
     * <code> {</code>
     * </p>
     * <p>
     * <code> "Name": "column1",</code>
     * </p>
     * <p>
     * <code> "Type": "STRING"</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> ]</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> }'</code>
     * </p>
     *
     * @param createDataSetRequest
     * @return A Java Future containing the result of the CreateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSetResponse> createDataSet(CreateDataSetRequest createDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     * <p>
     * <code>--name='My dataset' \</code>
     * </p>
     * <p>
     * <code>--import-mode=SPICE \</code>
     * </p>
     * <p>
     * <code>--physical-table-map='{</code>
     * </p>
     * <p>
     * <code> "physical-table-id": {</code>
     * </p>
     * <p>
     * <code> "RelationalTable": {</code>
     * </p>
     * <p>
     * <code> "DataSourceArn": "arn:aws:quicksight:us-west-2:111111111111:datasource/data-source-id",</code>
     * </p>
     * <p>
     * <code> "Name": "table1",</code>
     * </p>
     * <p>
     * <code> "InputColumns": [</code>
     * </p>
     * <p>
     * <code> {</code>
     * </p>
     * <p>
     * <code> "Name": "column1",</code>
     * </p>
     * <p>
     * <code> "Type": "STRING"</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> ]</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> }'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDataSetRequest#builder()}
     * </p>
     *
     * @param createDataSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataSetResponse> createDataSet(Consumer<CreateDataSetRequest.Builder> createDataSetRequest) {
        return createDataSet(CreateDataSetRequest.builder().applyMutation(createDataSetRequest).build());
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-data-source \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id \</code>
     * </p>
     * <p>
     * <code>--name='My Data Source' \</code>
     * </p>
     * <p>
     * <code>--type=POSTGRESQL \</code>
     * </p>
     * <p>
     * <code>--data-source-parameters='{ "PostgreSqlParameters": {</code>
     * </p>
     * <p>
     * <code> "Host": "my-db-host.example.com",</code>
     * </p>
     * <p>
     * <code> "Port": 1234,</code>
     * </p>
     * <p>
     * <code> "Database": "my-db" } }' \</code>
     * </p>
     * <p>
     * <code>--credentials='{ "CredentialPair": {</code>
     * </p>
     * <p>
     * <code> "Username": "username",</code>
     * </p>
     * <p>
     * <code> "Password": "password" } }'</code>
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-data-source \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id \</code>
     * </p>
     * <p>
     * <code>--name='My Data Source' \</code>
     * </p>
     * <p>
     * <code>--type=POSTGRESQL \</code>
     * </p>
     * <p>
     * <code>--data-source-parameters='{ "PostgreSqlParameters": {</code>
     * </p>
     * <p>
     * <code> "Host": "my-db-host.example.com",</code>
     * </p>
     * <p>
     * <code> "Port": 1234,</code>
     * </p>
     * <p>
     * <code> "Database": "my-db" } }' \</code>
     * </p>
     * <p>
     * <code>--credentials='{ "CredentialPair": {</code>
     * </p>
     * <p>
     * <code> "Username": "username",</code>
     * </p>
     * <p>
     * <code> "Password": "password" } }'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(
            Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest) {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight create-group --aws-account-id=111122223333 --namespace=default --group-name="Sales-Management" --description="Sales Management - Forecasting" </code>
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight create-group --aws-account-id=111122223333 --namespace=default --group-name="Sales-Management" --description="Sales Management - Forecasting" </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request. The
     *        request object for this operation.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * The response is the group member object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight create-group-membership --aws-account-id=111122223333 --namespace=default --group-name=Sales --member-name=Pat </code>
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            CreateGroupMembershipRequest createGroupMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * The response is the group member object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight create-group-membership --aws-account-id=111122223333 --namespace=default --group-name=Sales --member-name=Pat </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupMembershipRequest#builder()}
     * </p>
     *
     * @param createGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            Consumer<CreateGroupMembershipRequest.Builder> createGroupMembershipRequest) {
        return createGroupMembership(CreateGroupMembershipRequest.builder().applyMutation(createGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy ARN and will assigned to specified groups or users of
     * QuickSight. Users and groups need to be in the same namespace.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=helpAssignment --policy-arn=arn:aws:iam::aws:policy/AdministratorAccess --identities="user=user5,engineer123,group=QS-Admin" --namespace=default --region=us-west-2</code>
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the CreateIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIamPolicyAssignmentResponse> createIAMPolicyAssignment(
            CreateIamPolicyAssignmentRequest createIamPolicyAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy ARN and will assigned to specified groups or users of
     * QuickSight. Users and groups need to be in the same namespace.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=helpAssignment --policy-arn=arn:aws:iam::aws:policy/AdministratorAccess --identities="user=user5,engineer123,group=QS-Admin" --namespace=default --region=us-west-2</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIamPolicyAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateIAMPolicyAssignmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIamPolicyAssignmentResponse> createIAMPolicyAssignment(
            Consumer<CreateIamPolicyAssignmentRequest.Builder> createIamPolicyAssignmentRequest) {
        return createIAMPolicyAssignment(CreateIamPolicyAssignmentRequest.builder()
                .applyMutation(createIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion on a dataset
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access-control. For an
     * example, see <a href="https://aws.example.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a>. Tags will be visible on the
     * tagged dataset, but not on the ingestion resource.
     * </p>
     *
     * @param createIngestionRequest
     * @return A Java Future containing the result of the CreateIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIngestionResponse> createIngestion(CreateIngestionRequest createIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion on a dataset
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access-control. For an
     * example, see <a href="https://aws.example.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a>. Tags will be visible on the
     * tagged dataset, but not on the ingestion resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIngestionRequest#builder()}
     * </p>
     *
     * @param createIngestionRequest
     *        A {@link Consumer} that will call methods on {@link CreateIngestionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIngestionResponse> createIngestion(
            Consumer<CreateIngestionRequest.Builder> createIngestionRequest) {
        return createIngestion(CreateIngestionRequest.builder().applyMutation(createIngestionRequest).build());
    }

    /**
     * <p>
     * Creates a template from an existing QuickSight analysis or template. The resulting template can be used to create
     * a dashboard.
     * </p>
     * <p>
     * A template is an entity in QuickSight which encapsulates the metadata required to create an analysis that can be
     * used to create dashboard. It adds a layer of abstraction by use placeholders to replace the dataset associated
     * with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets
     * which follow the same schema that was used to create the source analysis and template.
     * </p>
     * <p>
     * To create a template from an existing analysis, use the analysis's ARN, <code>aws-account-id</code>,
     * <code>template-id</code>, <code>source-entity</code>, and <code>data-set-references</code>.
     * </p>
     * <p>
     * CLI syntax to create a template:
     * </p>
     * <p>
     * <code>aws quicksight create-template —cli-input-json file://create-template.json</code>
     * </p>
     * <p>
     * CLI syntax to create a template from another template in the same AWS account:
     * </p>
     * <p>
     * <code>aws quicksight create-template --aws-account-id 111122223333 --template-id reports_test_template --data-set-references DataSetPlaceholder=reports,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/0dfc789c-81f6-4f4f-b9ac-7db2453eefc8 DataSetPlaceholder=Elblogs,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/f60da323-af68-45db-9016-08e0d1d7ded5 --source-entity SourceAnalysis='{Arn=arn:aws:quicksight:us-west-2:111122223333:analysis/7fb74527-c36d-4be8-8139-ac1be4c97365}'</code>
     * </p>
     * <p>
     * To create template from another account’s template, you need to grant cross account resource permission for
     * DescribeTemplate the account that contains the template.
     * </p>
     * <p>
     * You can use a file to pass JSON to the function if you prefer.
     * </p>
     *
     * @param createTemplateRequest
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTemplateResponse> createTemplate(CreateTemplateRequest createTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a template from an existing QuickSight analysis or template. The resulting template can be used to create
     * a dashboard.
     * </p>
     * <p>
     * A template is an entity in QuickSight which encapsulates the metadata required to create an analysis that can be
     * used to create dashboard. It adds a layer of abstraction by use placeholders to replace the dataset associated
     * with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets
     * which follow the same schema that was used to create the source analysis and template.
     * </p>
     * <p>
     * To create a template from an existing analysis, use the analysis's ARN, <code>aws-account-id</code>,
     * <code>template-id</code>, <code>source-entity</code>, and <code>data-set-references</code>.
     * </p>
     * <p>
     * CLI syntax to create a template:
     * </p>
     * <p>
     * <code>aws quicksight create-template —cli-input-json file://create-template.json</code>
     * </p>
     * <p>
     * CLI syntax to create a template from another template in the same AWS account:
     * </p>
     * <p>
     * <code>aws quicksight create-template --aws-account-id 111122223333 --template-id reports_test_template --data-set-references DataSetPlaceholder=reports,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/0dfc789c-81f6-4f4f-b9ac-7db2453eefc8 DataSetPlaceholder=Elblogs,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/f60da323-af68-45db-9016-08e0d1d7ded5 --source-entity SourceAnalysis='{Arn=arn:aws:quicksight:us-west-2:111122223333:analysis/7fb74527-c36d-4be8-8139-ac1be4c97365}'</code>
     * </p>
     * <p>
     * To create template from another account’s template, you need to grant cross account resource permission for
     * DescribeTemplate the account that contains the template.
     * </p>
     * <p>
     * You can use a file to pass JSON to the function if you prefer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTemplateRequest#builder()}
     * </p>
     *
     * @param createTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTemplateResponse> createTemplate(Consumer<CreateTemplateRequest.Builder> createTemplateRequest) {
        return createTemplate(CreateTemplateRequest.builder().applyMutation(createTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name PROD —version-number 1</code>
     * </p>
     *
     * @param createTemplateAliasRequest
     * @return A Java Future containing the result of the CreateTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTemplateAliasResponse> createTemplateAlias(
            CreateTemplateAliasRequest createTemplateAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight create-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name PROD —version-number 1</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTemplateAliasRequest#builder()}
     * </p>
     *
     * @param createTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateTemplateAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTemplateAliasResponse> createTemplateAlias(
            Consumer<CreateTemplateAliasRequest.Builder> createTemplateAliasRequest) {
        return createTemplateAlias(CreateTemplateAliasRequest.builder().applyMutation(createTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-dashboard --aws-account-id 111122223333 —dashboard-id 123123123</code>
     * </p>
     * <p>
     * <code>aws quicksight delete-dashboard --aws-account-id 111122223333 —dashboard-id 123123123 —version-number 3</code>
     * </p>
     *
     * @param deleteDashboardRequest
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-dashboard --aws-account-id 111122223333 —dashboard-id 123123123</code>
     * </p>
     * <p>
     * <code>aws quicksight delete-dashboard --aws-account-id 111122223333 —dashboard-id 123123123 —version-number 3</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDashboardRequest#builder()}
     * </p>
     *
     * @param deleteDashboardRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDashboardRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDashboardResponse> deleteDashboard(
            Consumer<DeleteDashboardRequest.Builder> deleteDashboardRequest) {
        return deleteDashboard(DeleteDashboardRequest.builder().applyMutation(deleteDashboardRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111111111111 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id</code>
     * </p>
     *
     * @param deleteDataSetRequest
     * @return A Java Future containing the result of the DeleteDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSetResponse> deleteDataSet(DeleteDataSetRequest deleteDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111111111111 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDataSetRequest#builder()}
     * </p>
     *
     * @param deleteDataSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataSetResponse> deleteDataSet(Consumer<DeleteDataSetRequest.Builder> deleteDataSetRequest) {
        return deleteDataSet(DeleteDataSetRequest.builder().applyMutation(deleteDataSetRequest).build());
    }

    /**
     * <p>
     * Deletes the data source permanently. This action breaks all the datasets that reference the deleted data source.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-data-source \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id </code>
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the data source permanently. This action breaks all the datasets that reference the deleted data source.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-data-source \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-group -\-aws-account-id=111122223333 -\-namespace=default -\-group-name=Sales-Management </code>
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-group -\-aws-account-id=111122223333 -\-namespace=default -\-group-name=Sales-Management </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-group-membership --aws-account-id=111122223333 --namespace=default --group-name=Sales-Management --member-name=Charlie </code>
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            DeleteGroupMembershipRequest deleteGroupMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-group-membership --aws-account-id=111122223333 --namespace=default --group-name=Sales-Management --member-name=Charlie </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGroupMembershipRequest#builder()}
     * </p>
     *
     * @param deleteGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            Consumer<DeleteGroupMembershipRequest.Builder> deleteGroupMembershipRequest) {
        return deleteGroupMembership(DeleteGroupMembershipRequest.builder().applyMutation(deleteGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes an existing assignment.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=testtest --region=us-east-1 --namespace=default</code>
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the DeleteIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIamPolicyAssignmentResponse> deleteIAMPolicyAssignment(
            DeleteIamPolicyAssignmentRequest deleteIamPolicyAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing assignment.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=testtest --region=us-east-1 --namespace=default</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIamPolicyAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIAMPolicyAssignmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIamPolicyAssignmentResponse> deleteIAMPolicyAssignment(
            Consumer<DeleteIamPolicyAssignmentRequest.Builder> deleteIamPolicyAssignmentRequest) {
        return deleteIAMPolicyAssignment(DeleteIamPolicyAssignmentRequest.builder()
                .applyMutation(deleteIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight delete-template --aws-account-id 111122223333 —-template-id reports_test_template --version-number 2 </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight delete-template —aws-account-id 111122223333 —template-id reports_test_template —alias-name STAGING </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight delete-template —aws-account-id 111122223333 —template-id reports_test_template —alias-name ‘\&#36LATEST’ </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight delete-template --aws-account-id 111122223333 —-template-id reports_test_template</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If version number which is an optional field is not passed the template (including all the versions) is deleted
     * by the API, if version number is provided, the specific template version is deleted by the API.
     * </p>
     * <p>
     * Users can explicitly describe the latest version of the template by passing <code>&#36LATEST</code> to the
     * <code>alias-name</code> parameter. <code>&#36LATEST</code> is an internally supported alias, which points to the
     * latest version of the template.
     * </p>
     *
     * @param deleteTemplateRequest
     * @return A Java Future containing the result of the DeleteTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTemplateResponse> deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight delete-template --aws-account-id 111122223333 —-template-id reports_test_template --version-number 2 </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight delete-template —aws-account-id 111122223333 —template-id reports_test_template —alias-name STAGING </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight delete-template —aws-account-id 111122223333 —template-id reports_test_template —alias-name ‘\&#36LATEST’ </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight delete-template --aws-account-id 111122223333 —-template-id reports_test_template</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If version number which is an optional field is not passed the template (including all the versions) is deleted
     * by the API, if version number is provided, the specific template version is deleted by the API.
     * </p>
     * <p>
     * Users can explicitly describe the latest version of the template by passing <code>&#36LATEST</code> to the
     * <code>alias-name</code> parameter. <code>&#36LATEST</code> is an internally supported alias, which points to the
     * latest version of the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTemplateRequest#builder()}
     * </p>
     *
     * @param deleteTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTemplateResponse> deleteTemplate(Consumer<DeleteTemplateRequest.Builder> deleteTemplateRequest) {
        return deleteTemplate(DeleteTemplateRequest.builder().applyMutation(deleteTemplateRequest).build());
    }

    /**
     * <p>
     * Update template alias of given template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name 'STAGING'</code>
     * </p>
     *
     * @param deleteTemplateAliasRequest
     * @return A Java Future containing the result of the DeleteTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTemplateAliasResponse> deleteTemplateAlias(
            DeleteTemplateAliasRequest deleteTemplateAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update template alias of given template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight delete-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name 'STAGING'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTemplateAliasRequest#builder()}
     * </p>
     *
     * @param deleteTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTemplateAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTemplateAliasResponse> deleteTemplateAlias(
            Consumer<DeleteTemplateAliasRequest.Builder> deleteTemplateAliasRequest) {
        return deleteTemplateAlias(DeleteTemplateAliasRequest.builder().applyMutation(deleteTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-user --aws-account-id=111122223333 --namespace=default --user-name=Pat </code>
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-user --aws-account-id=111122223333 --namespace=default --user-name=Pat </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-user-by-principal-id --aws-account-id=111122223333 --namespace=default --principal-id=ABCDEFJA26JLI7EUUOEHS </code>
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     * @return A Java Future containing the result of the DeleteUserByPrincipalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUserByPrincipalId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserByPrincipalIdResponse> deleteUserByPrincipalId(
            DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight delete-user-by-principal-id --aws-account-id=111122223333 --namespace=default --principal-id=ABCDEFJA26JLI7EUUOEHS </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserByPrincipalIdRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteUserByPrincipalIdRequest#builder()}
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserByPrincipalIdRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserByPrincipalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUserByPrincipalId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserByPrincipalIdResponse> deleteUserByPrincipalId(
            Consumer<DeleteUserByPrincipalIdRequest.Builder> deleteUserByPrincipalIdRequest) {
        return deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest.builder().applyMutation(deleteUserByPrincipalIdRequest)
                .build());
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight describe-dashboard --aws-account-id 111122223333 —dashboard-id reports_test_report -version-number 2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> aws quicksight describe-dashboard --aws-account-id 111122223333 —dashboard-id reports_test_report -alias-name ‘&#36PUBLISHED’ </code>
     * </p>
     * </li>
     * </ul>
     * <p/>
     *
     * @param describeDashboardRequest
     * @return A Java Future containing the result of the DescribeDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li> <li>
     *         ResourceNotFoundException One or more resources can't be found.</li> <li>AccessDeniedException You don't
     *         have access to this. The provided credentials couldn't be validated. You might not be authorized to carry
     *         out the request. Ensure that your account is authorized to use the Amazon QuickSight service, that your
     *         policies have the correct permissions, and that you are using the correct access keys.</li> <li>
     *         ThrottlingException Access is throttled.</li> <li>UnsupportedUserEditionException This error indicates
     *         that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include
     *         support for that operation. Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not
     *         every operation and capability is available in every edition.</li> <li>InternalFailureException An
     *         internal failure occurred.</li> <li>SdkException Base class for all exceptions that can be thrown by the
     *         SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any
     *         client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDashboardResponse> describeDashboard(DescribeDashboardRequest describeDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight describe-dashboard --aws-account-id 111122223333 —dashboard-id reports_test_report -version-number 2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> aws quicksight describe-dashboard --aws-account-id 111122223333 —dashboard-id reports_test_report -alias-name ‘&#36PUBLISHED’ </code>
     * </p>
     * </li>
     * </ul>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDashboardRequest#builder()}
     * </p>
     *
     * @param describeDashboardRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDashboardRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDashboardResponse> describeDashboard(
            Consumer<DescribeDashboardRequest.Builder> describeDashboardRequest) {
        return describeDashboard(DescribeDashboardRequest.builder().applyMutation(describeDashboardRequest).build());
    }

    /**
     * <p>
     * Describes read and write permissions on a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-dashboard-permissions --aws-account-id 735340738645 —dashboard-id reports_test_bob_report</code>
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     * @return A Java Future containing the result of the DescribeDashboardPermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDashboardPermissionsResponse> describeDashboardPermissions(
            DescribeDashboardPermissionsRequest describeDashboardPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes read and write permissions on a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-dashboard-permissions --aws-account-id 735340738645 —dashboard-id reports_test_bob_report</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDashboardPermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDashboardPermissionsRequest#builder()}
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDashboardPermissionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDashboardPermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDashboardPermissionsResponse> describeDashboardPermissions(
            Consumer<DescribeDashboardPermissionsRequest.Builder> describeDashboardPermissionsRequest) {
        return describeDashboardPermissions(DescribeDashboardPermissionsRequest.builder()
                .applyMutation(describeDashboardPermissionsRequest).build());
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111111111111 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id</code>
     * </p>
     *
     * @param describeDataSetRequest
     * @return A Java Future containing the result of the DescribeDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataSetResponse> describeDataSet(DescribeDataSetRequest describeDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111111111111 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDataSetRequest#builder()}
     * </p>
     *
     * @param describeDataSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataSetResponse> describeDataSet(
            Consumer<DescribeDataSetRequest.Builder> describeDataSetRequest) {
        return describeDataSet(DescribeDataSetRequest.builder().applyMutation(describeDataSetRequest).build());
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-data-set-permissions \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     * @return A Java Future containing the result of the DescribeDataSetPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSetPermissionsResponse> describeDataSetPermissions(
            DescribeDataSetPermissionsRequest describeDataSetPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-data-set-permissions \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSetPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDataSetPermissionsRequest#builder()}
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSetPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDataSetPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSetPermissionsResponse> describeDataSetPermissions(
            Consumer<DescribeDataSetPermissionsRequest.Builder> describeDataSetPermissionsRequest) {
        return describeDataSetPermissions(DescribeDataSetPermissionsRequest.builder()
                .applyMutation(describeDataSetPermissionsRequest).build());
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     *
     * @param describeDataSourceRequest
     * @return A Java Future containing the result of the DescribeDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDataSourceResponse> describeDataSource(DescribeDataSourceRequest describeDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSourceRequest#builder()}
     * </p>
     *
     * @param describeDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDataSourceResponse> describeDataSource(
            Consumer<DescribeDataSourceRequest.Builder> describeDataSourceRequest) {
        return describeDataSource(DescribeDataSourceRequest.builder().applyMutation(describeDataSourceRequest).build());
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     * <p>
     * The permissions resource is <code>aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     * @return A Java Future containing the result of the DescribeDataSourcePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSourcePermissionsResponse> describeDataSourcePermissions(
            DescribeDataSourcePermissionsRequest describeDataSourcePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     * <p>
     * The permissions resource is <code>aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataSourcePermissionsRequest#builder()}
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourcePermissionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDataSourcePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSourcePermissionsResponse> describeDataSourcePermissions(
            Consumer<DescribeDataSourcePermissionsRequest.Builder> describeDataSourcePermissionsRequest) {
        return describeDataSourcePermissions(DescribeDataSourcePermissionsRequest.builder()
                .applyMutation(describeDataSourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is the group object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight describe-group -\-aws-account-id=11112222333 -\-namespace=default -\-group-name=Sales </code>
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is the group object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight describe-group -\-aws-account-id=11112222333 -\-namespace=default -\-group-name=Sales </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest) {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Describes an existing IAMPolicy Assignment by specified assignment name.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=testtest --namespace=default --region=us-east-1 </code>
     * </p>
     *
     * @param describeIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the DescribeIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIamPolicyAssignmentResponse> describeIAMPolicyAssignment(
            DescribeIamPolicyAssignmentRequest describeIamPolicyAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing IAMPolicy Assignment by specified assignment name.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=testtest --namespace=default --region=us-east-1 </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIamPolicyAssignmentRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param describeIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIAMPolicyAssignmentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIamPolicyAssignmentResponse> describeIAMPolicyAssignment(
            Consumer<DescribeIamPolicyAssignmentRequest.Builder> describeIamPolicyAssignmentRequest) {
        return describeIAMPolicyAssignment(DescribeIamPolicyAssignmentRequest.builder()
                .applyMutation(describeIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Describes a SPICE ingestion.
     * </p>
     *
     * @param describeIngestionRequest
     * @return A Java Future containing the result of the DescribeIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIngestionResponse> describeIngestion(DescribeIngestionRequest describeIngestionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a SPICE ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeIngestionRequest#builder()}
     * </p>
     *
     * @param describeIngestionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIngestionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIngestionResponse> describeIngestion(
            Consumer<DescribeIngestionRequest.Builder> describeIngestionRequest) {
        return describeIngestion(DescribeIngestionRequest.builder().applyMutation(describeIngestionRequest).build());
    }

    /**
     * <p>
     * Describes a template's metadata.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-template --aws-account-id 111122223333 --template-id reports_test_template </code>
     * </p>
     * <p>
     * <code>aws quicksight describe-template --aws-account-id 111122223333 --template-id reports_test_template --version-number-2</code>
     * </p>
     * <p>
     * <code>aws quicksight describe-template --aws-account-id 111122223333 --template-id reports_test_template --alias-name '\&#36LATEST' </code>
     * </p>
     * <p>
     * Users can explicitly describe the latest version of the dashboard by passing <code>&#36LATEST</code> to the
     * <code>alias-name</code> parameter. <code>&#36LATEST</code> is an internally supported alias, which points to the
     * latest version of the dashboard.
     * </p>
     *
     * @param describeTemplateRequest
     * @return A Java Future containing the result of the DescribeTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTemplateResponse> describeTemplate(DescribeTemplateRequest describeTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a template's metadata.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-template --aws-account-id 111122223333 --template-id reports_test_template </code>
     * </p>
     * <p>
     * <code>aws quicksight describe-template --aws-account-id 111122223333 --template-id reports_test_template --version-number-2</code>
     * </p>
     * <p>
     * <code>aws quicksight describe-template --aws-account-id 111122223333 --template-id reports_test_template --alias-name '\&#36LATEST' </code>
     * </p>
     * <p>
     * Users can explicitly describe the latest version of the dashboard by passing <code>&#36LATEST</code> to the
     * <code>alias-name</code> parameter. <code>&#36LATEST</code> is an internally supported alias, which points to the
     * latest version of the dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTemplateRequest#builder()}
     * </p>
     *
     * @param describeTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTemplateResponse> describeTemplate(
            Consumer<DescribeTemplateRequest.Builder> describeTemplateRequest) {
        return describeTemplate(DescribeTemplateRequest.builder().applyMutation(describeTemplateRequest).build());
    }

    /**
     * <p>
     * Describes the template aliases of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name 'STAGING'</code>
     * </p>
     *
     * @param describeTemplateAliasRequest
     * @return A Java Future containing the result of the DescribeTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTemplateAliasResponse> describeTemplateAlias(
            DescribeTemplateAliasRequest describeTemplateAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the template aliases of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name 'STAGING'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTemplateAliasRequest#builder()}
     * </p>
     *
     * @param describeTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTemplateAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTemplateAliasResponse> describeTemplateAlias(
            Consumer<DescribeTemplateAliasRequest.Builder> describeTemplateAliasRequest) {
        return describeTemplateAlias(DescribeTemplateAliasRequest.builder().applyMutation(describeTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Describes read and write permissions on a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-template-permissions —aws-account-id 735340738645 —template-id reports_test_template</code>
     * </p>
     *
     * @param describeTemplatePermissionsRequest
     * @return A Java Future containing the result of the DescribeTemplatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTemplatePermissionsResponse> describeTemplatePermissions(
            DescribeTemplatePermissionsRequest describeTemplatePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes read and write permissions on a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight describe-template-permissions —aws-account-id 735340738645 —template-id reports_test_template</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTemplatePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTemplatePermissionsRequest#builder()}
     * </p>
     *
     * @param describeTemplatePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTemplatePermissionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeTemplatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTemplatePermissionsResponse> describeTemplatePermissions(
            Consumer<DescribeTemplatePermissionsRequest.Builder> describeTemplatePermissionsRequest) {
        return describeTemplatePermissions(DescribeTemplatePermissionsRequest.builder()
                .applyMutation(describeTemplatePermissionsRequest).build());
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon Resource Name (ARN), AWS Identity and Access
     * Management (IAM) role, and email address.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight describe-user --aws-account-id=111122223333 --namespace=default --user-name=Pat </code>
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon Resource Name (ARN), AWS Identity and Access
     * Management (IAM) role, and email address.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight describe-user --aws-account-id=111122223333 --namespace=default --user-name=Pat </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Generates a server-side embeddable URL and authorization code. Before this can work properly, first you need to
     * configure the dashboards and user permissions. For more information, see <a
     * href="https://docs.aws.example.com/en_us/quicksight/latest/user/embedding.html"> Embedding Amazon QuickSight
     * Dashboards</a>.
     * </p>
     * <p>
     * Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user’s browser.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * Assume the role with permissions enabled for actions: <code>quickSight:RegisterUser</code> and
     * <code>quicksight:GetDashboardEmbedURL</code>. You can use assume-role, assume-role-with-web-identity, or
     * assume-role-with-saml.
     * </p>
     * <p>
     * <code>aws sts assume-role --role-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role" --role-session-name embeddingsession</code>
     * </p>
     * <p>
     * If the user does not exist in QuickSight, register the user:
     * </p>
     * <p>
     * <code>aws quicksight register-user --aws-account-id 111122223333 --namespace default --identity-type IAM --iam-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role" --user-role READER --session-name "embeddingsession" --email user123@example.com --region us-east-1</code>
     * </p>
     * <p>
     * Get the URL for the embedded dashboard (<code>IAM</code> identity authentication):
     * </p>
     * <p>
     * <code>aws quicksight get-dashboard-embed-url --aws-account-id 111122223333 --dashboard-id 1a1ac2b2-3fc3-4b44-5e5d-c6db6778df89 --identity-type IAM</code>
     * </p>
     * <p>
     * Get the URL for the embedded dashboard (<code>QUICKSIGHT</code> identity authentication):
     * </p>
     * <p>
     * <code>aws quicksight get-dashboard-embed-url --aws-account-id 111122223333 --dashboard-id 1a1ac2b2-3fc3-4b44-5e5d-c6db6778df89 --identity-type QUICKSIGHT --user-arn arn:aws:quicksight:us-east-1:111122223333:user/default/embedding_quicksight_dashboard_role/embeddingsession</code>
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     * @return A Java Future containing the result of the GetDashboardEmbedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>DomainNotWhitelistedException The domain specified is not on the allowlist. All domains for embedded
     *         dashboards must be added to the approved list by an Amazon QuickSight admin.</li>
     *         <li>QuickSightUserNotFoundException The user is not found. This error can happen in any operation that
     *         requires finding a user based on a provided user name, such as <code>DeleteUser</code>,
     *         <code>DescribeUser</code>, and so on.</li>
     *         <li>IdentityTypeNotSupportedException The identity type specified is not supported. Supported identity
     *         types include IAM and QUICKSIGHT.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session is not valid. The session lifetime must be from 15 to 600 minutes.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDashboardEmbedUrlResponse> getDashboardEmbedUrl(
            GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a server-side embeddable URL and authorization code. Before this can work properly, first you need to
     * configure the dashboards and user permissions. For more information, see <a
     * href="https://docs.aws.example.com/en_us/quicksight/latest/user/embedding.html"> Embedding Amazon QuickSight
     * Dashboards</a>.
     * </p>
     * <p>
     * Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user’s browser.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * Assume the role with permissions enabled for actions: <code>quickSight:RegisterUser</code> and
     * <code>quicksight:GetDashboardEmbedURL</code>. You can use assume-role, assume-role-with-web-identity, or
     * assume-role-with-saml.
     * </p>
     * <p>
     * <code>aws sts assume-role --role-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role" --role-session-name embeddingsession</code>
     * </p>
     * <p>
     * If the user does not exist in QuickSight, register the user:
     * </p>
     * <p>
     * <code>aws quicksight register-user --aws-account-id 111122223333 --namespace default --identity-type IAM --iam-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role" --user-role READER --session-name "embeddingsession" --email user123@example.com --region us-east-1</code>
     * </p>
     * <p>
     * Get the URL for the embedded dashboard (<code>IAM</code> identity authentication):
     * </p>
     * <p>
     * <code>aws quicksight get-dashboard-embed-url --aws-account-id 111122223333 --dashboard-id 1a1ac2b2-3fc3-4b44-5e5d-c6db6778df89 --identity-type IAM</code>
     * </p>
     * <p>
     * Get the URL for the embedded dashboard (<code>QUICKSIGHT</code> identity authentication):
     * </p>
     * <p>
     * <code>aws quicksight get-dashboard-embed-url --aws-account-id 111122223333 --dashboard-id 1a1ac2b2-3fc3-4b44-5e5d-c6db6778df89 --identity-type QUICKSIGHT --user-arn arn:aws:quicksight:us-east-1:111122223333:user/default/embedding_quicksight_dashboard_role/embeddingsession</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDashboardEmbedUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetDashboardEmbedUrlRequest#builder()}
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetDashboardEmbedUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDashboardEmbedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>DomainNotWhitelistedException The domain specified is not on the allowlist. All domains for embedded
     *         dashboards must be added to the approved list by an Amazon QuickSight admin.</li>
     *         <li>QuickSightUserNotFoundException The user is not found. This error can happen in any operation that
     *         requires finding a user based on a provided user name, such as <code>DeleteUser</code>,
     *         <code>DescribeUser</code>, and so on.</li>
     *         <li>IdentityTypeNotSupportedException The identity type specified is not supported. Supported identity
     *         types include IAM and QUICKSIGHT.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session is not valid. The session lifetime must be from 15 to 600 minutes.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDashboardEmbedUrlResponse> getDashboardEmbedUrl(
            Consumer<GetDashboardEmbedUrlRequest.Builder> getDashboardEmbedUrlRequest) {
        return getDashboardEmbedUrl(GetDashboardEmbedUrlRequest.builder().applyMutation(getDashboardEmbedUrlRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Quicksight subscription.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions —aws-account-id 111122223333 —template-id reports-test-template
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return A Java Future containing the result of the ListDashboardVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDashboardVersionsResponse> listDashboardVersions(
            ListDashboardVersionsRequest listDashboardVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Quicksight subscription.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions —aws-account-id 111122223333 —template-id reports-test-template
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDashboardVersionsRequest#builder()}
     * </p>
     *
     * @param listDashboardVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDashboardVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDashboardVersionsResponse> listDashboardVersions(
            Consumer<ListDashboardVersionsRequest.Builder> listDashboardVersionsRequest) {
        return listDashboardVersions(ListDashboardVersionsRequest.builder().applyMutation(listDashboardVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Quicksight subscription.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions —aws-account-id 111122223333 —template-id reports-test-template
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher publisher = client.listDashboardVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher publisher = client.listDashboardVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDashboardVersionsPublisher listDashboardVersionsPaginator(
            ListDashboardVersionsRequest listDashboardVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Quicksight subscription.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions —aws-account-id 111122223333 —template-id reports-test-template
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher publisher = client.listDashboardVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher publisher = client.listDashboardVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDashboardVersionsRequest#builder()}
     * </p>
     *
     * @param listDashboardVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDashboardVersionsPublisher listDashboardVersionsPaginator(
            Consumer<ListDashboardVersionsRequest.Builder> listDashboardVersionsRequest) {
        return listDashboardVersionsPaginator(ListDashboardVersionsRequest.builder().applyMutation(listDashboardVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists dashboards in the AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-dashboards --aws-account-id 111122223333 --max-results 5 —next-token 'next-10'</code>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists dashboards in the AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-dashboards --aws-account-id 111122223333 --max-results 5 —next-token 'next-10'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDashboardsResponse> listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) {
        return listDashboards(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Lists dashboards in the AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-dashboards --aws-account-id 111122223333 --max-results 5 —next-token 'next-10'</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation.</b>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDashboardsPublisher listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists dashboards in the AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-dashboards --aws-account-id 111122223333 --max-results 5 —next-token 'next-10'</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDashboardsPublisher listDashboardsPaginator(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) {
        return listDashboardsPaginator(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Lists all of the datasets belonging to this account in an AWS region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sets --aws-account-id=111111111111</code>
     * </p>
     *
     * @param listDataSetsRequest
     * @return A Java Future containing the result of the ListDataSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSetsResponse> listDataSets(ListDataSetsRequest listDataSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the datasets belonging to this account in an AWS region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sets --aws-account-id=111111111111</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSetsResponse> listDataSets(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest) {
        return listDataSets(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * Lists all of the datasets belonging to this account in an AWS region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sets --aws-account-id=111111111111</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param listDataSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsPublisher listDataSetsPaginator(ListDataSetsRequest listDataSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the datasets belonging to this account in an AWS region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sets --aws-account-id=111111111111</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsPublisher listDataSetsPaginator(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest) {
        return listDataSetsPaginator(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * Lists data sources in current AWS region that belong to this AWS account.
     * </p>
     * <p>
     * The permissions resource is: <code>arn:aws:quicksight:region:aws-account-id:datasource/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sources --aws-account-id=111122223333</code>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data sources in current AWS region that belong to this AWS account.
     * </p>
     * <p>
     * The permissions resource is: <code>arn:aws:quicksight:region:aws-account-id:datasource/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sources --aws-account-id=111122223333</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists data sources in current AWS region that belong to this AWS account.
     * </p>
     * <p>
     * The permissions resource is: <code>arn:aws:quicksight:region:aws-account-id:datasource/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sources --aws-account-id=111122223333</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data sources in current AWS region that belong to this AWS account.
     * </p>
     * <p>
     * The permissions resource is: <code>arn:aws:quicksight:region:aws-account-id:datasource/*</code>
     * </p>
     * <p>
     * CLI syntax: <code>aws quicksight list-data-sources --aws-account-id=111122223333</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a list of group member objects.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-group-memberships -\-aws-account-id=111122223333 -\-namespace=default </code>
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return A Java Future containing the result of the ListGroupMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsResponse> listGroupMemberships(
            ListGroupMembershipsRequest listGroupMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a list of group member objects.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-group-memberships -\-aws-account-id=111122223333 -\-namespace=default </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupMembershipsRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGroupMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsResponse> listGroupMemberships(
            Consumer<ListGroupMembershipsRequest.Builder> listGroupMembershipsRequest) {
        return listGroupMemberships(ListGroupMembershipsRequest.builder().applyMutation(listGroupMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*</code>.
     * </p>
     * <p>
     * The response is a list of group objects.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-groups -\-aws-account-id=111122223333 -\-namespace=default </code>
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*</code>.
     * </p>
     * <p>
     * The response is a list of group objects.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-groups -\-aws-account-id=111122223333 -\-namespace=default </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists assignments in current QuickSight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-iam-policy-assignments --aws-account-id=111122223333 --max-result=5 --assignment-status=ENABLED --namespace=default --region=us-east-1 --next-token=3 </code>
     * </p>
     *
     * @param listIamPolicyAssignmentsRequest
     * @return A Java Future containing the result of the ListIAMPolicyAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIAMPolicyAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIamPolicyAssignmentsResponse> listIAMPolicyAssignments(
            ListIamPolicyAssignmentsRequest listIamPolicyAssignmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists assignments in current QuickSight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-iam-policy-assignments --aws-account-id=111122223333 --max-result=5 --assignment-status=ENABLED --namespace=default --region=us-east-1 --next-token=3 </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIamPolicyAssignmentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIamPolicyAssignmentsRequest#builder()}
     * </p>
     *
     * @param listIamPolicyAssignmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIAMPolicyAssignmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIAMPolicyAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIAMPolicyAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIamPolicyAssignmentsResponse> listIAMPolicyAssignments(
            Consumer<ListIamPolicyAssignmentsRequest.Builder> listIamPolicyAssignmentsRequest) {
        return listIAMPolicyAssignments(ListIamPolicyAssignmentsRequest.builder().applyMutation(listIamPolicyAssignmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the assignments and the ARNs for the associated IAM policies assigned to the specified user and the
     * group or groups that the user belongs to.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-iam-policy-assignments-for-user --aws-account-id=111122223333 --user-name=user5 --namespace=default --max-result=6 --region=us-east-1 </code>
     * </p>
     *
     * @param listIamPolicyAssignmentsForUserRequest
     * @return A Java Future containing the result of the ListIAMPolicyAssignmentsForUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIAMPolicyAssignmentsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIamPolicyAssignmentsForUserResponse> listIAMPolicyAssignmentsForUser(
            ListIamPolicyAssignmentsForUserRequest listIamPolicyAssignmentsForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the assignments and the ARNs for the associated IAM policies assigned to the specified user and the
     * group or groups that the user belongs to.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-iam-policy-assignments-for-user --aws-account-id=111122223333 --user-name=user5 --namespace=default --max-result=6 --region=us-east-1 </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIamPolicyAssignmentsForUserRequest.Builder}
     * avoiding the need to create one manually via {@link ListIamPolicyAssignmentsForUserRequest#builder()}
     * </p>
     *
     * @param listIamPolicyAssignmentsForUserRequest
     *        A {@link Consumer} that will call methods on {@link ListIAMPolicyAssignmentsForUserRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListIAMPolicyAssignmentsForUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIAMPolicyAssignmentsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIamPolicyAssignmentsForUserResponse> listIAMPolicyAssignmentsForUser(
            Consumer<ListIamPolicyAssignmentsForUserRequest.Builder> listIamPolicyAssignmentsForUserRequest) {
        return listIAMPolicyAssignmentsForUser(ListIamPolicyAssignmentsForUserRequest.builder()
                .applyMutation(listIamPolicyAssignmentsForUserRequest).build());
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     *
     * @param listIngestionsRequest
     * @return A Java Future containing the result of the ListIngestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIngestionsResponse> listIngestions(ListIngestionsRequest listIngestionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on {@link ListIngestionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIngestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIngestionsResponse> listIngestions(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest) {
        return listIngestions(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation.</b>
     * </p>
     *
     * @param listIngestionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsPublisher listIngestionsPaginator(ListIngestionsRequest listIngestionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on {@link ListIngestionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsPublisher listIngestionsPaginator(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest) {
        return listIngestionsPaginator(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight list-tags-for-resource --resource-arn arn:aws:quicksight:us-east-1:111111111111:dataset/dataset1 --region us-east-1</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight list-tags-for-resource --resource-arn arn:aws:quicksight:us-east-1:111111111111:dataset/dataset1 --region us-east-1</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-template-aliases --aws-account-id 111122223333 —template-id 'reports_test_template'</code>
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return A Java Future containing the result of the ListTemplateAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTemplateAliasesResponse> listTemplateAliases(
            ListTemplateAliasesRequest listTemplateAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-template-aliases --aws-account-id 111122223333 —template-id 'reports_test_template'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateAliasesRequest#builder()}
     * </p>
     *
     * @param listTemplateAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateAliasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTemplateAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTemplateAliasesResponse> listTemplateAliases(
            Consumer<ListTemplateAliasesRequest.Builder> listTemplateAliasesRequest) {
        return listTemplateAliases(ListTemplateAliasesRequest.builder().applyMutation(listTemplateAliasesRequest).build());
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-template-aliases --aws-account-id 111122223333 —template-id 'reports_test_template'</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher publisher = client.listTemplateAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher publisher = client.listTemplateAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplateAliasesPublisher listTemplateAliasesPaginator(ListTemplateAliasesRequest listTemplateAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-template-aliases --aws-account-id 111122223333 —template-id 'reports_test_template'</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher publisher = client.listTemplateAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher publisher = client.listTemplateAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateAliasesRequest#builder()}
     * </p>
     *
     * @param listTemplateAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateAliasesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplateAliasesPublisher listTemplateAliasesPaginator(
            Consumer<ListTemplateAliasesRequest.Builder> listTemplateAliasesRequest) {
        return listTemplateAliasesPaginator(ListTemplateAliasesRequest.builder().applyMutation(listTemplateAliasesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the versions of the templates in the Quicksight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions --aws-account-id 111122223333 --aws-account-id 196359894473 --template-id
     * reports-test-template
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A Java Future containing the result of the ListTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(
            ListTemplateVersionsRequest listTemplateVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the templates in the Quicksight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions --aws-account-id 111122223333 --aws-account-id 196359894473 --template-id
     * reports-test-template
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(
            Consumer<ListTemplateVersionsRequest.Builder> listTemplateVersionsRequest) {
        return listTemplateVersions(ListTemplateVersionsRequest.builder().applyMutation(listTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of the templates in the Quicksight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions --aws-account-id 111122223333 --aws-account-id 196359894473 --template-id
     * reports-test-template
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher publisher = client.listTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher publisher = client.listTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateVersionsPublisher listTemplateVersionsPaginator(ListTemplateVersionsRequest listTemplateVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the templates in the Quicksight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * aws quicksight list-template-versions --aws-account-id 111122223333 --aws-account-id 196359894473 --template-id
     * reports-test-template
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher publisher = client.listTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher publisher = client.listTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateVersionsPublisher listTemplateVersionsPaginator(
            Consumer<ListTemplateVersionsRequest.Builder> listTemplateVersionsRequest) {
        return listTemplateVersionsPaginator(ListTemplateVersionsRequest.builder().applyMutation(listTemplateVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the templates in the QuickSight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-templates --aws-account-id 111122223333 --max-results 1 —next-token AYADeJuxwOypAndSoOn</code>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the templates in the QuickSight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-templates --aws-account-id 111122223333 --max-results 1 —next-token AYADeJuxwOypAndSoOn</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest) {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all the templates in the QuickSight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-templates --aws-account-id 111122223333 --max-results 1 —next-token AYADeJuxwOypAndSoOn</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesPublisher listTemplatesPaginator(ListTemplatesRequest listTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the templates in the QuickSight account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight list-templates --aws-account-id 111122223333 --max-results 1 —next-token AYADeJuxwOypAndSoOn</code>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesPublisher listTemplatesPaginator(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest) {
        return listTemplatesPaginator(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     * </p>
     * <p>
     * The response is a one or more group objects.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-user-groups -\-user-name=Pat -\-aws-account-id=111122223333 -\-namespace=default -\-region=us-east-1 </code>
     * </p>
     *
     * @param listUserGroupsRequest
     * @return A Java Future containing the result of the ListUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserGroupsResponse> listUserGroups(ListUserGroupsRequest listUserGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     * </p>
     * <p>
     * The response is a one or more group objects.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-user-groups -\-user-name=Pat -\-aws-account-id=111122223333 -\-namespace=default -\-region=us-east-1 </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserGroupsRequest#builder()}
     * </p>
     *
     * @param listUserGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserGroupsResponse> listUserGroups(Consumer<ListUserGroupsRequest.Builder> listUserGroupsRequest) {
        return listUserGroups(ListUserGroupsRequest.builder().applyMutation(listUserGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     * <p>
     * The response is a list of user objects, containing each user's Amazon Resource Name (ARN), AWS Identity and
     * Access Management (IAM) role, and email address.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-users --aws-account-id=111122223333 --namespace=default </code>
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     * <p>
     * The response is a list of user objects, containing each user's Amazon Resource Name (ARN), AWS Identity and
     * Access Management (IAM) role, and email address.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight list-users --aws-account-id=111122223333 --namespace=default </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight register-user -\-aws-account-id=111122223333 -\-namespace=default -\-email=pat@example.com -\-identity-type=IAM -\-user-role=AUTHOR -\-iam-arn=arn:aws:iam::111122223333:user/Pat </code>
     * </p>
     *
     * @param registerUserRequest
     * @return A Java Future containing the result of the RegisterUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterUserResponse> registerUser(RegisterUserRequest registerUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight register-user -\-aws-account-id=111122223333 -\-namespace=default -\-email=pat@example.com -\-identity-type=IAM -\-user-role=AUTHOR -\-iam-arn=arn:aws:iam::111122223333:user/Pat </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterUserRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterUserRequest#builder()}
     * </p>
     *
     * @param registerUserRequest
     *        A {@link Consumer} that will call methods on {@link RegisterUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterUserResponse> registerUser(Consumer<RegisterUserRequest.Builder> registerUserRequest) {
        return registerUser(RegisterUserRequest.builder().applyMutation(registerUserRequest).build());
    }

    /**
     * <p>
     * Assigns a tag or tags to a resource.
     * </p>
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified QuickSight resource. Tags can help you organize and
     * categorize your resources. You can also use them to scope user permissions, by granting a user permission to
     * access or change only resources with certain tag values. You can use the TagResource action with a resource that
     * already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags
     * associated with the resource. If you specify a tag key that is already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource. QuickSight supports tagging on data-set, data-source,
     * dashboard, template.
     * </p>
     * <p>
     * Tagging for QuickSight works in a similar was to tagging for other AWS services, except for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't use tags to track AWS costs for QuickSight, because QuickSight costs are based on users and SPICE
     * capacity, which aren't taggable resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * QuickSight doesn't currently support the Tag Editor for AWS Resource Groups.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CLI syntax to tag a resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight tag-resource --resource-arn arn:aws:quicksight:us-east-1:111111111111:dataset/dataset1 --tags Key=K1,Value=V1 Key=K2,Value=V2 --region us-east-1</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a tag or tags to a resource.
     * </p>
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified QuickSight resource. Tags can help you organize and
     * categorize your resources. You can also use them to scope user permissions, by granting a user permission to
     * access or change only resources with certain tag values. You can use the TagResource action with a resource that
     * already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags
     * associated with the resource. If you specify a tag key that is already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource. QuickSight supports tagging on data-set, data-source,
     * dashboard, template.
     * </p>
     * <p>
     * Tagging for QuickSight works in a similar was to tagging for other AWS services, except for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't use tags to track AWS costs for QuickSight, because QuickSight costs are based on users and SPICE
     * capacity, which aren't taggable resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * QuickSight doesn't currently support the Tag Editor for AWS Resource Groups.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CLI syntax to tag a resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight tag-resource --resource-arn arn:aws:quicksight:us-east-1:111111111111:dataset/dataset1 --tags Key=K1,Value=V1 Key=K2,Value=V2 --region us-east-1</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight untag-resource --resource-arn arn:aws:quicksight:us-east-1:111111111111:dataset/dataset1 --tag-keys K1 K2 --region us-east-1</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight untag-resource --resource-arn arn:aws:quicksight:us-east-1:111111111111:dataset/dataset1 --tag-keys K1 K2 --region us-east-1</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a dashboard in the AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard --aws-account-id 111122223333 --dashboard-id 123123123 --dashboard-name "test-update102" --source-entity SourceTemplate={Arn=arn:aws:quicksight:us-west-2:111122223333:template/sales-report-template2} --data-set-references DataSetPlaceholder=SalesDataSet,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/0e251aef-9ebf-46e1-b852-eb4fa33c1d3a</code>
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard --cli-input-json file://update-dashboard.json </code>
     * </p>
     *
     * @param updateDashboardRequest
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest updateDashboardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a dashboard in the AWS account.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard --aws-account-id 111122223333 --dashboard-id 123123123 --dashboard-name "test-update102" --source-entity SourceTemplate={Arn=arn:aws:quicksight:us-west-2:111122223333:template/sales-report-template2} --data-set-references DataSetPlaceholder=SalesDataSet,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/0e251aef-9ebf-46e1-b852-eb4fa33c1d3a</code>
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard --cli-input-json file://update-dashboard.json </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDashboardRequest#builder()}
     * </p>
     *
     * @param updateDashboardRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDashboardRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDashboardResponse> updateDashboard(
            Consumer<UpdateDashboardRequest.Builder> updateDashboardRequest) {
        return updateDashboard(UpdateDashboardRequest.builder().applyMutation(updateDashboardRequest).build());
    }

    /**
     * <p>
     * Updates read and write permissions on a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard-permissions —cli-input-json file://update-permission.json</code>
     * </p>
     * <p>
     * A sample update-permissions.json for granting read only permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "GrantPermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboard", "quicksight:ListDashboardVersions", "quicksight:DescribeDashboardVersion", "quicksight:QueryDashboard" ] } ] }</code>
     * </p>
     * <p>
     * A sample update-permissions.json for granting read and write permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "GrantPermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboard", "quicksight:ListDashboardVersions", "quicksight:DescribeDashboardVersion", "quicksight:QueryDashboard", "quicksight:DescribeDashboardPermissions", "quicksight:UpdateDashboardPermissions", "quicksight:DeleteDashboardVersion", "quicksight:DeleteDashboard", "quicksight:UpdateDashboard", "quicksight:UpdateDashboardPublishedVersion", ] } ] }</code>
     * </p>
     * <p>
     * A sample update-permissions.json for revoking write permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "RevokePermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboardPermissions", "quicksight:UpdateDashboardPermissions", "quicksight:DeleteDashboardVersion", "quicksight:DeleteDashboard", "quicksight:UpdateDashboard", "quicksight:UpdateDashboardPublishedVersion", ] } ] }</code>
     * </p>
     * <p>
     * A sample update-permissions.json for revoking read and write permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "RevokePermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboard", "quicksight:ListDashboardVersions", "quicksight:DescribeDashboardVersion", "quicksight:QueryDashboard", "quicksight:DescribeDashboardPermissions", "quicksight:UpdateDashboardPermissions", "quicksight:DeleteDashboardVersion", "quicksight:DeleteDashboard", "quicksight:UpdateDashboard", "quicksight:UpdateDashboardPublishedVersion", ] } ] }</code>
     * </p>
     * <p>
     * To obtain the principal name of a QuickSight user or group, you can use describe-group or describe-user. For
     * example:
     * </p>
     * <p>
     * <code>aws quicksight describe-user --aws-account-id 111122223333 --namespace default --user-name user2 --region us-east-1 { "User": { "Arn": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Active": true, "Email": "user2@example.com", "Role": "ADMIN", "UserName": "user2", "PrincipalId": "federated/iam/abcd2abcdabcdeabc5ab5" }, "RequestId": "8f74bb31-6291-448a-a71c-a765a44bae31", "Status": 200 }</code>
     * </p>
     *
     * @param updateDashboardPermissionsRequest
     * @return A Java Future containing the result of the UpdateDashboardPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardPermissionsResponse> updateDashboardPermissions(
            UpdateDashboardPermissionsRequest updateDashboardPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates read and write permissions on a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard-permissions —cli-input-json file://update-permission.json</code>
     * </p>
     * <p>
     * A sample update-permissions.json for granting read only permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "GrantPermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboard", "quicksight:ListDashboardVersions", "quicksight:DescribeDashboardVersion", "quicksight:QueryDashboard" ] } ] }</code>
     * </p>
     * <p>
     * A sample update-permissions.json for granting read and write permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "GrantPermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboard", "quicksight:ListDashboardVersions", "quicksight:DescribeDashboardVersion", "quicksight:QueryDashboard", "quicksight:DescribeDashboardPermissions", "quicksight:UpdateDashboardPermissions", "quicksight:DeleteDashboardVersion", "quicksight:DeleteDashboard", "quicksight:UpdateDashboard", "quicksight:UpdateDashboardPublishedVersion", ] } ] }</code>
     * </p>
     * <p>
     * A sample update-permissions.json for revoking write permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "RevokePermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboardPermissions", "quicksight:UpdateDashboardPermissions", "quicksight:DeleteDashboardVersion", "quicksight:DeleteDashboard", "quicksight:UpdateDashboard", "quicksight:UpdateDashboardPublishedVersion", ] } ] }</code>
     * </p>
     * <p>
     * A sample update-permissions.json for revoking read and write permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333", "DashboardId": "reports_test_report", "RevokePermissions": [ { "Principal": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Actions": [ "quicksight:DescribeDashboard", "quicksight:ListDashboardVersions", "quicksight:DescribeDashboardVersion", "quicksight:QueryDashboard", "quicksight:DescribeDashboardPermissions", "quicksight:UpdateDashboardPermissions", "quicksight:DeleteDashboardVersion", "quicksight:DeleteDashboard", "quicksight:UpdateDashboard", "quicksight:UpdateDashboardPublishedVersion", ] } ] }</code>
     * </p>
     * <p>
     * To obtain the principal name of a QuickSight user or group, you can use describe-group or describe-user. For
     * example:
     * </p>
     * <p>
     * <code>aws quicksight describe-user --aws-account-id 111122223333 --namespace default --user-name user2 --region us-east-1 { "User": { "Arn": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2", "Active": true, "Email": "user2@example.com", "Role": "ADMIN", "UserName": "user2", "PrincipalId": "federated/iam/abcd2abcdabcdeabc5ab5" }, "RequestId": "8f74bb31-6291-448a-a71c-a765a44bae31", "Status": 200 }</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDashboardPermissionsRequest#builder()}
     * </p>
     *
     * @param updateDashboardPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDashboardPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDashboardPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardPermissionsResponse> updateDashboardPermissions(
            Consumer<UpdateDashboardPermissionsRequest.Builder> updateDashboardPermissionsRequest) {
        return updateDashboardPermissions(UpdateDashboardPermissionsRequest.builder()
                .applyMutation(updateDashboardPermissionsRequest).build());
    }

    /**
     * <p>
     * Updates the published version of a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard-published-version --aws-account-id 111122223333 --dashboard-id dashboard-w1 ---version-number 2</code>
     * </p>
     *
     * @param updateDashboardPublishedVersionRequest
     * @return A Java Future containing the result of the UpdateDashboardPublishedVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboardPublishedVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardPublishedVersionResponse> updateDashboardPublishedVersion(
            UpdateDashboardPublishedVersionRequest updateDashboardPublishedVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the published version of a dashboard.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-dashboard-published-version --aws-account-id 111122223333 --dashboard-id dashboard-w1 ---version-number 2</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardPublishedVersionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDashboardPublishedVersionRequest#builder()}
     * </p>
     *
     * @param updateDashboardPublishedVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDashboardPublishedVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDashboardPublishedVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboardPublishedVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDashboardPublishedVersionResponse> updateDashboardPublishedVersion(
            Consumer<UpdateDashboardPublishedVersionRequest.Builder> updateDashboardPublishedVersionRequest) {
        return updateDashboardPublishedVersion(UpdateDashboardPublishedVersionRequest.builder()
                .applyMutation(updateDashboardPublishedVersionRequest).build());
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     * <p>
     * <code>--name='My dataset' \</code>
     * </p>
     * <p>
     * <code>--import-mode=SPICE \</code>
     * </p>
     * <p>
     * <code>--physical-table-map='{</code>
     * </p>
     * <p>
     * <code> "physical-table-id": {</code>
     * </p>
     * <p>
     * <code> "RelationalTable": {</code>
     * </p>
     * <p>
     * <code> "DataSourceArn": "arn:aws:quicksight:us-west-2:111111111111:datasource/data-source-id",</code>
     * </p>
     * <p>
     * <code> "Name": "table1",</code>
     * </p>
     * <p>
     * <code> "InputColumns": [</code>
     * </p>
     * <p>
     * <code> {</code>
     * </p>
     * <p>
     * <code> "Name": "column1",</code>
     * </p>
     * <p>
     * <code> "Type": "STRING"</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> ]</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> }'</code>
     * </p>
     *
     * @param updateDataSetRequest
     * @return A Java Future containing the result of the UpdateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSetResponse> updateDataSet(UpdateDataSetRequest updateDataSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-set \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     * <p>
     * <code>--name='My dataset' \</code>
     * </p>
     * <p>
     * <code>--import-mode=SPICE \</code>
     * </p>
     * <p>
     * <code>--physical-table-map='{</code>
     * </p>
     * <p>
     * <code> "physical-table-id": {</code>
     * </p>
     * <p>
     * <code> "RelationalTable": {</code>
     * </p>
     * <p>
     * <code> "DataSourceArn": "arn:aws:quicksight:us-west-2:111111111111:datasource/data-source-id",</code>
     * </p>
     * <p>
     * <code> "Name": "table1",</code>
     * </p>
     * <p>
     * <code> "InputColumns": [</code>
     * </p>
     * <p>
     * <code> {</code>
     * </p>
     * <p>
     * <code> "Name": "column1",</code>
     * </p>
     * <p>
     * <code> "Type": "STRING"</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> ]</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> }'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDataSetRequest#builder()}
     * </p>
     *
     * @param updateDataSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataSetResponse> updateDataSet(Consumer<UpdateDataSetRequest.Builder> updateDataSetRequest) {
        return updateDataSet(UpdateDataSetRequest.builder().applyMutation(updateDataSetRequest).build());
    }

    /**
     * <p>
     * Updates the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-set-permissions \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     * <p>
     * <code>--grant-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user1","Actions":["quicksight:DescribeDataSet","quicksight:DescribeDataSetPermissions","quicksight:PassDataSet","quicksight:ListIngestions","quicksight:DescribeIngestion"]}]' \</code>
     * </p>
     * <p>
     * <code>--revoke-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user2","Actions":["quicksight:UpdateDataSet","quicksight:DeleteDataSet","quicksight:UpdateDataSetPermissions","quicksight:CreateIngestion","quicksight:CancelIngestion"]}]'</code>
     * </p>
     *
     * @param updateDataSetPermissionsRequest
     * @return A Java Future containing the result of the UpdateDataSetPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataSetPermissionsResponse> updateDataSetPermissions(
            UpdateDataSetPermissionsRequest updateDataSetPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-set-permissions \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-set-id=unique-data-set-id \</code>
     * </p>
     * <p>
     * <code>--grant-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user1","Actions":["quicksight:DescribeDataSet","quicksight:DescribeDataSetPermissions","quicksight:PassDataSet","quicksight:ListIngestions","quicksight:DescribeIngestion"]}]' \</code>
     * </p>
     * <p>
     * <code>--revoke-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user2","Actions":["quicksight:UpdateDataSet","quicksight:DeleteDataSet","quicksight:UpdateDataSetPermissions","quicksight:CreateIngestion","quicksight:CancelIngestion"]}]'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSetPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDataSetPermissionsRequest#builder()}
     * </p>
     *
     * @param updateDataSetPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSetPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDataSetPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataSetPermissionsResponse> updateDataSetPermissions(
            Consumer<UpdateDataSetPermissionsRequest.Builder> updateDataSetPermissionsRequest) {
        return updateDataSetPermissions(UpdateDataSetPermissionsRequest.builder().applyMutation(updateDataSetPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Updates a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-source \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id \</code>
     * </p>
     * <p>
     * <code>--name='My Data Source' \</code>
     * </p>
     * <p>
     * <code>--data-source-parameters='{"PostgreSqlParameters":{"Host":"my-db-host.example.com","Port":1234,"Database":"my-db"}}' \</code>
     * </p>
     * <p>
     * <code>--credentials='{"CredentialPair":{"Username":"username","Password":"password"}}</code>
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-source \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id \</code>
     * </p>
     * <p>
     * <code>--name='My Data Source' \</code>
     * </p>
     * <p>
     * <code>--data-source-parameters='{"PostgreSqlParameters":{"Host":"my-db-host.example.com","Port":1234,"Database":"my-db"}}' \</code>
     * </p>
     * <p>
     * <code>--credentials='{"CredentialPair":{"Username":"username","Password":"password"}}</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates the permissions to a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-source-permissions \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id \</code>
     * </p>
     * <p>
     * <code>--name='My Data Source' \</code>
     * </p>
     * <p>
     * <code>--grant-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user1","Actions":["quicksight:DescribeDataSource","quicksight:DescribeDataSourcePermissions","quicksight:PassDataSource"]}]' \</code>
     * </p>
     * <p>
     * <code>--revoke-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user2","Actions":["quicksight:UpdateDataSource","quicksight:DeleteDataSource","quicksight:UpdateDataSourcePermissions"]}]'</code>
     * </p>
     *
     * @param updateDataSourcePermissionsRequest
     * @return A Java Future containing the result of the UpdateDataSourcePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourcePermissionsResponse> updateDataSourcePermissions(
            UpdateDataSourcePermissionsRequest updateDataSourcePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the permissions to a data source.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:datasource/data-source-id</code>
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-data-source-permissions \</code>
     * </p>
     * <p>
     * <code>--aws-account-id=111122223333 \</code>
     * </p>
     * <p>
     * <code>--data-source-id=unique-data-source-id \</code>
     * </p>
     * <p>
     * <code>--name='My Data Source' \</code>
     * </p>
     * <p>
     * <code>--grant-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user1","Actions":["quicksight:DescribeDataSource","quicksight:DescribeDataSourcePermissions","quicksight:PassDataSource"]}]' \</code>
     * </p>
     * <p>
     * <code>--revoke-permissions='[{"Principal":"arn:aws:quicksight:us-east-1:111122223333:user/default/user2","Actions":["quicksight:UpdateDataSource","quicksight:DeleteDataSource","quicksight:UpdateDataSourcePermissions"]}]'</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDataSourcePermissionsRequest#builder()}
     * </p>
     *
     * @param updateDataSourcePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourcePermissionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateDataSourcePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourcePermissionsResponse> updateDataSourcePermissions(
            Consumer<UpdateDataSourcePermissionsRequest.Builder> updateDataSourcePermissionsRequest) {
        return updateDataSourcePermissions(UpdateDataSourcePermissionsRequest.builder()
                .applyMutation(updateDataSourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight update-group --aws-account-id=111122223333 --namespace=default --group-name=Sales --description="Sales BI Dashboards" </code>
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight update-group --aws-account-id=111122223333 --namespace=default --group-name=Sales --description="Sales BI Dashboards" </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates an existing assignment. This operation updates only the optional parameter or parameters that are
     * specified in the request.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code/>aws quicksight update-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=FullAccessAssignment --assignment-status=DRAFT --policy-arns=arn:aws:iam::aws:policy/AdministratorAccess --identities="user=user-1,user-2,group=admin" --namespace=default --region=us-east-1
     * </p>
     *
     * @param updateIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the UpdateIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIamPolicyAssignmentResponse> updateIAMPolicyAssignment(
            UpdateIamPolicyAssignmentRequest updateIamPolicyAssignmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing assignment. This operation updates only the optional parameter or parameters that are
     * specified in the request.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code/>aws quicksight update-iam-policy-assignment --aws-account-id=111122223333 --assignment-name=FullAccessAssignment --assignment-status=DRAFT --policy-arns=arn:aws:iam::aws:policy/AdministratorAccess --identities="user=user-1,user-2,group=admin" --namespace=default --region=us-east-1
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIamPolicyAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param updateIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIAMPolicyAssignmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in an "actionable" state that must complete before
     *         a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIamPolicyAssignmentResponse> updateIAMPolicyAssignment(
            Consumer<UpdateIamPolicyAssignmentRequest.Builder> updateIamPolicyAssignmentRequest) {
        return updateIAMPolicyAssignment(UpdateIamPolicyAssignmentRequest.builder()
                .applyMutation(updateIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Updates a template from an existing QuickSight analysis.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-template --aws-account-id 111122223333 --template-id reports_test_template --data-set-references DataSetPlaceholder=reports,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/c684a204-d134-4c53-a63c-451f72c60c28 DataSetPlaceholder=Elblogs,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/15840b7d-b542-4491-937b-602416b367b3 —source-entity SourceAnalysis=’{Arn=arn:aws:quicksight:us-west-2:111122223333:analysis/c5731fe9-4708-4598-8f6d-cf2a70875b6d}</code>
     * </p>
     * <p>
     * You can also pass in a json file:
     * <code>aws quicksight update-template —cli-input-json file://create-template.json</code>
     * </p>
     *
     * @param updateTemplateRequest
     * @return A Java Future containing the result of the UpdateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTemplateResponse> updateTemplate(UpdateTemplateRequest updateTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a template from an existing QuickSight analysis.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-template --aws-account-id 111122223333 --template-id reports_test_template --data-set-references DataSetPlaceholder=reports,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/c684a204-d134-4c53-a63c-451f72c60c28 DataSetPlaceholder=Elblogs,DataSetArn=arn:aws:quicksight:us-west-2:111122223333:dataset/15840b7d-b542-4491-937b-602416b367b3 —source-entity SourceAnalysis=’{Arn=arn:aws:quicksight:us-west-2:111122223333:analysis/c5731fe9-4708-4598-8f6d-cf2a70875b6d}</code>
     * </p>
     * <p>
     * You can also pass in a json file:
     * <code>aws quicksight update-template —cli-input-json file://create-template.json</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTemplateRequest#builder()}
     * </p>
     *
     * @param updateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTemplateResponse> updateTemplate(Consumer<UpdateTemplateRequest.Builder> updateTemplateRequest) {
        return updateTemplate(UpdateTemplateRequest.builder().applyMutation(updateTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the template alias of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name STAGING —template-version-number 2 </code>
     * </p>
     *
     * @param updateTemplateAliasRequest
     * @return A Java Future containing the result of the UpdateTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateAliasResponse> updateTemplateAlias(
            UpdateTemplateAliasRequest updateTemplateAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the template alias of a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <p>
     * <code>aws quicksight update-template-alias --aws-account-id 111122223333 --template-id 'reports_test_template' --alias-name STAGING —template-version-number 2 </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTemplateAliasRequest#builder()}
     * </p>
     *
     * @param updateTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateAliasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateAliasResponse> updateTemplateAlias(
            Consumer<UpdateTemplateAliasRequest.Builder> updateTemplateAliasRequest) {
        return updateTemplateAlias(UpdateTemplateAliasRequest.builder().applyMutation(updateTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Updates the permissions on a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight describe-template-permissions —aws-account-id 111122223333 —template-id reports_test_template</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight update-template-permissions —cli-input-json file://update-permission.json </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The structure of <code>update-permissions.json</code> to add permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333",</code>
     * </p>
     * <p>
     * <code> "DashboardId": "reports_test_template",</code>
     * </p>
     * <p>
     * <code> "GrantPermissions": [</code>
     * </p>
     * <p>
     * <code> { "Principal": "arn:aws:quicksight:us-east-1:196359894473:user/default/user3",</code>
     * </p>
     * <p>
     * <code> "Actions": [</code>
     * </p>
     * <p>
     * <code> "quicksight:DescribeTemplate",</code>
     * </p>
     * <p>
     * <code> "quicksight:ListTemplateVersions"</code>
     * </p>
     * <p>
     * <code> ] } ] }</code>
     * </p>
     * <p>
     * The structure of <code>update-permissions.json</code> to add permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333",</code>
     * </p>
     * <p>
     * <code> "DashboardId": "reports_test_template",</code>
     * </p>
     * <p>
     * <code> "RevokePermissions": [</code>
     * </p>
     * <p>
     * <code> { "Principal": "arn:aws:quicksight:us-east-1:196359894473:user/default/user3",</code>
     * </p>
     * <p>
     * <code> "Actions": [</code>
     * </p>
     * <p>
     * <code> "quicksight:DescribeTemplate",</code>
     * </p>
     * <p>
     * <code> "quicksight:ListTemplateVersions"</code>
     * </p>
     * <p>
     * <code> ] } ] }</code>
     * </p>
     * <p>
     * To obtain the principal name of a QuickSight group or user, use user describe-group or describe-user. For
     * example:
     * </p>
     * <p>
     * <code>aws quicksight describe-user </code>
     * </p>
     * <p>
     * <code>--aws-account-id 111122223333</code>
     * </p>
     * <p>
     * <code>--namespace default</code>
     * </p>
     * <p>
     * <code>--user-name user2 </code>
     * </p>
     * <p>
     * <code>--region us-east-1</code>
     * </p>
     * <p>
     * <code>{</code>
     * </p>
     * <p>
     * <code> "User": {</code>
     * </p>
     * <p>
     * <code> "Arn": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2",</code>
     * </p>
     * <p>
     * <code> "Active": true,</code>
     * </p>
     * <p>
     * <code> "Email": "user2@example.com",</code>
     * </p>
     * <p>
     * <code> "Role": "ADMIN",</code>
     * </p>
     * <p>
     * <code> "UserName": "user2",</code>
     * </p>
     * <p>
     * <code> "PrincipalId": "federated/iam/abcd2abcdabcdeabc5ab5"</code>
     * </p>
     * <p>
     * <code> },</code>
     * </p>
     * <p>
     * <code> "RequestId": "8f74bb31-6291-448a-a71c-a765a44bae31",</code>
     * </p>
     * <p>
     * <code> "Status": 200</code>
     * </p>
     * <p>
     * <code>}</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateTemplatePermissionsRequest
     * @return A Java Future containing the result of the UpdateTemplatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTemplatePermissionsResponse> updateTemplatePermissions(
            UpdateTemplatePermissionsRequest updateTemplatePermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the permissions on a template.
     * </p>
     * <p>
     * CLI syntax:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aws quicksight describe-template-permissions —aws-account-id 111122223333 —template-id reports_test_template</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aws quicksight update-template-permissions —cli-input-json file://update-permission.json </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The structure of <code>update-permissions.json</code> to add permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333",</code>
     * </p>
     * <p>
     * <code> "DashboardId": "reports_test_template",</code>
     * </p>
     * <p>
     * <code> "GrantPermissions": [</code>
     * </p>
     * <p>
     * <code> { "Principal": "arn:aws:quicksight:us-east-1:196359894473:user/default/user3",</code>
     * </p>
     * <p>
     * <code> "Actions": [</code>
     * </p>
     * <p>
     * <code> "quicksight:DescribeTemplate",</code>
     * </p>
     * <p>
     * <code> "quicksight:ListTemplateVersions"</code>
     * </p>
     * <p>
     * <code> ] } ] }</code>
     * </p>
     * <p>
     * The structure of <code>update-permissions.json</code> to add permissions:
     * </p>
     * <p>
     * <code>{ "AwsAccountId": "111122223333",</code>
     * </p>
     * <p>
     * <code> "DashboardId": "reports_test_template",</code>
     * </p>
     * <p>
     * <code> "RevokePermissions": [</code>
     * </p>
     * <p>
     * <code> { "Principal": "arn:aws:quicksight:us-east-1:196359894473:user/default/user3",</code>
     * </p>
     * <p>
     * <code> "Actions": [</code>
     * </p>
     * <p>
     * <code> "quicksight:DescribeTemplate",</code>
     * </p>
     * <p>
     * <code> "quicksight:ListTemplateVersions"</code>
     * </p>
     * <p>
     * <code> ] } ] }</code>
     * </p>
     * <p>
     * To obtain the principal name of a QuickSight group or user, use user describe-group or describe-user. For
     * example:
     * </p>
     * <p>
     * <code>aws quicksight describe-user </code>
     * </p>
     * <p>
     * <code>--aws-account-id 111122223333</code>
     * </p>
     * <p>
     * <code>--namespace default</code>
     * </p>
     * <p>
     * <code>--user-name user2 </code>
     * </p>
     * <p>
     * <code>--region us-east-1</code>
     * </p>
     * <p>
     * <code>{</code>
     * </p>
     * <p>
     * <code> "User": {</code>
     * </p>
     * <p>
     * <code> "Arn": "arn:aws:quicksight:us-east-1:111122223333:user/default/user2",</code>
     * </p>
     * <p>
     * <code> "Active": true,</code>
     * </p>
     * <p>
     * <code> "Email": "user2@example.com",</code>
     * </p>
     * <p>
     * <code> "Role": "ADMIN",</code>
     * </p>
     * <p>
     * <code> "UserName": "user2",</code>
     * </p>
     * <p>
     * <code> "PrincipalId": "federated/iam/abcd2abcdabcdeabc5ab5"</code>
     * </p>
     * <p>
     * <code> },</code>
     * </p>
     * <p>
     * <code> "RequestId": "8f74bb31-6291-448a-a71c-a765a44bae31",</code>
     * </p>
     * <p>
     * <code> "Status": 200</code>
     * </p>
     * <p>
     * <code>}</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplatePermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTemplatePermissionsRequest#builder()}
     * </p>
     *
     * @param updateTemplatePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplatePermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTemplatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon QuickSight
     *         currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in
     *         every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTemplatePermissionsResponse> updateTemplatePermissions(
            Consumer<UpdateTemplatePermissionsRequest.Builder> updateTemplatePermissionsRequest) {
        return updateTemplatePermissions(UpdateTemplatePermissionsRequest.builder()
                .applyMutation(updateTemplatePermissionsRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon QuickSight user name, email address, active or
     * inactive status in Amazon QuickSight, Amazon QuickSight role, and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight update-user --user-name=Pat --role=ADMIN --email=new_address@example.com --aws-account-id=111122223333 --namespace=default --region=us-east-1 </code>
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon QuickSight user name, email address, active or
     * inactive status in Amazon QuickSight, Amazon QuickSight role, and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * <b>CLI Sample:</b>
     * </p>
     * <p>
     * <code>aws quicksight update-user --user-name=Pat --role=ADMIN --email=new_address@example.com --aws-account-id=111122223333 --namespace=default --region=us-east-1 </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this. The provided credentials couldn't be validated.
     *         You might not be authorized to carry out the request. Ensure that your account is authorized to use the
     *         Amazon QuickSight service, that your policies have the correct permissions, and that you are using the
     *         correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }
}
