/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dashboard version summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardVersionSummary.Builder, DashboardVersionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardVersionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DashboardVersionSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DashboardVersionSummary::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardVersionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SOURCE_ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardVersionSummary::sourceEntityArn)).setter(setter(Builder::sourceEntityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntityArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashboardVersionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD,
            VERSION_NUMBER_FIELD, STATUS_FIELD, SOURCE_ENTITY_ARN_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdTime;

    private final Long versionNumber;

    private final String status;

    private final String sourceEntityArn;

    private final String description;

    private DashboardVersionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.sourceEntityArn = builder.sourceEntityArn;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Amazon Resource name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource name (ARN) of the resource.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The time this was created.
     * </p>
     * 
     * @return The time this was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Version number.
     * </p>
     * 
     * @return Version number.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The http status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The http status of the request.
     * @see ResourceStatus
     */
    public ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The http status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The http status of the request.
     * @see ResourceStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Source entity ARN.
     * </p>
     * 
     * @return Source entity ARN.
     */
    public String sourceEntityArn() {
        return sourceEntityArn;
    }

    /**
     * <p>
     * Description.
     * </p>
     * 
     * @return Description.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntityArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVersionSummary)) {
            return false;
        }
        DashboardVersionSummary other = (DashboardVersionSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceEntityArn(), other.sourceEntityArn())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashboardVersionSummary").add("Arn", arn()).add("CreatedTime", createdTime())
                .add("VersionNumber", versionNumber()).add("Status", statusAsString()).add("SourceEntityArn", sourceEntityArn())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SourceEntityArn":
            return Optional.ofNullable(clazz.cast(sourceEntityArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardVersionSummary, T> g) {
        return obj -> g.apply((DashboardVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardVersionSummary> {
        /**
         * <p>
         * The Amazon Resource name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time this was created.
         * </p>
         * 
         * @param createdTime
         *        The time this was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Version number.
         * </p>
         * 
         * @param versionNumber
         *        Version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The http status of the request.
         * </p>
         * 
         * @param status
         *        The http status of the request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The http status of the request.
         * </p>
         * 
         * @param status
         *        The http status of the request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Source entity ARN.
         * </p>
         * 
         * @param sourceEntityArn
         *        Source entity ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntityArn(String sourceEntityArn);

        /**
         * <p>
         * Description.
         * </p>
         * 
         * @param description
         *        Description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdTime;

        private Long versionNumber;

        private String status;

        private String sourceEntityArn;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVersionSummary model) {
            arn(model.arn);
            createdTime(model.createdTime);
            versionNumber(model.versionNumber);
            status(model.status);
            sourceEntityArn(model.sourceEntityArn);
            description(model.description);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSourceEntityArn() {
            return sourceEntityArn;
        }

        @Override
        public final Builder sourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
            return this;
        }

        public final void setSourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public DashboardVersionSummary build() {
            return new DashboardVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
