/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplateAliasesResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListTemplateAliasesResponse.Builder, ListTemplateAliasesResponse> {
    private static final SdkField<List<TemplateAlias>> TEMPLATE_ALIAS_LIST_FIELD = SdkField
            .<List<TemplateAlias>> builder(MarshallingType.LIST)
            .getter(getter(ListTemplateAliasesResponse::templateAliasList))
            .setter(setter(Builder::templateAliasList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateAliasList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListTemplateAliasesResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTemplateAliasesResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTemplateAliasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ALIAS_LIST_FIELD,
            STATUS_FIELD, REQUEST_ID_FIELD, NEXT_TOKEN_FIELD));

    private final List<TemplateAlias> templateAliasList;

    private final Integer status;

    private final String requestId;

    private final String nextToken;

    private ListTemplateAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.templateAliasList = builder.templateAliasList;
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A structure containing the list of template aliases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A structure containing the list of template aliases.
     */
    public List<TemplateAlias> templateAliasList() {
        return templateAliasList;
    }

    /**
     * <p>
     * The http status of the request.
     * </p>
     * 
     * @return The http status of the request.
     */
    public Integer status() {
        return status;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateAliasList());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateAliasesResponse)) {
            return false;
        }
        ListTemplateAliasesResponse other = (ListTemplateAliasesResponse) obj;
        return Objects.equals(templateAliasList(), other.templateAliasList()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTemplateAliasesResponse").add("TemplateAliasList", templateAliasList())
                .add("Status", status()).add("RequestId", requestId()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateAliasList":
            return Optional.ofNullable(clazz.cast(templateAliasList()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateAliasesResponse, T> g) {
        return obj -> g.apply((ListTemplateAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTemplateAliasesResponse> {
        /**
         * <p>
         * A structure containing the list of template aliases.
         * </p>
         * 
         * @param templateAliasList
         *        A structure containing the list of template aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateAliasList(Collection<TemplateAlias> templateAliasList);

        /**
         * <p>
         * A structure containing the list of template aliases.
         * </p>
         * 
         * @param templateAliasList
         *        A structure containing the list of template aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateAliasList(TemplateAlias... templateAliasList);

        /**
         * <p>
         * A structure containing the list of template aliases.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TemplateAlias>.Builder} avoiding the need
         * to create one manually via {@link List<TemplateAlias>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateAlias>.Builder#build()} is called immediately and
         * its result is passed to {@link #templateAliasList(List<TemplateAlias>)}.
         * 
         * @param templateAliasList
         *        a consumer that will call methods on {@link List<TemplateAlias>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateAliasList(List<TemplateAlias>)
         */
        Builder templateAliasList(Consumer<TemplateAlias.Builder>... templateAliasList);

        /**
         * <p>
         * The http status of the request.
         * </p>
         * 
         * @param status
         *        The http status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<TemplateAlias> templateAliasList = DefaultSdkAutoConstructList.getInstance();

        private Integer status;

        private String requestId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateAliasesResponse model) {
            super(model);
            templateAliasList(model.templateAliasList);
            status(model.status);
            requestId(model.requestId);
            nextToken(model.nextToken);
        }

        public final Collection<TemplateAlias.Builder> getTemplateAliasList() {
            return templateAliasList != null ? templateAliasList.stream().map(TemplateAlias::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder templateAliasList(Collection<TemplateAlias> templateAliasList) {
            this.templateAliasList = TemplateAliasListCopier.copy(templateAliasList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateAliasList(TemplateAlias... templateAliasList) {
            templateAliasList(Arrays.asList(templateAliasList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateAliasList(Consumer<TemplateAlias.Builder>... templateAliasList) {
            templateAliasList(Stream.of(templateAliasList).map(c -> TemplateAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTemplateAliasList(Collection<TemplateAlias.BuilderImpl> templateAliasList) {
            this.templateAliasList = TemplateAliasListCopier.copyFromBuilder(templateAliasList);
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTemplateAliasesResponse build() {
            return new ListTemplateAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
