/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The template summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateSummary implements SdkPojo, Serializable, ToCopyableBuilder<TemplateSummary.Builder, TemplateSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateSummary::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Long> LATEST_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TemplateSummary::latestVersionNumber)).setter(setter(Builder::latestVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionNumber").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TemplateSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TemplateSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TEMPLATE_ID_FIELD,
            NAME_FIELD, LATEST_VERSION_NUMBER_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String templateId;

    private final String name;

    private final Long latestVersionNumber;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private TemplateSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.latestVersionNumber = builder.latestVersionNumber;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * A summary of a template.
     * </p>
     * 
     * @return A summary of a template.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the template. This is unique per region per AWS account.
     * </p>
     * 
     * @return The ID of the template. This is unique per region per AWS account.
     */
    public String templateId() {
        return templateId;
    }

    /**
     * <p>
     * A display name for the template.
     * </p>
     * 
     * @return A display name for the template.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A structure containing a list of version numbers for the template summary.
     * </p>
     * 
     * @return A structure containing a list of version numbers for the template summary.
     */
    public Long latestVersionNumber() {
        return latestVersionNumber;
    }

    /**
     * <p>
     * The last time this was created.
     * </p>
     * 
     * @return The last time this was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last time this was updated.
     * </p>
     * 
     * @return The last time this was updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSummary)) {
            return false;
        }
        TemplateSummary other = (TemplateSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(name(), other.name()) && Objects.equals(latestVersionNumber(), other.latestVersionNumber())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TemplateSummary").add("Arn", arn()).add("TemplateId", templateId()).add("Name", name())
                .add("LatestVersionNumber", latestVersionNumber()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LatestVersionNumber":
            return Optional.ofNullable(clazz.cast(latestVersionNumber()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSummary, T> g) {
        return obj -> g.apply((TemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateSummary> {
        /**
         * <p>
         * A summary of a template.
         * </p>
         * 
         * @param arn
         *        A summary of a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the template. This is unique per region per AWS account.
         * </p>
         * 
         * @param templateId
         *        The ID of the template. This is unique per region per AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * A display name for the template.
         * </p>
         * 
         * @param name
         *        A display name for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure containing a list of version numbers for the template summary.
         * </p>
         * 
         * @param latestVersionNumber
         *        A structure containing a list of version numbers for the template summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionNumber(Long latestVersionNumber);

        /**
         * <p>
         * The last time this was created.
         * </p>
         * 
         * @param createdTime
         *        The last time this was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last time this was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time this was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String templateId;

        private String name;

        private Long latestVersionNumber;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSummary model) {
            arn(model.arn);
            templateId(model.templateId);
            name(model.name);
            latestVersionNumber(model.latestVersionNumber);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getTemplateId() {
            return templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getLatestVersionNumber() {
            return latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        public final void setLatestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public TemplateSummary build() {
            return new TemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
