/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourceResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateDataSourceResponse.Builder, UpdateDataSourceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSourceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSourceResponse::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSourceResponse::updateStatusAsString)).setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSourceResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateDataSourceResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DATA_SOURCE_ID_FIELD, UPDATE_STATUS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String arn;

    private final String dataSourceId;

    private final String updateStatus;

    private final String requestId;

    private final Integer status;

    private UpdateDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.dataSourceId = builder.dataSourceId;
        this.updateStatus = builder.updateStatus;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the data source.
     * </p>
     * 
     * @return The ARN of the data source.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the data source. This is unique per AWS Region per AWS account.
     * </p>
     * 
     * @return The ID of the data source. This is unique per AWS Region per AWS account.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The update status of the data source's last update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The update status of the data source's last update.
     * @see ResourceStatus
     */
    public ResourceStatus updateStatus() {
        return ResourceStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * The update status of the data source's last update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The update status of the data source's last update.
     * @see ResourceStatus
     */
    public String updateStatusAsString() {
        return updateStatus;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The http status of the request.
     * </p>
     * 
     * @return The http status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceResponse)) {
            return false;
        }
        UpdateDataSourceResponse other = (UpdateDataSourceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDataSourceResponse").add("Arn", arn()).add("DataSourceId", dataSourceId())
                .add("UpdateStatus", updateStatusAsString()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceResponse, T> g) {
        return obj -> g.apply((UpdateDataSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSourceResponse> {
        /**
         * <p>
         * The ARN of the data source.
         * </p>
         * 
         * @param arn
         *        The ARN of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the data source. This is unique per AWS Region per AWS account.
         * </p>
         * 
         * @param dataSourceId
         *        The ID of the data source. This is unique per AWS Region per AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The update status of the data source's last update.
         * </p>
         * 
         * @param updateStatus
         *        The update status of the data source's last update.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * The update status of the data source's last update.
         * </p>
         * 
         * @param updateStatus
         *        The update status of the data source's last update.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder updateStatus(ResourceStatus updateStatus);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The http status of the request.
         * </p>
         * 
         * @param status
         *        The http status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String dataSourceId;

        private String updateStatus;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceResponse model) {
            super(model);
            arn(model.arn);
            dataSourceId(model.dataSourceId);
            updateStatus(model.updateStatus);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getUpdateStatusAsString() {
            return updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ResourceStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public UpdateDataSourceResponse build() {
            return new UpdateDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
