/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplatePermissionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateTemplatePermissionsResponse.Builder, UpdateTemplatePermissionsResponse> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTemplatePermissionsResponse::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTemplatePermissionsResponse::templateArn)).setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .getter(getter(UpdateTemplatePermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTemplatePermissionsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateTemplatePermissionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD,
            TEMPLATE_ARN_FIELD, PERMISSIONS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String templateId;

    private final String templateArn;

    private final List<ResourcePermission> permissions;

    private final String requestId;

    private final Integer status;

    private UpdateTemplatePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.templateId = builder.templateId;
        this.templateArn = builder.templateArn;
        this.permissions = builder.permissions;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID for the template.
     * </p>
     * 
     * @return The ID for the template.
     */
    public String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The ARN of the template.
     * </p>
     * 
     * @return The ARN of the template.
     */
    public String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * A list of resource permissions to be set on the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of resource permissions to be set on the template.
     */
    public List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The http status of the request.
     * </p>
     * 
     * @return The http status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplatePermissionsResponse)) {
            return false;
        }
        UpdateTemplatePermissionsResponse other = (UpdateTemplatePermissionsResponse) obj;
        return Objects.equals(templateId(), other.templateId()) && Objects.equals(templateArn(), other.templateArn())
                && Objects.equals(permissions(), other.permissions()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTemplatePermissionsResponse").add("TemplateId", templateId())
                .add("TemplateArn", templateArn()).add("Permissions", permissions()).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplatePermissionsResponse, T> g) {
        return obj -> g.apply((UpdateTemplatePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTemplatePermissionsResponse> {
        /**
         * <p>
         * The ID for the template.
         * </p>
         * 
         * @param templateId
         *        The ID for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The ARN of the template.
         * </p>
         * 
         * @param templateArn
         *        The ARN of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions to be set on the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions to be set on the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The http status of the request.
         * </p>
         * 
         * @param status
         *        The http status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String templateId;

        private String templateArn;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplatePermissionsResponse model) {
            super(model);
            templateId(model.templateId);
            templateArn(model.templateArn);
            permissions(model.permissions);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getTemplateId() {
            return templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        public final Collection<ResourcePermission.Builder> getPermissions() {
            return permissions != null ? permissions.stream().map(ResourcePermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public UpdateTemplatePermissionsResponse build() {
            return new UpdateTemplatePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
