/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sheet controls option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetControlsOption implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetControlsOption.Builder, SheetControlsOption> {
    private static final SdkField<String> VISIBILITY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SheetControlsOption::visibilityStateAsString)).setter(setter(Builder::visibilityState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visibilityState;

    private SheetControlsOption(BuilderImpl builder) {
        this.visibilityState = builder.visibilityState;
    }

    /**
     * <p>
     * Visibility state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityState}
     * will return {@link DashboardUIState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStateAsString}.
     * </p>
     * 
     * @return Visibility state.
     * @see DashboardUIState
     */
    public DashboardUIState visibilityState() {
        return DashboardUIState.fromValue(visibilityState);
    }

    /**
     * <p>
     * Visibility state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityState}
     * will return {@link DashboardUIState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStateAsString}.
     * </p>
     * 
     * @return Visibility state.
     * @see DashboardUIState
     */
    public String visibilityStateAsString() {
        return visibilityState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetControlsOption)) {
            return false;
        }
        SheetControlsOption other = (SheetControlsOption) obj;
        return Objects.equals(visibilityStateAsString(), other.visibilityStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SheetControlsOption").add("VisibilityState", visibilityStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisibilityState":
            return Optional.ofNullable(clazz.cast(visibilityStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SheetControlsOption, T> g) {
        return obj -> g.apply((SheetControlsOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetControlsOption> {
        /**
         * <p>
         * Visibility state.
         * </p>
         * 
         * @param visibilityState
         *        Visibility state.
         * @see DashboardUIState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardUIState
         */
        Builder visibilityState(String visibilityState);

        /**
         * <p>
         * Visibility state.
         * </p>
         * 
         * @param visibilityState
         *        Visibility state.
         * @see DashboardUIState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardUIState
         */
        Builder visibilityState(DashboardUIState visibilityState);
    }

    static final class BuilderImpl implements Builder {
        private String visibilityState;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetControlsOption model) {
            visibilityState(model.visibilityState);
        }

        public final String getVisibilityStateAsString() {
            return visibilityState;
        }

        @Override
        public final Builder visibilityState(String visibilityState) {
            this.visibilityState = visibilityState;
            return this;
        }

        @Override
        public final Builder visibilityState(DashboardUIState visibilityState) {
            this.visibilityState(visibilityState == null ? null : visibilityState.toString());
            return this;
        }

        public final void setVisibilityState(String visibilityState) {
            this.visibilityState = visibilityState;
        }

        @Override
        public SheetControlsOption build() {
            return new SheetControlsOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
