/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Join instruction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinInstruction implements SdkPojo, Serializable, ToCopyableBuilder<JoinInstruction.Builder, JoinInstruction> {
    private static final SdkField<String> LEFT_OPERAND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinInstruction::leftOperand)).setter(setter(Builder::leftOperand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperand").build()).build();

    private static final SdkField<String> RIGHT_OPERAND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinInstruction::rightOperand)).setter(setter(Builder::rightOperand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperand").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinInstruction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ON_CLAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinInstruction::onClause)).setter(setter(Builder::onClause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEFT_OPERAND_FIELD,
            RIGHT_OPERAND_FIELD, TYPE_FIELD, ON_CLAUSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String leftOperand;

    private final String rightOperand;

    private final String type;

    private final String onClause;

    private JoinInstruction(BuilderImpl builder) {
        this.leftOperand = builder.leftOperand;
        this.rightOperand = builder.rightOperand;
        this.type = builder.type;
        this.onClause = builder.onClause;
    }

    /**
     * <p>
     * Left operand.
     * </p>
     * 
     * @return Left operand.
     */
    public String leftOperand() {
        return leftOperand;
    }

    /**
     * <p>
     * Right operand.
     * </p>
     * 
     * @return Right operand.
     */
    public String rightOperand() {
        return rightOperand;
    }

    /**
     * <p>
     * Type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JoinType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type.
     * @see JoinType
     */
    public JoinType type() {
        return JoinType.fromValue(type);
    }

    /**
     * <p>
     * Type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JoinType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type.
     * @see JoinType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * On Clause.
     * </p>
     * 
     * @return On Clause.
     */
    public String onClause() {
        return onClause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(leftOperand());
        hashCode = 31 * hashCode + Objects.hashCode(rightOperand());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onClause());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinInstruction)) {
            return false;
        }
        JoinInstruction other = (JoinInstruction) obj;
        return Objects.equals(leftOperand(), other.leftOperand()) && Objects.equals(rightOperand(), other.rightOperand())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(onClause(), other.onClause());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JoinInstruction").add("LeftOperand", leftOperand()).add("RightOperand", rightOperand())
                .add("Type", typeAsString()).add("OnClause", onClause()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LeftOperand":
            return Optional.ofNullable(clazz.cast(leftOperand()));
        case "RightOperand":
            return Optional.ofNullable(clazz.cast(rightOperand()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "OnClause":
            return Optional.ofNullable(clazz.cast(onClause()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinInstruction, T> g) {
        return obj -> g.apply((JoinInstruction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JoinInstruction> {
        /**
         * <p>
         * Left operand.
         * </p>
         * 
         * @param leftOperand
         *        Left operand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leftOperand(String leftOperand);

        /**
         * <p>
         * Right operand.
         * </p>
         * 
         * @param rightOperand
         *        Right operand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightOperand(String rightOperand);

        /**
         * <p>
         * Type.
         * </p>
         * 
         * @param type
         *        Type.
         * @see JoinType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinType
         */
        Builder type(String type);

        /**
         * <p>
         * Type.
         * </p>
         * 
         * @param type
         *        Type.
         * @see JoinType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinType
         */
        Builder type(JoinType type);

        /**
         * <p>
         * On Clause.
         * </p>
         * 
         * @param onClause
         *        On Clause.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onClause(String onClause);
    }

    static final class BuilderImpl implements Builder {
        private String leftOperand;

        private String rightOperand;

        private String type;

        private String onClause;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinInstruction model) {
            leftOperand(model.leftOperand);
            rightOperand(model.rightOperand);
            type(model.type);
            onClause(model.onClause);
        }

        public final String getLeftOperand() {
            return leftOperand;
        }

        @Override
        public final Builder leftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
            return this;
        }

        public final void setLeftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
        }

        public final String getRightOperand() {
            return rightOperand;
        }

        @Override
        public final Builder rightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
            return this;
        }

        public final void setRightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JoinType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOnClause() {
            return onClause;
        }

        @Override
        public final Builder onClause(String onClause) {
            this.onClause = onClause;
            return this;
        }

        public final void setOnClause(String onClause) {
            this.onClause = onClause;
        }

        @Override
        public JoinInstruction build() {
            return new JoinInstruction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
