/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameters implements SdkPojo, Serializable, ToCopyableBuilder<Parameters.Builder, Parameters> {
    private static final SdkField<List<StringParameter>> STRING_PARAMETERS_FIELD = SdkField
            .<List<StringParameter>> builder(MarshallingType.LIST)
            .getter(getter(Parameters::stringParameters))
            .setter(setter(Builder::stringParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IntegerParameter>> INTEGER_PARAMETERS_FIELD = SdkField
            .<List<IntegerParameter>> builder(MarshallingType.LIST)
            .getter(getter(Parameters::integerParameters))
            .setter(setter(Builder::integerParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegerParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegerParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DecimalParameter>> DECIMAL_PARAMETERS_FIELD = SdkField
            .<List<DecimalParameter>> builder(MarshallingType.LIST)
            .getter(getter(Parameters::decimalParameters))
            .setter(setter(Builder::decimalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DecimalParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DecimalParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeParameter>> DATE_TIME_PARAMETERS_FIELD = SdkField
            .<List<DateTimeParameter>> builder(MarshallingType.LIST)
            .getter(getter(Parameters::dateTimeParameters))
            .setter(setter(Builder::dateTimeParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_PARAMETERS_FIELD,
            INTEGER_PARAMETERS_FIELD, DECIMAL_PARAMETERS_FIELD, DATE_TIME_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringParameter> stringParameters;

    private final List<IntegerParameter> integerParameters;

    private final List<DecimalParameter> decimalParameters;

    private final List<DateTimeParameter> dateTimeParameters;

    private Parameters(BuilderImpl builder) {
        this.stringParameters = builder.stringParameters;
        this.integerParameters = builder.integerParameters;
        this.decimalParameters = builder.decimalParameters;
        this.dateTimeParameters = builder.dateTimeParameters;
    }

    /**
     * <p>
     * String parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return String parameters.
     */
    public List<StringParameter> stringParameters() {
        return stringParameters;
    }

    /**
     * <p>
     * Integer parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Integer parameters.
     */
    public List<IntegerParameter> integerParameters() {
        return integerParameters;
    }

    /**
     * <p>
     * Decimal parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Decimal parameters.
     */
    public List<DecimalParameter> decimalParameters() {
        return decimalParameters;
    }

    /**
     * <p>
     * DateTime parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return DateTime parameters.
     */
    public List<DateTimeParameter> dateTimeParameters() {
        return dateTimeParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringParameters());
        hashCode = 31 * hashCode + Objects.hashCode(integerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(decimalParameters());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters) obj;
        return Objects.equals(stringParameters(), other.stringParameters())
                && Objects.equals(integerParameters(), other.integerParameters())
                && Objects.equals(decimalParameters(), other.decimalParameters())
                && Objects.equals(dateTimeParameters(), other.dateTimeParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Parameters").add("StringParameters", stringParameters())
                .add("IntegerParameters", integerParameters()).add("DecimalParameters", decimalParameters())
                .add("DateTimeParameters", dateTimeParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringParameters":
            return Optional.ofNullable(clazz.cast(stringParameters()));
        case "IntegerParameters":
            return Optional.ofNullable(clazz.cast(integerParameters()));
        case "DecimalParameters":
            return Optional.ofNullable(clazz.cast(decimalParameters()));
        case "DateTimeParameters":
            return Optional.ofNullable(clazz.cast(dateTimeParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameters> {
        /**
         * <p>
         * String parameters.
         * </p>
         * 
         * @param stringParameters
         *        String parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringParameters(Collection<StringParameter> stringParameters);

        /**
         * <p>
         * String parameters.
         * </p>
         * 
         * @param stringParameters
         *        String parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringParameters(StringParameter... stringParameters);

        /**
         * <p>
         * String parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringParameter>.Builder} avoiding the need
         * to create one manually via {@link List<StringParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #stringParameters(List<StringParameter>)}.
         * 
         * @param stringParameters
         *        a consumer that will call methods on {@link List<StringParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringParameters(List<StringParameter>)
         */
        Builder stringParameters(Consumer<StringParameter.Builder>... stringParameters);

        /**
         * <p>
         * Integer parameters.
         * </p>
         * 
         * @param integerParameters
         *        Integer parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameters(Collection<IntegerParameter> integerParameters);

        /**
         * <p>
         * Integer parameters.
         * </p>
         * 
         * @param integerParameters
         *        Integer parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameters(IntegerParameter... integerParameters);

        /**
         * <p>
         * Integer parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntegerParameter>.Builder} avoiding the
         * need to create one manually via {@link List<IntegerParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntegerParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #integerParameters(List<IntegerParameter>)}.
         * 
         * @param integerParameters
         *        a consumer that will call methods on {@link List<IntegerParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerParameters(List<IntegerParameter>)
         */
        Builder integerParameters(Consumer<IntegerParameter.Builder>... integerParameters);

        /**
         * <p>
         * Decimal parameters.
         * </p>
         * 
         * @param decimalParameters
         *        Decimal parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalParameters(Collection<DecimalParameter> decimalParameters);

        /**
         * <p>
         * Decimal parameters.
         * </p>
         * 
         * @param decimalParameters
         *        Decimal parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalParameters(DecimalParameter... decimalParameters);

        /**
         * <p>
         * Decimal parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DecimalParameter>.Builder} avoiding the
         * need to create one manually via {@link List<DecimalParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DecimalParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #decimalParameters(List<DecimalParameter>)}.
         * 
         * @param decimalParameters
         *        a consumer that will call methods on {@link List<DecimalParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decimalParameters(List<DecimalParameter>)
         */
        Builder decimalParameters(Consumer<DecimalParameter.Builder>... decimalParameters);

        /**
         * <p>
         * DateTime parameters.
         * </p>
         * 
         * @param dateTimeParameters
         *        DateTime parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeParameters(Collection<DateTimeParameter> dateTimeParameters);

        /**
         * <p>
         * DateTime parameters.
         * </p>
         * 
         * @param dateTimeParameters
         *        DateTime parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeParameters(DateTimeParameter... dateTimeParameters);

        /**
         * <p>
         * DateTime parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateTimeParameter>.Builder} avoiding the
         * need to create one manually via {@link List<DateTimeParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateTimeParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #dateTimeParameters(List<DateTimeParameter>)}.
         * 
         * @param dateTimeParameters
         *        a consumer that will call methods on {@link List<DateTimeParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeParameters(List<DateTimeParameter>)
         */
        Builder dateTimeParameters(Consumer<DateTimeParameter.Builder>... dateTimeParameters);
    }

    static final class BuilderImpl implements Builder {
        private List<StringParameter> stringParameters = DefaultSdkAutoConstructList.getInstance();

        private List<IntegerParameter> integerParameters = DefaultSdkAutoConstructList.getInstance();

        private List<DecimalParameter> decimalParameters = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeParameter> dateTimeParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            stringParameters(model.stringParameters);
            integerParameters(model.integerParameters);
            decimalParameters(model.decimalParameters);
            dateTimeParameters(model.dateTimeParameters);
        }

        public final Collection<StringParameter.Builder> getStringParameters() {
            return stringParameters != null ? stringParameters.stream().map(StringParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stringParameters(Collection<StringParameter> stringParameters) {
            this.stringParameters = StringParameterListCopier.copy(stringParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringParameters(StringParameter... stringParameters) {
            stringParameters(Arrays.asList(stringParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringParameters(Consumer<StringParameter.Builder>... stringParameters) {
            stringParameters(Stream.of(stringParameters).map(c -> StringParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStringParameters(Collection<StringParameter.BuilderImpl> stringParameters) {
            this.stringParameters = StringParameterListCopier.copyFromBuilder(stringParameters);
        }

        public final Collection<IntegerParameter.Builder> getIntegerParameters() {
            return integerParameters != null ? integerParameters.stream().map(IntegerParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder integerParameters(Collection<IntegerParameter> integerParameters) {
            this.integerParameters = IntegerParameterListCopier.copy(integerParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameters(IntegerParameter... integerParameters) {
            integerParameters(Arrays.asList(integerParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameters(Consumer<IntegerParameter.Builder>... integerParameters) {
            integerParameters(Stream.of(integerParameters).map(c -> IntegerParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIntegerParameters(Collection<IntegerParameter.BuilderImpl> integerParameters) {
            this.integerParameters = IntegerParameterListCopier.copyFromBuilder(integerParameters);
        }

        public final Collection<DecimalParameter.Builder> getDecimalParameters() {
            return decimalParameters != null ? decimalParameters.stream().map(DecimalParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder decimalParameters(Collection<DecimalParameter> decimalParameters) {
            this.decimalParameters = DecimalParameterListCopier.copy(decimalParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalParameters(DecimalParameter... decimalParameters) {
            decimalParameters(Arrays.asList(decimalParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalParameters(Consumer<DecimalParameter.Builder>... decimalParameters) {
            decimalParameters(Stream.of(decimalParameters).map(c -> DecimalParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDecimalParameters(Collection<DecimalParameter.BuilderImpl> decimalParameters) {
            this.decimalParameters = DecimalParameterListCopier.copyFromBuilder(decimalParameters);
        }

        public final Collection<DateTimeParameter.Builder> getDateTimeParameters() {
            return dateTimeParameters != null ? dateTimeParameters.stream().map(DateTimeParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dateTimeParameters(Collection<DateTimeParameter> dateTimeParameters) {
            this.dateTimeParameters = DateTimeParameterListCopier.copy(dateTimeParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeParameters(DateTimeParameter... dateTimeParameters) {
            dateTimeParameters(Arrays.asList(dateTimeParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeParameters(Consumer<DateTimeParameter.Builder>... dateTimeParameters) {
            dateTimeParameters(Stream.of(dateTimeParameters).map(c -> DateTimeParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDateTimeParameters(Collection<DateTimeParameter.BuilderImpl> dateTimeParameters) {
            this.dateTimeParameters = DateTimeParameterListCopier.copyFromBuilder(dateTimeParameters);
        }

        @Override
        public Parameters build() {
            return new Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
