/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTemplateRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateTemplateRequest.Builder, CreateTemplateRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTemplateRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTemplateRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .getter(getter(CreateTemplateRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TemplateSourceEntity> SOURCE_ENTITY_FIELD = SdkField
            .<TemplateSourceEntity> builder(MarshallingType.SDK_POJO).getter(getter(CreateTemplateRequest::sourceEntity))
            .setter(setter(Builder::sourceEntity)).constructor(TemplateSourceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTemplateRequest::versionDescription)).setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TEMPLATE_ID_FIELD, NAME_FIELD, PERMISSIONS_FIELD, SOURCE_ENTITY_FIELD, TAGS_FIELD, VERSION_DESCRIPTION_FIELD));

    private final String awsAccountId;

    private final String templateId;

    private final String name;

    private final List<ResourcePermission> permissions;

    private final TemplateSourceEntity sourceEntity;

    private final List<Tag> tags;

    private final String versionDescription;

    private CreateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.permissions = builder.permissions;
        this.sourceEntity = builder.sourceEntity;
        this.tags = builder.tags;
        this.versionDescription = builder.versionDescription;
    }

    /**
     * <p>
     * The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your
     * Amazon QuickSight account.
     * </p>
     * 
     * @return The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that
     *         contains your Amazon QuickSight account.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An ID for the template you want to create. This is unique per AWS region per AWS account.
     * </p>
     * 
     * @return An ID for the template you want to create. This is unique per AWS region per AWS account.
     */
    public String templateId() {
        return templateId;
    }

    /**
     * <p>
     * A display name for the template.
     * </p>
     * 
     * @return A display name for the template.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A list of resource permissions to be set on the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of resource permissions to be set on the template.
     */
    public List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source entity from which this template is being created. Templates can be
     * currently created from an analysis or another template. If the ARN is for an analysis, you must include its
     * dataset references.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source entity from which this template is being created. Templates
     *         can be currently created from an analysis or another template. If the ARN is for an analysis, you must
     *         include its dataset references.
     */
    public TemplateSourceEntity sourceEntity() {
        return sourceEntity;
    }

    /**
     * <p>
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A description of the current template version being created. This API created the first version of the template.
     * Every time UpdateTemplate is called a new version is created. Each version of the template maintains a
     * description of the version in the VersionDescription field.
     * </p>
     * 
     * @return A description of the current template version being created. This API created the first version of the
     *         template. Every time UpdateTemplate is called a new version is created. Each version of the template
     *         maintains a description of the version in the VersionDescription field.
     */
    public String versionDescription() {
        return versionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateRequest)) {
            return false;
        }
        CreateTemplateRequest other = (CreateTemplateRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(name(), other.name()) && Objects.equals(permissions(), other.permissions())
                && Objects.equals(sourceEntity(), other.sourceEntity()) && Objects.equals(tags(), other.tags())
                && Objects.equals(versionDescription(), other.versionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTemplateRequest").add("AwsAccountId", awsAccountId()).add("TemplateId", templateId())
                .add("Name", name()).add("Permissions", permissions()).add("SourceEntity", sourceEntity()).add("Tags", tags())
                .add("VersionDescription", versionDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "SourceEntity":
            return Optional.ofNullable(clazz.cast(sourceEntity()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateRequest, T> g) {
        return obj -> g.apply((CreateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTemplateRequest> {
        /**
         * <p>
         * The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains
         * your Amazon QuickSight account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that
         *        contains your Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An ID for the template you want to create. This is unique per AWS region per AWS account.
         * </p>
         * 
         * @param templateId
         *        An ID for the template you want to create. This is unique per AWS region per AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * A display name for the template.
         * </p>
         * 
         * @param name
         *        A display name for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions to be set on the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions to be set on the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source entity from which this template is being created. Templates can
         * be currently created from an analysis or another template. If the ARN is for an analysis, you must include
         * its dataset references.
         * </p>
         * 
         * @param sourceEntity
         *        The Amazon Resource Name (ARN) of the source entity from which this template is being created.
         *        Templates can be currently created from an analysis or another template. If the ARN is for an
         *        analysis, you must include its dataset references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntity(TemplateSourceEntity sourceEntity);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source entity from which this template is being created. Templates can
         * be currently created from an analysis or another template. If the ARN is for an analysis, you must include
         * its dataset references.
         * </p>
         * This is a convenience that creates an instance of the {@link TemplateSourceEntity.Builder} avoiding the need
         * to create one manually via {@link TemplateSourceEntity#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateSourceEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceEntity(TemplateSourceEntity)}.
         * 
         * @param sourceEntity
         *        a consumer that will call methods on {@link TemplateSourceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEntity(TemplateSourceEntity)
         */
        default Builder sourceEntity(Consumer<TemplateSourceEntity.Builder> sourceEntity) {
            return sourceEntity(TemplateSourceEntity.builder().applyMutation(sourceEntity).build());
        }

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A description of the current template version being created. This API created the first version of the
         * template. Every time UpdateTemplate is called a new version is created. Each version of the template
         * maintains a description of the version in the VersionDescription field.
         * </p>
         * 
         * @param versionDescription
         *        A description of the current template version being created. This API created the first version of the
         *        template. Every time UpdateTemplate is called a new version is created. Each version of the template
         *        maintains a description of the version in the VersionDescription field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String templateId;

        private String name;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private TemplateSourceEntity sourceEntity;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String versionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            templateId(model.templateId);
            name(model.name);
            permissions(model.permissions);
            sourceEntity(model.sourceEntity);
            tags(model.tags);
            versionDescription(model.versionDescription);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getTemplateId() {
            return templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<ResourcePermission.Builder> getPermissions() {
            return permissions != null ? permissions.stream().map(ResourcePermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        public final TemplateSourceEntity.Builder getSourceEntity() {
            return sourceEntity != null ? sourceEntity.toBuilder() : null;
        }

        @Override
        public final Builder sourceEntity(TemplateSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final void setSourceEntity(TemplateSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateRequest build() {
            return new CreateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
