/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDashboardResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateDashboardResponse.Builder, CreateDashboardResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDashboardResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDashboardResponse::versionArn)).setter(setter(Builder::versionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionArn").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDashboardResponse::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDashboardResponse::creationStatusAsString)).setter(setter(Builder::creationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateDashboardResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDashboardResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VERSION_ARN_FIELD,
            DASHBOARD_ID_FIELD, CREATION_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final String arn;

    private final String versionArn;

    private final String dashboardId;

    private final String creationStatus;

    private final Integer status;

    private final String requestId;

    private CreateDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.versionArn = builder.versionArn;
        this.dashboardId = builder.dashboardId;
        this.creationStatus = builder.creationStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dashboard.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the dashboard, including the version number of the first version that is created.
     * </p>
     * 
     * @return The ARN of the dashboard, including the version number of the first version that is created.
     */
    public String versionArn() {
        return versionArn;
    }

    /**
     * <p>
     * The ID for the dashboard.
     * </p>
     * 
     * @return The ID for the dashboard.
     */
    public String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The creation status of the dashboard create request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of the dashboard create request.
     * @see ResourceStatus
     */
    public ResourceStatus creationStatus() {
        return ResourceStatus.fromValue(creationStatus);
    }

    /**
     * <p>
     * The creation status of the dashboard create request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of the dashboard create request.
     * @see ResourceStatus
     */
    public String creationStatusAsString() {
        return creationStatus;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(versionArn());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardResponse)) {
            return false;
        }
        CreateDashboardResponse other = (CreateDashboardResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(versionArn(), other.versionArn())
                && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(creationStatusAsString(), other.creationStatusAsString())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDashboardResponse").add("Arn", arn()).add("VersionArn", versionArn())
                .add("DashboardId", dashboardId()).add("CreationStatus", creationStatusAsString()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "VersionArn":
            return Optional.ofNullable(clazz.cast(versionArn()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "CreationStatus":
            return Optional.ofNullable(clazz.cast(creationStatusAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardResponse, T> g) {
        return obj -> g.apply((CreateDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDashboardResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the dashboard, including the version number of the first version that is created.
         * </p>
         * 
         * @param versionArn
         *        The ARN of the dashboard, including the version number of the first version that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionArn(String versionArn);

        /**
         * <p>
         * The ID for the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The ID for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The creation status of the dashboard create request.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of the dashboard create request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(String creationStatus);

        /**
         * <p>
         * The creation status of the dashboard create request.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of the dashboard create request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(ResourceStatus creationStatus);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String versionArn;

        private String dashboardId;

        private String creationStatus;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardResponse model) {
            super(model);
            arn(model.arn);
            versionArn(model.versionArn);
            dashboardId(model.dashboardId);
            creationStatus(model.creationStatus);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getVersionArn() {
            return versionArn;
        }

        @Override
        public final Builder versionArn(String versionArn) {
            this.versionArn = versionArn;
            return this;
        }

        public final void setVersionArn(String versionArn) {
            this.versionArn = versionArn;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getCreationStatusAsString() {
            return creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(ResourceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public CreateDashboardResponse build() {
            return new CreateDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
