/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DashboardError;
import software.amazon.awssdk.services.quicksight.model.DashboardErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardVersion> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DashboardVersion.getter(DashboardVersion::createdTime)).setter(DashboardVersion.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<DashboardError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DashboardVersion.getter(DashboardVersion::errors)).setter(DashboardVersion.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashboardError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DashboardVersion.getter(DashboardVersion::versionNumber)).setter(DashboardVersion.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashboardVersion.getter(DashboardVersion::statusAsString)).setter(DashboardVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashboardVersion.getter(DashboardVersion::arn)).setter(DashboardVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> SOURCE_ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashboardVersion.getter(DashboardVersion::sourceEntityArn)).setter(DashboardVersion.setter(Builder::sourceEntityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntityArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashboardVersion.getter(DashboardVersion::description)).setter(DashboardVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD, ERRORS_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD, ARN_FIELD, SOURCE_ENTITY_ARN_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdTime;
    private final List<DashboardError> errors;
    private final Long versionNumber;
    private final String status;
    private final String arn;
    private final String sourceEntityArn;
    private final String description;

    private DashboardVersion(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.errors = builder.errors;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.arn = builder.arn;
        this.sourceEntityArn = builder.sourceEntityArn;
        this.description = builder.description;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public List<DashboardError> errors() {
        return this.errors;
    }

    public Long versionNumber() {
        return this.versionNumber;
    }

    public ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String arn() {
        return this.arn;
    }

    public String sourceEntityArn() {
        return this.sourceEntityArn;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEntityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVersion)) {
            return false;
        }
        DashboardVersion other = (DashboardVersion)obj;
        return Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.sourceEntityArn(), other.sourceEntityArn()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"DashboardVersion").add("CreatedTime", (Object)this.createdTime()).add("Errors", this.errors()).add("VersionNumber", (Object)this.versionNumber()).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).add("SourceEntityArn", (Object)this.sourceEntityArn()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "SourceEntityArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEntityArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardVersion, T> g) {
        return obj -> g.apply((DashboardVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdTime;
        private List<DashboardError> errors = DefaultSdkAutoConstructList.getInstance();
        private Long versionNumber;
        private String status;
        private String arn;
        private String sourceEntityArn;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVersion model) {
            this.createdTime(model.createdTime);
            this.errors(model.errors);
            this.versionNumber(model.versionNumber);
            this.status(model.status);
            this.arn(model.arn);
            this.sourceEntityArn(model.sourceEntityArn);
            this.description(model.description);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<DashboardError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(DashboardError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<DashboardError> errors) {
            this.errors = DashboardErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DashboardError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DashboardError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (DashboardError)((DashboardError.Builder)DashboardError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<DashboardError.BuilderImpl> errors) {
            this.errors = DashboardErrorListCopier.copyFromBuilder(errors);
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSourceEntityArn() {
            return this.sourceEntityArn;
        }

        @Override
        public final Builder sourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
            return this;
        }

        public final void setSourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public DashboardVersion build() {
            return new DashboardVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardVersion> {
        public Builder createdTime(Instant var1);

        public Builder errors(Collection<DashboardError> var1);

        public Builder errors(DashboardError ... var1);

        public Builder errors(Consumer<DashboardError.Builder> ... var1);

        public Builder versionNumber(Long var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder arn(String var1);

        public Builder sourceEntityArn(String var1);

        public Builder description(String var1);
    }
}

