/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDashboardVersionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListDashboardVersionsResponse.Builder, ListDashboardVersionsResponse> {
    private static final SdkField<List<DashboardVersionSummary>> DASHBOARD_VERSION_SUMMARY_LIST_FIELD = SdkField
            .<List<DashboardVersionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListDashboardVersionsResponse::dashboardVersionSummaryList))
            .setter(setter(Builder::dashboardVersionSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardVersionSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashboardVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashboardVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDashboardVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDashboardVersionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDashboardVersionsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DASHBOARD_VERSION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final List<DashboardVersionSummary> dashboardVersionSummaryList;

    private final String nextToken;

    private final Integer status;

    private final String requestId;

    private ListDashboardVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardVersionSummaryList = builder.dashboardVersionSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * A structure that contains information about each version of the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A structure that contains information about each version of the dashboard.
     */
    public List<DashboardVersionSummary> dashboardVersionSummaryList() {
        return dashboardVersionSummaryList;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardVersionSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardVersionsResponse)) {
            return false;
        }
        ListDashboardVersionsResponse other = (ListDashboardVersionsResponse) obj;
        return Objects.equals(dashboardVersionSummaryList(), other.dashboardVersionSummaryList())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDashboardVersionsResponse")
                .add("DashboardVersionSummaryList", dashboardVersionSummaryList()).add("NextToken", nextToken())
                .add("Status", status()).add("RequestId", requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardVersionSummaryList":
            return Optional.ofNullable(clazz.cast(dashboardVersionSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardVersionsResponse, T> g) {
        return obj -> g.apply((ListDashboardVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDashboardVersionsResponse> {
        /**
         * <p>
         * A structure that contains information about each version of the dashboard.
         * </p>
         * 
         * @param dashboardVersionSummaryList
         *        A structure that contains information about each version of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardVersionSummaryList(Collection<DashboardVersionSummary> dashboardVersionSummaryList);

        /**
         * <p>
         * A structure that contains information about each version of the dashboard.
         * </p>
         * 
         * @param dashboardVersionSummaryList
         *        A structure that contains information about each version of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardVersionSummaryList(DashboardVersionSummary... dashboardVersionSummaryList);

        /**
         * <p>
         * A structure that contains information about each version of the dashboard.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DashboardVersionSummary>.Builder} avoiding
         * the need to create one manually via {@link List<DashboardVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashboardVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #dashboardVersionSummaryList(List<DashboardVersionSummary>)}.
         * 
         * @param dashboardVersionSummaryList
         *        a consumer that will call methods on {@link List<DashboardVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardVersionSummaryList(List<DashboardVersionSummary>)
         */
        Builder dashboardVersionSummaryList(Consumer<DashboardVersionSummary.Builder>... dashboardVersionSummaryList);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<DashboardVersionSummary> dashboardVersionSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardVersionsResponse model) {
            super(model);
            dashboardVersionSummaryList(model.dashboardVersionSummaryList);
            nextToken(model.nextToken);
            status(model.status);
            requestId(model.requestId);
        }

        public final Collection<DashboardVersionSummary.Builder> getDashboardVersionSummaryList() {
            return dashboardVersionSummaryList != null ? dashboardVersionSummaryList.stream()
                    .map(DashboardVersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardVersionSummaryList(Collection<DashboardVersionSummary> dashboardVersionSummaryList) {
            this.dashboardVersionSummaryList = DashboardVersionSummaryListCopier.copy(dashboardVersionSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardVersionSummaryList(DashboardVersionSummary... dashboardVersionSummaryList) {
            dashboardVersionSummaryList(Arrays.asList(dashboardVersionSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardVersionSummaryList(Consumer<DashboardVersionSummary.Builder>... dashboardVersionSummaryList) {
            dashboardVersionSummaryList(Stream.of(dashboardVersionSummaryList)
                    .map(c -> DashboardVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDashboardVersionSummaryList(
                Collection<DashboardVersionSummary.BuilderImpl> dashboardVersionSummaryList) {
            this.dashboardVersionSummaryList = DashboardVersionSummaryListCopier.copyFromBuilder(dashboardVersionSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public ListDashboardVersionsResponse build() {
            return new ListDashboardVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
