/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that renames a column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenameColumnOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<RenameColumnOperation.Builder, RenameColumnOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RenameColumnOperation::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> NEW_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RenameColumnOperation::newColumnName)).setter(setter(Builder::newColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            NEW_COLUMN_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String newColumnName;

    private RenameColumnOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.newColumnName = builder.newColumnName;
    }

    /**
     * <p>
     * Name of the column to be renamed.
     * </p>
     * 
     * @return Name of the column to be renamed.
     */
    public String columnName() {
        return columnName;
    }

    /**
     * <p>
     * New name for the column.
     * </p>
     * 
     * @return New name for the column.
     */
    public String newColumnName() {
        return newColumnName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(newColumnName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameColumnOperation)) {
            return false;
        }
        RenameColumnOperation other = (RenameColumnOperation) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(newColumnName(), other.newColumnName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RenameColumnOperation").add("ColumnName", columnName()).add("NewColumnName", newColumnName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "NewColumnName":
            return Optional.ofNullable(clazz.cast(newColumnName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenameColumnOperation, T> g) {
        return obj -> g.apply((RenameColumnOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenameColumnOperation> {
        /**
         * <p>
         * Name of the column to be renamed.
         * </p>
         * 
         * @param columnName
         *        Name of the column to be renamed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * New name for the column.
         * </p>
         * 
         * @param newColumnName
         *        New name for the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newColumnName(String newColumnName);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String newColumnName;

        private BuilderImpl() {
        }

        private BuilderImpl(RenameColumnOperation model) {
            columnName(model.columnName);
            newColumnName(model.newColumnName);
        }

        public final String getColumnName() {
            return columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final String getNewColumnName() {
            return newColumnName;
        }

        @Override
        public final Builder newColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
            return this;
        }

        public final void setNewColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
        }

        @Override
        public RenameColumnOperation build() {
            return new RenameColumnOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
