/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSet implements SdkPojo, Serializable, ToCopyableBuilder<DataSet.Builder, DataSet> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSet::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DataSet::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DataSet::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Map<String, PhysicalTable>> PHYSICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, PhysicalTable>> builder(MarshallingType.MAP)
            .getter(getter(DataSet::physicalTableMap))
            .setter(setter(Builder::physicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PhysicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhysicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, LogicalTable>> LOGICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, LogicalTable>> builder(MarshallingType.MAP)
            .getter(getter(DataSet::logicalTableMap))
            .setter(setter(Builder::logicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LogicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<OutputColumn>> OUTPUT_COLUMNS_FIELD = SdkField
            .<List<OutputColumn>> builder(MarshallingType.LIST)
            .getter(getter(DataSet::outputColumns))
            .setter(setter(Builder::outputColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSet::importModeAsString)).setter(setter(Builder::importMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()).build();

    private static final SdkField<Long> CONSUMED_SPICE_CAPACITY_IN_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DataSet::consumedSpiceCapacityInBytes))
            .setter(setter(Builder::consumedSpiceCapacityInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedSpiceCapacityInBytes")
                    .build()).build();

    private static final SdkField<List<ColumnGroup>> COLUMN_GROUPS_FIELD = SdkField
            .<List<ColumnGroup>> builder(MarshallingType.LIST)
            .getter(getter(DataSet::columnGroups))
            .setter(setter(Builder::columnGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField
            .<RowLevelPermissionDataSet> builder(MarshallingType.SDK_POJO).getter(getter(DataSet::rowLevelPermissionDataSet))
            .setter(setter(Builder::rowLevelPermissionDataSet)).constructor(RowLevelPermissionDataSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_ID_FIELD,
            NAME_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, PHYSICAL_TABLE_MAP_FIELD, LOGICAL_TABLE_MAP_FIELD,
            OUTPUT_COLUMNS_FIELD, IMPORT_MODE_FIELD, CONSUMED_SPICE_CAPACITY_IN_BYTES_FIELD, COLUMN_GROUPS_FIELD,
            ROW_LEVEL_PERMISSION_DATA_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String dataSetId;

    private final String name;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final Map<String, PhysicalTable> physicalTableMap;

    private final Map<String, LogicalTable> logicalTableMap;

    private final List<OutputColumn> outputColumns;

    private final String importMode;

    private final Long consumedSpiceCapacityInBytes;

    private final List<ColumnGroup> columnGroups;

    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;

    private DataSet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.physicalTableMap = builder.physicalTableMap;
        this.logicalTableMap = builder.logicalTableMap;
        this.outputColumns = builder.outputColumns;
        this.importMode = builder.importMode;
        this.consumedSpiceCapacityInBytes = builder.consumedSpiceCapacityInBytes;
        this.columnGroups = builder.columnGroups;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * A display name for the dataset.
     * </p>
     * 
     * @return A display name for the dataset.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time that this dataset was created.
     * </p>
     * 
     * @return The time that this dataset was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last time that this dataset was updated.
     * </p>
     * 
     * @return The last time that this dataset was updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Declares the physical tables that are available in the underlying data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Declares the physical tables that are available in the underlying data sources.
     */
    public Map<String, PhysicalTable> physicalTableMap() {
        return physicalTableMap;
    }

    /**
     * <p>
     * Configures the combination and transformation of the data from the physical tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Configures the combination and transformation of the data from the physical tables.
     */
    public Map<String, LogicalTable> logicalTableMap() {
        return logicalTableMap;
    }

    /**
     * <p>
     * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of columns after all transforms. These columns are available in templates, analyses, and
     *         dashboards.
     */
    public List<OutputColumn> outputColumns() {
        return outputColumns;
    }

    /**
     * <p>
     * Indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return Indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(importMode);
    }

    /**
     * <p>
     * Indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return Indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public String importModeAsString() {
        return importMode;
    }

    /**
     * <p>
     * The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
     * </p>
     * 
     * @return The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
     */
    public Long consumedSpiceCapacityInBytes() {
        return consumedSpiceCapacityInBytes;
    }

    /**
     * <p>
     * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
     * hierarchy is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
     *         hierarchy is supported.
     */
    public List<ColumnGroup> columnGroups() {
        return columnGroups;
    }

    /**
     * <p>
     * The row-level security configuration for the dataset.
     * </p>
     * 
     * @return The row-level security configuration for the dataset.
     */
    public RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return rowLevelPermissionDataSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(physicalTableMap());
        hashCode = 31 * hashCode + Objects.hashCode(logicalTableMap());
        hashCode = 31 * hashCode + Objects.hashCode(outputColumns());
        hashCode = 31 * hashCode + Objects.hashCode(importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(consumedSpiceCapacityInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(columnGroups());
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionDataSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(name(), other.name()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(physicalTableMap(), other.physicalTableMap())
                && Objects.equals(logicalTableMap(), other.logicalTableMap())
                && Objects.equals(outputColumns(), other.outputColumns())
                && Objects.equals(importModeAsString(), other.importModeAsString())
                && Objects.equals(consumedSpiceCapacityInBytes(), other.consumedSpiceCapacityInBytes())
                && Objects.equals(columnGroups(), other.columnGroups())
                && Objects.equals(rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSet").add("Arn", arn()).add("DataSetId", dataSetId()).add("Name", name())
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("PhysicalTableMap", physicalTableMap()).add("LogicalTableMap", logicalTableMap())
                .add("OutputColumns", outputColumns()).add("ImportMode", importModeAsString())
                .add("ConsumedSpiceCapacityInBytes", consumedSpiceCapacityInBytes()).add("ColumnGroups", columnGroups())
                .add("RowLevelPermissionDataSet", rowLevelPermissionDataSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "PhysicalTableMap":
            return Optional.ofNullable(clazz.cast(physicalTableMap()));
        case "LogicalTableMap":
            return Optional.ofNullable(clazz.cast(logicalTableMap()));
        case "OutputColumns":
            return Optional.ofNullable(clazz.cast(outputColumns()));
        case "ImportMode":
            return Optional.ofNullable(clazz.cast(importModeAsString()));
        case "ConsumedSpiceCapacityInBytes":
            return Optional.ofNullable(clazz.cast(consumedSpiceCapacityInBytes()));
        case "ColumnGroups":
            return Optional.ofNullable(clazz.cast(columnGroups()));
        case "RowLevelPermissionDataSet":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionDataSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSet, T> g) {
        return obj -> g.apply((DataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSet> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param dataSetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * A display name for the dataset.
         * </p>
         * 
         * @param name
         *        A display name for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time that this dataset was created.
         * </p>
         * 
         * @param createdTime
         *        The time that this dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last time that this dataset was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time that this dataset was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Declares the physical tables that are available in the underlying data sources.
         * </p>
         * 
         * @param physicalTableMap
         *        Declares the physical tables that are available in the underlying data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap);

        /**
         * <p>
         * Configures the combination and transformation of the data from the physical tables.
         * </p>
         * 
         * @param logicalTableMap
         *        Configures the combination and transformation of the data from the physical tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap);

        /**
         * <p>
         * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
         * </p>
         * 
         * @param outputColumns
         *        The list of columns after all transforms. These columns are available in templates, analyses, and
         *        dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumns(Collection<OutputColumn> outputColumns);

        /**
         * <p>
         * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
         * </p>
         * 
         * @param outputColumns
         *        The list of columns after all transforms. These columns are available in templates, analyses, and
         *        dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumns(OutputColumn... outputColumns);

        /**
         * <p>
         * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OutputColumn>.Builder} avoiding the need to
         * create one manually via {@link List<OutputColumn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputColumn>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputColumns(List<OutputColumn>)}.
         * 
         * @param outputColumns
         *        a consumer that will call methods on {@link List<OutputColumn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputColumns(List<OutputColumn>)
         */
        Builder outputColumns(Consumer<OutputColumn.Builder>... outputColumns);

        /**
         * <p>
         * Indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        Indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(String importMode);

        /**
         * <p>
         * Indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        Indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(DataSetImportMode importMode);

        /**
         * <p>
         * The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
         * </p>
         * 
         * @param consumedSpiceCapacityInBytes
         *        The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only
         *        geospatial hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(Collection<ColumnGroup> columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only
         *        geospatial hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(ColumnGroup... columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnGroup>.Builder} avoiding the need to
         * create one manually via {@link List<ColumnGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #columnGroups(List<ColumnGroup>)}.
         * 
         * @param columnGroups
         *        a consumer that will call methods on {@link List<ColumnGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnGroups(List<ColumnGroup>)
         */
        Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups);

        /**
         * <p>
         * The row-level security configuration for the dataset.
         * </p>
         * 
         * @param rowLevelPermissionDataSet
         *        The row-level security configuration for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet);

        /**
         * <p>
         * The row-level security configuration for the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link RowLevelPermissionDataSet.Builder} avoiding the
         * need to create one manually via {@link RowLevelPermissionDataSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link RowLevelPermissionDataSet.Builder#build()} is called immediately
         * and its result is passed to {@link #rowLevelPermissionDataSet(RowLevelPermissionDataSet)}.
         * 
         * @param rowLevelPermissionDataSet
         *        a consumer that will call methods on {@link RowLevelPermissionDataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionDataSet(RowLevelPermissionDataSet)
         */
        default Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return rowLevelPermissionDataSet(RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String dataSetId;

        private String name;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private Map<String, PhysicalTable> physicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, LogicalTable> logicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private List<OutputColumn> outputColumns = DefaultSdkAutoConstructList.getInstance();

        private String importMode;

        private Long consumedSpiceCapacityInBytes;

        private List<ColumnGroup> columnGroups = DefaultSdkAutoConstructList.getInstance();

        private RowLevelPermissionDataSet rowLevelPermissionDataSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSet model) {
            arn(model.arn);
            dataSetId(model.dataSetId);
            name(model.name);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            physicalTableMap(model.physicalTableMap);
            logicalTableMap(model.logicalTableMap);
            outputColumns(model.outputColumns);
            importMode(model.importMode);
            consumedSpiceCapacityInBytes(model.consumedSpiceCapacityInBytes);
            columnGroups(model.columnGroups);
            rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final Map<String, PhysicalTable.Builder> getPhysicalTableMap() {
            return physicalTableMap != null ? CollectionUtils.mapValues(physicalTableMap, PhysicalTable::toBuilder) : null;
        }

        @Override
        public final Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copy(physicalTableMap);
            return this;
        }

        public final void setPhysicalTableMap(Map<String, PhysicalTable.BuilderImpl> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copyFromBuilder(physicalTableMap);
        }

        public final Map<String, LogicalTable.Builder> getLogicalTableMap() {
            return logicalTableMap != null ? CollectionUtils.mapValues(logicalTableMap, LogicalTable::toBuilder) : null;
        }

        @Override
        public final Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copy(logicalTableMap);
            return this;
        }

        public final void setLogicalTableMap(Map<String, LogicalTable.BuilderImpl> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copyFromBuilder(logicalTableMap);
        }

        public final Collection<OutputColumn.Builder> getOutputColumns() {
            return outputColumns != null ? outputColumns.stream().map(OutputColumn::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder outputColumns(Collection<OutputColumn> outputColumns) {
            this.outputColumns = OutputColumnListCopier.copy(outputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputColumns(OutputColumn... outputColumns) {
            outputColumns(Arrays.asList(outputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputColumns(Consumer<OutputColumn.Builder>... outputColumns) {
            outputColumns(Stream.of(outputColumns).map(c -> OutputColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputColumns(Collection<OutputColumn.BuilderImpl> outputColumns) {
            this.outputColumns = OutputColumnListCopier.copyFromBuilder(outputColumns);
        }

        public final String getImportModeAsString() {
            return importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        public final Long getConsumedSpiceCapacityInBytes() {
            return consumedSpiceCapacityInBytes;
        }

        @Override
        public final Builder consumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes) {
            this.consumedSpiceCapacityInBytes = consumedSpiceCapacityInBytes;
            return this;
        }

        public final void setConsumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes) {
            this.consumedSpiceCapacityInBytes = consumedSpiceCapacityInBytes;
        }

        public final Collection<ColumnGroup.Builder> getColumnGroups() {
            return columnGroups != null ? columnGroups.stream().map(ColumnGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnGroups(Collection<ColumnGroup> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copy(columnGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(ColumnGroup... columnGroups) {
            columnGroups(Arrays.asList(columnGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups) {
            columnGroups(Stream.of(columnGroups).map(c -> ColumnGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setColumnGroups(Collection<ColumnGroup.BuilderImpl> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copyFromBuilder(columnGroups);
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.toBuilder() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        public DataSet build() {
            return new DataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
