/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSetRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateDataSetRequest.Builder, UpdateDataSetRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSetRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSetRequest::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, PhysicalTable>> PHYSICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, PhysicalTable>> builder(MarshallingType.MAP)
            .getter(getter(UpdateDataSetRequest::physicalTableMap))
            .setter(setter(Builder::physicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PhysicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhysicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, LogicalTable>> LOGICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, LogicalTable>> builder(MarshallingType.MAP)
            .getter(getter(UpdateDataSetRequest::logicalTableMap))
            .setter(setter(Builder::logicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LogicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSetRequest::importModeAsString)).setter(setter(Builder::importMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()).build();

    private static final SdkField<List<ColumnGroup>> COLUMN_GROUPS_FIELD = SdkField
            .<List<ColumnGroup>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDataSetRequest::columnGroups))
            .setter(setter(Builder::columnGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField
            .<RowLevelPermissionDataSet> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDataSetRequest::rowLevelPermissionDataSet)).setter(setter(Builder::rowLevelPermissionDataSet))
            .constructor(RowLevelPermissionDataSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DATA_SET_ID_FIELD, NAME_FIELD, PHYSICAL_TABLE_MAP_FIELD, LOGICAL_TABLE_MAP_FIELD, IMPORT_MODE_FIELD,
            COLUMN_GROUPS_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_FIELD));

    private final String awsAccountId;

    private final String dataSetId;

    private final String name;

    private final Map<String, PhysicalTable> physicalTableMap;

    private final Map<String, LogicalTable> logicalTableMap;

    private final String importMode;

    private final List<ColumnGroup> columnGroups;

    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;

    private UpdateDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.physicalTableMap = builder.physicalTableMap;
        this.logicalTableMap = builder.logicalTableMap;
        this.importMode = builder.importMode;
        this.columnGroups = builder.columnGroups;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the dataset that you want to update. This ID is unique per AWS Region for each AWS account.
     * </p>
     * 
     * @return The ID for the dataset that you want to update. This ID is unique per AWS Region for each AWS account.
     */
    public String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The display name for the dataset.
     * </p>
     * 
     * @return The display name for the dataset.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Declares the physical tables that are available in the underlying data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Declares the physical tables that are available in the underlying data sources.
     */
    public Map<String, PhysicalTable> physicalTableMap() {
        return physicalTableMap;
    }

    /**
     * <p>
     * Configures the combination and transformation of the data from the physical tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Configures the combination and transformation of the data from the physical tables.
     */
    public Map<String, LogicalTable> logicalTableMap() {
        return logicalTableMap;
    }

    /**
     * <p>
     * Indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return Indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(importMode);
    }

    /**
     * <p>
     * Indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return Indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public String importModeAsString() {
        return importMode;
    }

    /**
     * <p>
     * Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy is
     * supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Groupings of columns that work together in certain QuickSight features. Currently, only geospatial
     *         hierarchy is supported.
     */
    public List<ColumnGroup> columnGroups() {
        return columnGroups;
    }

    /**
     * <p>
     * The row-level security configuration for the data you want to create.
     * </p>
     * 
     * @return The row-level security configuration for the data you want to create.
     */
    public RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return rowLevelPermissionDataSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(physicalTableMap());
        hashCode = 31 * hashCode + Objects.hashCode(logicalTableMap());
        hashCode = 31 * hashCode + Objects.hashCode(importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(columnGroups());
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionDataSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSetRequest)) {
            return false;
        }
        UpdateDataSetRequest other = (UpdateDataSetRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(name(), other.name()) && Objects.equals(physicalTableMap(), other.physicalTableMap())
                && Objects.equals(logicalTableMap(), other.logicalTableMap())
                && Objects.equals(importModeAsString(), other.importModeAsString())
                && Objects.equals(columnGroups(), other.columnGroups())
                && Objects.equals(rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDataSetRequest").add("AwsAccountId", awsAccountId()).add("DataSetId", dataSetId())
                .add("Name", name()).add("PhysicalTableMap", physicalTableMap()).add("LogicalTableMap", logicalTableMap())
                .add("ImportMode", importModeAsString()).add("ColumnGroups", columnGroups())
                .add("RowLevelPermissionDataSet", rowLevelPermissionDataSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PhysicalTableMap":
            return Optional.ofNullable(clazz.cast(physicalTableMap()));
        case "LogicalTableMap":
            return Optional.ofNullable(clazz.cast(logicalTableMap()));
        case "ImportMode":
            return Optional.ofNullable(clazz.cast(importModeAsString()));
        case "ColumnGroups":
            return Optional.ofNullable(clazz.cast(columnGroups()));
        case "RowLevelPermissionDataSet":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionDataSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSetRequest, T> g) {
        return obj -> g.apply((UpdateDataSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSetRequest> {
        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the dataset that you want to update. This ID is unique per AWS Region for each AWS account.
         * </p>
         * 
         * @param dataSetId
         *        The ID for the dataset that you want to update. This ID is unique per AWS Region for each AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The display name for the dataset.
         * </p>
         * 
         * @param name
         *        The display name for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Declares the physical tables that are available in the underlying data sources.
         * </p>
         * 
         * @param physicalTableMap
         *        Declares the physical tables that are available in the underlying data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap);

        /**
         * <p>
         * Configures the combination and transformation of the data from the physical tables.
         * </p>
         * 
         * @param logicalTableMap
         *        Configures the combination and transformation of the data from the physical tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap);

        /**
         * <p>
         * Indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        Indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(String importMode);

        /**
         * <p>
         * Indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        Indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(DataSetImportMode importMode);

        /**
         * <p>
         * Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy
         * is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain QuickSight features. Currently, only geospatial
         *        hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(Collection<ColumnGroup> columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy
         * is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain QuickSight features. Currently, only geospatial
         *        hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(ColumnGroup... columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy
         * is supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnGroup>.Builder} avoiding the need to
         * create one manually via {@link List<ColumnGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #columnGroups(List<ColumnGroup>)}.
         * 
         * @param columnGroups
         *        a consumer that will call methods on {@link List<ColumnGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnGroups(List<ColumnGroup>)
         */
        Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups);

        /**
         * <p>
         * The row-level security configuration for the data you want to create.
         * </p>
         * 
         * @param rowLevelPermissionDataSet
         *        The row-level security configuration for the data you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet);

        /**
         * <p>
         * The row-level security configuration for the data you want to create.
         * </p>
         * This is a convenience that creates an instance of the {@link RowLevelPermissionDataSet.Builder} avoiding the
         * need to create one manually via {@link RowLevelPermissionDataSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link RowLevelPermissionDataSet.Builder#build()} is called immediately
         * and its result is passed to {@link #rowLevelPermissionDataSet(RowLevelPermissionDataSet)}.
         * 
         * @param rowLevelPermissionDataSet
         *        a consumer that will call methods on {@link RowLevelPermissionDataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionDataSet(RowLevelPermissionDataSet)
         */
        default Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return rowLevelPermissionDataSet(RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dataSetId;

        private String name;

        private Map<String, PhysicalTable> physicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, LogicalTable> logicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private String importMode;

        private List<ColumnGroup> columnGroups = DefaultSdkAutoConstructList.getInstance();

        private RowLevelPermissionDataSet rowLevelPermissionDataSet;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSetRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dataSetId(model.dataSetId);
            name(model.name);
            physicalTableMap(model.physicalTableMap);
            logicalTableMap(model.logicalTableMap);
            importMode(model.importMode);
            columnGroups(model.columnGroups);
            rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, PhysicalTable.Builder> getPhysicalTableMap() {
            return physicalTableMap != null ? CollectionUtils.mapValues(physicalTableMap, PhysicalTable::toBuilder) : null;
        }

        @Override
        public final Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copy(physicalTableMap);
            return this;
        }

        public final void setPhysicalTableMap(Map<String, PhysicalTable.BuilderImpl> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copyFromBuilder(physicalTableMap);
        }

        public final Map<String, LogicalTable.Builder> getLogicalTableMap() {
            return logicalTableMap != null ? CollectionUtils.mapValues(logicalTableMap, LogicalTable::toBuilder) : null;
        }

        @Override
        public final Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copy(logicalTableMap);
            return this;
        }

        public final void setLogicalTableMap(Map<String, LogicalTable.BuilderImpl> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copyFromBuilder(logicalTableMap);
        }

        public final String getImportModeAsString() {
            return importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        public final Collection<ColumnGroup.Builder> getColumnGroups() {
            return columnGroups != null ? columnGroups.stream().map(ColumnGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnGroups(Collection<ColumnGroup> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copy(columnGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(ColumnGroup... columnGroups) {
            columnGroups(Arrays.asList(columnGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups) {
            columnGroups(Stream.of(columnGroups).map(c -> ColumnGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setColumnGroups(Collection<ColumnGroup.BuilderImpl> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copyFromBuilder(columnGroups);
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.toBuilder() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSetRequest build() {
            return new UpdateDataSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
