/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.InputColumn;
import software.amazon.awssdk.services.quicksight.model.InputColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomSql
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomSql> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomSql.getter(CustomSql::dataSourceArn)).setter(CustomSql.setter(Builder::dataSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomSql.getter(CustomSql::name)).setter(CustomSql.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SQL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomSql.getter(CustomSql::sqlQuery)).setter(CustomSql.setter(Builder::sqlQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlQuery").build()}).build();
    private static final SdkField<List<InputColumn>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CustomSql.getter(CustomSql::columns)).setter(CustomSql.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD, NAME_FIELD, SQL_QUERY_FIELD, COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSourceArn;
    private final String name;
    private final String sqlQuery;
    private final List<InputColumn> columns;

    private CustomSql(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.name = builder.name;
        this.sqlQuery = builder.sqlQuery;
        this.columns = builder.columns;
    }

    public String dataSourceArn() {
        return this.dataSourceArn;
    }

    public String name() {
        return this.name;
    }

    public String sqlQuery() {
        return this.sqlQuery;
    }

    public List<InputColumn> columns() {
        return this.columns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.columns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomSql)) {
            return false;
        }
        CustomSql other = (CustomSql)obj;
        return Objects.equals(this.dataSourceArn(), other.dataSourceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sqlQuery(), other.sqlQuery()) && Objects.equals(this.columns(), other.columns());
    }

    public String toString() {
        return ToString.builder((String)"CustomSql").add("DataSourceArn", (Object)this.dataSourceArn()).add("Name", (Object)this.name()).add("SqlQuery", (Object)this.sqlQuery()).add("Columns", this.columns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceArn": {
                return Optional.ofNullable(clazz.cast(this.dataSourceArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SqlQuery": {
                return Optional.ofNullable(clazz.cast(this.sqlQuery()));
            }
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomSql, T> g) {
        return obj -> g.apply((CustomSql)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceArn;
        private String name;
        private String sqlQuery;
        private List<InputColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomSql model) {
            this.dataSourceArn(model.dataSourceArn);
            this.name(model.name);
            this.sqlQuery(model.sqlQuery);
            this.columns(model.columns);
        }

        public final String getDataSourceArn() {
            return this.dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSqlQuery() {
            return this.sqlQuery;
        }

        @Override
        public final Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public final void setSqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        public final Collection<InputColumn.Builder> getColumns() {
            return this.columns != null ? (Collection)this.columns.stream().map(InputColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columns(Collection<InputColumn> columns) {
            this.columns = InputColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(InputColumn ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<InputColumn.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (InputColumn)((InputColumn.Builder)InputColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumns(Collection<InputColumn.BuilderImpl> columns) {
            this.columns = InputColumnListCopier.copyFromBuilder(columns);
        }

        public CustomSql build() {
            return new CustomSql(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomSql> {
        public Builder dataSourceArn(String var1);

        public Builder name(String var1);

        public Builder sqlQuery(String var1);

        public Builder columns(Collection<InputColumn> var1);

        public Builder columns(InputColumn ... var1);

        public Builder columns(Consumer<InputColumn.Builder> ... var1);
    }
}

