/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A calculated column for a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculatedColumn implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculatedColumn.Builder, CalculatedColumn> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CalculatedColumn::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CalculatedColumn::columnId)).setter(setter(Builder::columnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnId").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CalculatedColumn::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COLUMN_ID_FIELD, EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String columnId;

    private final String expression;

    private CalculatedColumn(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnId = builder.columnId;
        this.expression = builder.expression;
    }

    /**
     * <p>
     * Column name.
     * </p>
     * 
     * @return Column name.
     */
    public String columnName() {
        return columnName;
    }

    /**
     * <p>
     * A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column
     * matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
     * </p>
     * 
     * @return A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated
     *         column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated
     *         column.
     */
    public String columnId() {
        return columnId;
    }

    /**
     * <p>
     * An expression that defines the calculated column.
     * </p>
     * 
     * @return An expression that defines the calculated column.
     */
    public String expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(columnId());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedColumn)) {
            return false;
        }
        CalculatedColumn other = (CalculatedColumn) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(columnId(), other.columnId())
                && Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CalculatedColumn").add("ColumnName", columnName()).add("ColumnId", columnId())
                .add("Expression", expression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "ColumnId":
            return Optional.ofNullable(clazz.cast(columnId()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculatedColumn, T> g) {
        return obj -> g.apply((CalculatedColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculatedColumn> {
        /**
         * <p>
         * Column name.
         * </p>
         * 
         * @param columnName
         *        Column name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column
         * matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
         * </p>
         * 
         * @param columnId
         *        A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated
         *        column matches that of an existing calculated column, Amazon QuickSight preserves the existing
         *        calculated column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnId(String columnId);

        /**
         * <p>
         * An expression that defines the calculated column.
         * </p>
         * 
         * @param expression
         *        An expression that defines the calculated column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String columnId;

        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedColumn model) {
            columnName(model.columnName);
            columnId(model.columnId);
            expression(model.expression);
        }

        public final String getColumnName() {
            return columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final String getColumnId() {
            return columnId;
        }

        @Override
        public final Builder columnId(String columnId) {
            this.columnId = columnId;
            return this;
        }

        public final void setColumnId(String columnId) {
            this.columnId = columnId;
        }

        public final String getExpression() {
            return expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public CalculatedColumn build() {
            return new CalculatedColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
