/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSetPermissionsRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateDataSetPermissionsRequest.Builder, UpdateDataSetPermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSetPermissionsRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSetPermissionsRequest::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()).build();

    private static final SdkField<List<ResourcePermission>> GRANT_PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDataSetPermissionsRequest::grantPermissions))
            .setter(setter(Builder::grantPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourcePermission>> REVOKE_PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDataSetPermissionsRequest::revokePermissions))
            .setter(setter(Builder::revokePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DATA_SET_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));

    private final String awsAccountId;

    private final String dataSetId;

    private final List<ResourcePermission> grantPermissions;

    private final List<ResourcePermission> revokePermissions;

    private UpdateDataSetPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSetId = builder.dataSetId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the dataset whose permissions you want to update. This ID is unique per AWS Region for each AWS
     * account.
     * </p>
     * 
     * @return The ID for the dataset whose permissions you want to update. This ID is unique per AWS Region for each
     *         AWS account.
     */
    public String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The resource permissions that you want to grant to the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The resource permissions that you want to grant to the dataset.
     */
    public List<ResourcePermission> grantPermissions() {
        return grantPermissions;
    }

    /**
     * <p>
     * The resource permissions that you want to revoke from the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The resource permissions that you want to revoke from the dataset.
     */
    public List<ResourcePermission> revokePermissions() {
        return revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(grantPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(revokePermissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSetPermissionsRequest)) {
            return false;
        }
        UpdateDataSetPermissionsRequest other = (UpdateDataSetPermissionsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(grantPermissions(), other.grantPermissions())
                && Objects.equals(revokePermissions(), other.revokePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDataSetPermissionsRequest").add("AwsAccountId", awsAccountId())
                .add("DataSetId", dataSetId()).add("GrantPermissions", grantPermissions())
                .add("RevokePermissions", revokePermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "GrantPermissions":
            return Optional.ofNullable(clazz.cast(grantPermissions()));
        case "RevokePermissions":
            return Optional.ofNullable(clazz.cast(revokePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSetPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateDataSetPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataSetPermissionsRequest> {
        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the dataset whose permissions you want to update. This ID is unique per AWS Region for each AWS
         * account.
         * </p>
         * 
         * @param dataSetId
         *        The ID for the dataset whose permissions you want to update. This ID is unique per AWS Region for each
         *        AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The resource permissions that you want to grant to the dataset.
         * </p>
         * 
         * @param grantPermissions
         *        The resource permissions that you want to grant to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(Collection<ResourcePermission> grantPermissions);

        /**
         * <p>
         * The resource permissions that you want to grant to the dataset.
         * </p>
         * 
         * @param grantPermissions
         *        The resource permissions that you want to grant to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(ResourcePermission... grantPermissions);

        /**
         * <p>
         * The resource permissions that you want to grant to the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #grantPermissions(List<ResourcePermission>)}.
         * 
         * @param grantPermissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantPermissions(List<ResourcePermission>)
         */
        Builder grantPermissions(Consumer<ResourcePermission.Builder>... grantPermissions);

        /**
         * <p>
         * The resource permissions that you want to revoke from the dataset.
         * </p>
         * 
         * @param revokePermissions
         *        The resource permissions that you want to revoke from the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(Collection<ResourcePermission> revokePermissions);

        /**
         * <p>
         * The resource permissions that you want to revoke from the dataset.
         * </p>
         * 
         * @param revokePermissions
         *        The resource permissions that you want to revoke from the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(ResourcePermission... revokePermissions);

        /**
         * <p>
         * The resource permissions that you want to revoke from the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #revokePermissions(List<ResourcePermission>)}.
         * 
         * @param revokePermissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokePermissions(List<ResourcePermission>)
         */
        Builder revokePermissions(Consumer<ResourcePermission.Builder>... revokePermissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dataSetId;

        private List<ResourcePermission> grantPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<ResourcePermission> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSetPermissionsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dataSetId(model.dataSetId);
            grantPermissions(model.grantPermissions);
            revokePermissions(model.revokePermissions);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final Collection<ResourcePermission.Builder> getGrantPermissions() {
            return grantPermissions != null ? grantPermissions.stream().map(ResourcePermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder grantPermissions(Collection<ResourcePermission> grantPermissions) {
            this.grantPermissions = ResourcePermissionListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(ResourcePermission... grantPermissions) {
            grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<ResourcePermission.Builder>... grantPermissions) {
            grantPermissions(Stream.of(grantPermissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGrantPermissions(Collection<ResourcePermission.BuilderImpl> grantPermissions) {
            this.grantPermissions = ResourcePermissionListCopier.copyFromBuilder(grantPermissions);
        }

        public final Collection<ResourcePermission.Builder> getRevokePermissions() {
            return revokePermissions != null ? revokePermissions.stream().map(ResourcePermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revokePermissions(Collection<ResourcePermission> revokePermissions) {
            this.revokePermissions = ResourcePermissionListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(ResourcePermission... revokePermissions) {
            revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<ResourcePermission.Builder>... revokePermissions) {
            revokePermissions(Stream.of(revokePermissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRevokePermissions(Collection<ResourcePermission.BuilderImpl> revokePermissions) {
            this.revokePermissions = ResourcePermissionListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSetPermissionsRequest build() {
            return new UpdateDataSetPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
