/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * VPC connection properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConnectionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConnectionProperties.Builder, VpcConnectionProperties> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VpcConnectionProperties::vpcConnectionArn)).setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpcConnectionArn;

    private VpcConnectionProperties(BuilderImpl builder) {
        this.vpcConnectionArn = builder.vpcConnectionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the VPC connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the VPC connection.
     */
    public String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnectionProperties)) {
            return false;
        }
        VpcConnectionProperties other = (VpcConnectionProperties) obj;
        return Objects.equals(vpcConnectionArn(), other.vpcConnectionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VpcConnectionProperties").add("VpcConnectionArn", vpcConnectionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConnectionProperties, T> g) {
        return obj -> g.apply((VpcConnectionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConnectionProperties> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the VPC connection.
         * </p>
         * 
         * @param vpcConnectionArn
         *        The Amazon Resource Name (ARN) for the VPC connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);
    }

    static final class BuilderImpl implements Builder {
        private String vpcConnectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnectionProperties model) {
            vpcConnectionArn(model.vpcConnectionArn);
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public VpcConnectionProperties build() {
            return new VpcConnectionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
