/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplateAliasRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateTemplateAliasRequest.Builder, UpdateTemplateAliasRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTemplateAliasRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTemplateAliasRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()).build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTemplateAliasRequest::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AliasName").build()).build();

    private static final SdkField<Long> TEMPLATE_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateTemplateAliasRequest::templateVersionNumber)).setter(setter(Builder::templateVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TEMPLATE_ID_FIELD, ALIAS_NAME_FIELD, TEMPLATE_VERSION_NUMBER_FIELD));

    private final String awsAccountId;

    private final String templateId;

    private final String aliasName;

    private final Long templateVersionNumber;

    private UpdateTemplateAliasRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.aliasName = builder.aliasName;
        this.templateVersionNumber = builder.templateVersionNumber;
    }

    /**
     * <p>
     * The ID of the AWS account that contains the template alias that you're updating.
     * </p>
     * 
     * @return The ID of the AWS account that contains the template alias that you're updating.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the template.
     * </p>
     * 
     * @return The ID for the template.
     */
    public String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The alias of the template that you want to update. If you name a specific alias, you update the version that the
     * alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code>
     * in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.
     * </p>
     * 
     * @return The alias of the template that you want to update. If you name a specific alias, you update the version
     *         that the alias points to. You can specify the latest version of the template by providing the keyword
     *         <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't
     *         apply to templates.
     */
    public String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The version number of the template.
     * </p>
     * 
     * @return The version number of the template.
     */
    public Long templateVersionNumber() {
        return templateVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(templateVersionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateAliasRequest)) {
            return false;
        }
        UpdateTemplateAliasRequest other = (UpdateTemplateAliasRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(aliasName(), other.aliasName())
                && Objects.equals(templateVersionNumber(), other.templateVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTemplateAliasRequest").add("AwsAccountId", awsAccountId()).add("TemplateId", templateId())
                .add("AliasName", aliasName()).add("TemplateVersionNumber", templateVersionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "TemplateVersionNumber":
            return Optional.ofNullable(clazz.cast(templateVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateAliasRequest, T> g) {
        return obj -> g.apply((UpdateTemplateAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTemplateAliasRequest> {
        /**
         * <p>
         * The ID of the AWS account that contains the template alias that you're updating.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account that contains the template alias that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the template.
         * </p>
         * 
         * @param templateId
         *        The ID for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The alias of the template that you want to update. If you name a specific alias, you update the version that
         * the alias points to. You can specify the latest version of the template by providing the keyword
         * <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't
         * apply to templates.
         * </p>
         * 
         * @param aliasName
         *        The alias of the template that you want to update. If you name a specific alias, you update the
         *        version that the alias points to. You can specify the latest version of the template by providing the
         *        keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword
         *        <code>$PUBLISHED</code> doesn't apply to templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The version number of the template.
         * </p>
         * 
         * @param templateVersionNumber
         *        The version number of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersionNumber(Long templateVersionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String templateId;

        private String aliasName;

        private Long templateVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateAliasRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            templateId(model.templateId);
            aliasName(model.aliasName);
            templateVersionNumber(model.templateVersionNumber);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getTemplateId() {
            return templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final String getAliasName() {
            return aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final Long getTemplateVersionNumber() {
            return templateVersionNumber;
        }

        @Override
        public final Builder templateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
            return this;
        }

        public final void setTemplateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateAliasRequest build() {
            return new UpdateTemplateAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
