/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A registered user of Amazon QuickSight. Currently, an Amazon QuickSight subscription can't contain more than 20
 * million users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(User::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::identityTypeAsString)).setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(User::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, USER_NAME_FIELD,
            EMAIL_FIELD, ROLE_FIELD, IDENTITY_TYPE_FIELD, ACTIVE_FIELD, PRINCIPAL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String userName;

    private final String email;

    private final String role;

    private final String identityType;

    private final Boolean active;

    private final String principalId;

    private User(BuilderImpl builder) {
        this.arn = builder.arn;
        this.userName = builder.userName;
        this.email = builder.email;
        this.role = builder.role;
        this.identityType = builder.identityType;
        this.active = builder.active;
        this.principalId = builder.principalId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the user.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The user's user name.
     * </p>
     * 
     * @return The user's user name.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The user's email address.
     * </p>
     * 
     * @return The user's email address.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public UserRole role() {
        return UserRole.fromValue(role);
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The type of identity authentication used by the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The type of identity authentication used by the user.
     * @see IdentityType
     */
    public IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The type of identity authentication used by the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The type of identity authentication used by the user.
     * @see IdentityType
     */
    public String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active
     * Directory user, that user is inactive until they sign in and provide a password.
     * </p>
     * 
     * @return The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active
     *         Directory user, that user is inactive until they sign in and provide a password.
     */
    public Boolean active() {
        return active;
    }

    /**
     * <p>
     * The principal ID of the user.
     * </p>
     * 
     * @return The principal ID of the user.
     */
    public String principalId() {
        return principalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(userName(), other.userName())
                && Objects.equals(email(), other.email()) && Objects.equals(roleAsString(), other.roleAsString())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(active(), other.active()) && Objects.equals(principalId(), other.principalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("User").add("Arn", arn()).add("UserName", userName()).add("Email", email())
                .add("Role", roleAsString()).add("IdentityType", identityTypeAsString()).add("Active", active())
                .add("PrincipalId", principalId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the user.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The user's user name.
         * </p>
         * 
         * @param userName
         *        The user's user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The user's email address.
         * </p>
         * 
         * @param email
         *        The user's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param role
         *        The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(String role);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param role
         *        The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(UserRole role);

        /**
         * <p>
         * The type of identity authentication used by the user.
         * </p>
         * 
         * @param identityType
         *        The type of identity authentication used by the user.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The type of identity authentication used by the user.
         * </p>
         * 
         * @param identityType
         *        The type of identity authentication used by the user.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active
         * Directory user, that user is inactive until they sign in and provide a password.
         * </p>
         * 
         * @param active
         *        The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an
         *        Active Directory user, that user is inactive until they sign in and provide a password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * The principal ID of the user.
         * </p>
         * 
         * @param principalId
         *        The principal ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String userName;

        private String email;

        private String role;

        private String identityType;

        private Boolean active;

        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            arn(model.arn);
            userName(model.userName);
            email(model.email);
            role(model.role);
            identityType(model.identityType);
            active(model.active);
            principalId(model.principalId);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getRoleAsString() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getIdentityTypeAsString() {
            return identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final Boolean getActive() {
            return active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
