/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.ColumnGroup;
import software.amazon.awssdk.services.quicksight.model.ColumnGroupListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetImportMode;
import software.amazon.awssdk.services.quicksight.model.LogicalTable;
import software.amazon.awssdk.services.quicksight.model.LogicalTableMapCopier;
import software.amazon.awssdk.services.quicksight.model.PhysicalTable;
import software.amazon.awssdk.services.quicksight.model.PhysicalTableMapCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionDataSet;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataSetRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateDataSetRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::awsAccountId)).setter(UpdateDataSetRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::dataSetId)).setter(UpdateDataSetRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::name)).setter(UpdateDataSetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, PhysicalTable>> PHYSICAL_TABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::physicalTableMap)).setter(UpdateDataSetRequest.setter(Builder::physicalTableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhysicalTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, LogicalTable>> LOGICAL_TABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::logicalTableMap)).setter(UpdateDataSetRequest.setter(Builder::logicalTableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalTableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogicalTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::importModeAsString)).setter(UpdateDataSetRequest.setter(Builder::importMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()}).build();
    private static final SdkField<List<ColumnGroup>> COLUMN_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::columnGroups)).setter(UpdateDataSetRequest.setter(Builder::columnGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDataSetRequest.getter(UpdateDataSetRequest::rowLevelPermissionDataSet)).setter(UpdateDataSetRequest.setter(Builder::rowLevelPermissionDataSet)).constructor(RowLevelPermissionDataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DATA_SET_ID_FIELD, NAME_FIELD, PHYSICAL_TABLE_MAP_FIELD, LOGICAL_TABLE_MAP_FIELD, IMPORT_MODE_FIELD, COLUMN_GROUPS_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_FIELD));
    private final String awsAccountId;
    private final String dataSetId;
    private final String name;
    private final Map<String, PhysicalTable> physicalTableMap;
    private final Map<String, LogicalTable> logicalTableMap;
    private final String importMode;
    private final List<ColumnGroup> columnGroups;
    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;

    private UpdateDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.physicalTableMap = builder.physicalTableMap;
        this.logicalTableMap = builder.logicalTableMap;
        this.importMode = builder.importMode;
        this.columnGroups = builder.columnGroups;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String dataSetId() {
        return this.dataSetId;
    }

    public String name() {
        return this.name;
    }

    public boolean hasPhysicalTableMap() {
        return this.physicalTableMap != null && !(this.physicalTableMap instanceof SdkAutoConstructMap);
    }

    public Map<String, PhysicalTable> physicalTableMap() {
        return this.physicalTableMap;
    }

    public boolean hasLogicalTableMap() {
        return this.logicalTableMap != null && !(this.logicalTableMap instanceof SdkAutoConstructMap);
    }

    public Map<String, LogicalTable> logicalTableMap() {
        return this.logicalTableMap;
    }

    public DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(this.importMode);
    }

    public String importModeAsString() {
        return this.importMode;
    }

    public boolean hasColumnGroups() {
        return this.columnGroups != null && !(this.columnGroups instanceof SdkAutoConstructList);
    }

    public List<ColumnGroup> columnGroups() {
        return this.columnGroups;
    }

    public RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return this.rowLevelPermissionDataSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalTableMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalTableMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLevelPermissionDataSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSetRequest)) {
            return false;
        }
        UpdateDataSetRequest other = (UpdateDataSetRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.physicalTableMap(), other.physicalTableMap()) && Objects.equals(this.logicalTableMap(), other.logicalTableMap()) && Objects.equals(this.importModeAsString(), other.importModeAsString()) && Objects.equals(this.columnGroups(), other.columnGroups()) && Objects.equals(this.rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDataSetRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DataSetId", (Object)this.dataSetId()).add("Name", (Object)this.name()).add("PhysicalTableMap", this.physicalTableMap()).add("LogicalTableMap", this.logicalTableMap()).add("ImportMode", (Object)this.importModeAsString()).add("ColumnGroups", this.columnGroups()).add("RowLevelPermissionDataSet", (Object)this.rowLevelPermissionDataSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PhysicalTableMap": {
                return Optional.ofNullable(clazz.cast(this.physicalTableMap()));
            }
            case "LogicalTableMap": {
                return Optional.ofNullable(clazz.cast(this.logicalTableMap()));
            }
            case "ImportMode": {
                return Optional.ofNullable(clazz.cast(this.importModeAsString()));
            }
            case "ColumnGroups": {
                return Optional.ofNullable(clazz.cast(this.columnGroups()));
            }
            case "RowLevelPermissionDataSet": {
                return Optional.ofNullable(clazz.cast(this.rowLevelPermissionDataSet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSetRequest, T> g) {
        return obj -> g.apply((UpdateDataSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dataSetId;
        private String name;
        private Map<String, PhysicalTable> physicalTableMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, LogicalTable> logicalTableMap = DefaultSdkAutoConstructMap.getInstance();
        private String importMode;
        private List<ColumnGroup> columnGroups = DefaultSdkAutoConstructList.getInstance();
        private RowLevelPermissionDataSet rowLevelPermissionDataSet;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSetRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dataSetId(model.dataSetId);
            this.name(model.name);
            this.physicalTableMap(model.physicalTableMap);
            this.logicalTableMap(model.logicalTableMap);
            this.importMode(model.importMode);
            this.columnGroups(model.columnGroups);
            this.rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, PhysicalTable.Builder> getPhysicalTableMap() {
            return this.physicalTableMap != null ? CollectionUtils.mapValues(this.physicalTableMap, PhysicalTable::toBuilder) : null;
        }

        @Override
        public final Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copy(physicalTableMap);
            return this;
        }

        public final void setPhysicalTableMap(Map<String, PhysicalTable.BuilderImpl> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copyFromBuilder(physicalTableMap);
        }

        public final Map<String, LogicalTable.Builder> getLogicalTableMap() {
            return this.logicalTableMap != null ? CollectionUtils.mapValues(this.logicalTableMap, LogicalTable::toBuilder) : null;
        }

        @Override
        public final Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copy(logicalTableMap);
            return this;
        }

        public final void setLogicalTableMap(Map<String, LogicalTable.BuilderImpl> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copyFromBuilder(logicalTableMap);
        }

        public final String getImportModeAsString() {
            return this.importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        public final Collection<ColumnGroup.Builder> getColumnGroups() {
            return this.columnGroups != null ? (Collection)this.columnGroups.stream().map(ColumnGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnGroups(Collection<ColumnGroup> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copy(columnGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(ColumnGroup ... columnGroups) {
            this.columnGroups(Arrays.asList(columnGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(Consumer<ColumnGroup.Builder> ... columnGroups) {
            this.columnGroups(Stream.of(columnGroups).map(c -> (ColumnGroup)((ColumnGroup.Builder)ColumnGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnGroups(Collection<ColumnGroup.BuilderImpl> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copyFromBuilder(columnGroups);
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return this.rowLevelPermissionDataSet != null ? this.rowLevelPermissionDataSet.toBuilder() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSetRequest build() {
            return new UpdateDataSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataSetRequest> {
        public Builder awsAccountId(String var1);

        public Builder dataSetId(String var1);

        public Builder name(String var1);

        public Builder physicalTableMap(Map<String, PhysicalTable> var1);

        public Builder logicalTableMap(Map<String, LogicalTable> var1);

        public Builder importMode(String var1);

        public Builder importMode(DataSetImportMode var1);

        public Builder columnGroups(Collection<ColumnGroup> var1);

        public Builder columnGroups(ColumnGroup ... var1);

        public Builder columnGroups(Consumer<ColumnGroup.Builder> ... var1);

        public Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet var1);

        default public Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return this.rowLevelPermissionDataSet((RowLevelPermissionDataSet)((RowLevelPermissionDataSet.Builder)RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

