/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplateVersionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListTemplateVersionsResponse.Builder, ListTemplateVersionsResponse> {
    private static final SdkField<List<TemplateVersionSummary>> TEMPLATE_VERSION_SUMMARY_LIST_FIELD = SdkField
            .<List<TemplateVersionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListTemplateVersionsResponse::templateVersionSummaryList))
            .setter(setter(Builder::templateVersionSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersionSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTemplateVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListTemplateVersionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTemplateVersionsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TEMPLATE_VERSION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final List<TemplateVersionSummary> templateVersionSummaryList;

    private final String nextToken;

    private final Integer status;

    private final String requestId;

    private ListTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.templateVersionSummaryList = builder.templateVersionSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * Returns true if the TemplateVersionSummaryList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasTemplateVersionSummaryList() {
        return templateVersionSummaryList != null && !(templateVersionSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure containing a list of all the versions of the specified template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTemplateVersionSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure containing a list of all the versions of the specified template.
     */
    public List<TemplateVersionSummary> templateVersionSummaryList() {
        return templateVersionSummaryList;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateVersionSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateVersionsResponse)) {
            return false;
        }
        ListTemplateVersionsResponse other = (ListTemplateVersionsResponse) obj;
        return Objects.equals(templateVersionSummaryList(), other.templateVersionSummaryList())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTemplateVersionsResponse").add("TemplateVersionSummaryList", templateVersionSummaryList())
                .add("NextToken", nextToken()).add("Status", status()).add("RequestId", requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateVersionSummaryList":
            return Optional.ofNullable(clazz.cast(templateVersionSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateVersionsResponse, T> g) {
        return obj -> g.apply((ListTemplateVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTemplateVersionsResponse> {
        /**
         * <p>
         * A structure containing a list of all the versions of the specified template.
         * </p>
         * 
         * @param templateVersionSummaryList
         *        A structure containing a list of all the versions of the specified template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersionSummaryList(Collection<TemplateVersionSummary> templateVersionSummaryList);

        /**
         * <p>
         * A structure containing a list of all the versions of the specified template.
         * </p>
         * 
         * @param templateVersionSummaryList
         *        A structure containing a list of all the versions of the specified template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersionSummaryList(TemplateVersionSummary... templateVersionSummaryList);

        /**
         * <p>
         * A structure containing a list of all the versions of the specified template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TemplateVersionSummary>.Builder} avoiding
         * the need to create one manually via {@link List<TemplateVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #templateVersionSummaryList(List<TemplateVersionSummary>)}.
         * 
         * @param templateVersionSummaryList
         *        a consumer that will call methods on {@link List<TemplateVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateVersionSummaryList(List<TemplateVersionSummary>)
         */
        Builder templateVersionSummaryList(Consumer<TemplateVersionSummary.Builder>... templateVersionSummaryList);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<TemplateVersionSummary> templateVersionSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateVersionsResponse model) {
            super(model);
            templateVersionSummaryList(model.templateVersionSummaryList);
            nextToken(model.nextToken);
            status(model.status);
            requestId(model.requestId);
        }

        public final Collection<TemplateVersionSummary.Builder> getTemplateVersionSummaryList() {
            return templateVersionSummaryList != null ? templateVersionSummaryList.stream()
                    .map(TemplateVersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder templateVersionSummaryList(Collection<TemplateVersionSummary> templateVersionSummaryList) {
            this.templateVersionSummaryList = TemplateVersionSummaryListCopier.copy(templateVersionSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateVersionSummaryList(TemplateVersionSummary... templateVersionSummaryList) {
            templateVersionSummaryList(Arrays.asList(templateVersionSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateVersionSummaryList(Consumer<TemplateVersionSummary.Builder>... templateVersionSummaryList) {
            templateVersionSummaryList(Stream.of(templateVersionSummaryList)
                    .map(c -> TemplateVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTemplateVersionSummaryList(Collection<TemplateVersionSummary.BuilderImpl> templateVersionSummaryList) {
            this.templateVersionSummaryList = TemplateVersionSummaryListCopier.copyFromBuilder(templateVersionSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public ListTemplateVersionsResponse build() {
            return new ListTemplateVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
