/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * IAM policy assignment summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IAMPolicyAssignmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IAMPolicyAssignmentSummary.Builder, IAMPolicyAssignmentSummary> {
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IAMPolicyAssignmentSummary::assignmentName)).setter(setter(Builder::assignmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()).build();

    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IAMPolicyAssignmentSummary::assignmentStatusAsString)).setter(setter(Builder::assignmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_NAME_FIELD,
            ASSIGNMENT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assignmentName;

    private final String assignmentStatus;

    private IAMPolicyAssignmentSummary(BuilderImpl builder) {
        this.assignmentName = builder.assignmentName;
        this.assignmentStatus = builder.assignmentStatus;
    }

    /**
     * <p>
     * Assignment name.
     * </p>
     * 
     * @return Assignment name.
     */
    public String assignmentName() {
        return assignmentName;
    }

    /**
     * <p>
     * Assignment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return Assignment status.
     * @see AssignmentStatus
     */
    public AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(assignmentStatus);
    }

    /**
     * <p>
     * Assignment status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return Assignment status.
     * @see AssignmentStatus
     */
    public String assignmentStatusAsString() {
        return assignmentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAMPolicyAssignmentSummary)) {
            return false;
        }
        IAMPolicyAssignmentSummary other = (IAMPolicyAssignmentSummary) obj;
        return Objects.equals(assignmentName(), other.assignmentName())
                && Objects.equals(assignmentStatusAsString(), other.assignmentStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IAMPolicyAssignmentSummary").add("AssignmentName", assignmentName())
                .add("AssignmentStatus", assignmentStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignmentName":
            return Optional.ofNullable(clazz.cast(assignmentName()));
        case "AssignmentStatus":
            return Optional.ofNullable(clazz.cast(assignmentStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IAMPolicyAssignmentSummary, T> g) {
        return obj -> g.apply((IAMPolicyAssignmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IAMPolicyAssignmentSummary> {
        /**
         * <p>
         * Assignment name.
         * </p>
         * 
         * @param assignmentName
         *        Assignment name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentName(String assignmentName);

        /**
         * <p>
         * Assignment status.
         * </p>
         * 
         * @param assignmentStatus
         *        Assignment status.
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(String assignmentStatus);

        /**
         * <p>
         * Assignment status.
         * </p>
         * 
         * @param assignmentStatus
         *        Assignment status.
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(AssignmentStatus assignmentStatus);
    }

    static final class BuilderImpl implements Builder {
        private String assignmentName;

        private String assignmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(IAMPolicyAssignmentSummary model) {
            assignmentName(model.assignmentName);
            assignmentStatus(model.assignmentStatus);
        }

        public final String getAssignmentName() {
            return assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        public final String getAssignmentStatusAsString() {
            return assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public IAMPolicyAssignmentSummary build() {
            return new IAMPolicyAssignmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
