/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that Amazon QuickSight uses to connect to your underlying data source. This is a variant type
 * structure. For this structure to be valid, only one of the attributes can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceParameters.Builder, DataSourceParameters> {
    private static final SdkField<AmazonElasticsearchParameters> AMAZON_ELASTICSEARCH_PARAMETERS_FIELD = SdkField
            .<AmazonElasticsearchParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSourceParameters::amazonElasticsearchParameters))
            .setter(setter(Builder::amazonElasticsearchParameters))
            .constructor(AmazonElasticsearchParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonElasticsearchParameters")
                    .build()).build();

    private static final SdkField<AthenaParameters> ATHENA_PARAMETERS_FIELD = SdkField
            .<AthenaParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::athenaParameters))
            .setter(setter(Builder::athenaParameters)).constructor(AthenaParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaParameters").build()).build();

    private static final SdkField<AuroraParameters> AURORA_PARAMETERS_FIELD = SdkField
            .<AuroraParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::auroraParameters))
            .setter(setter(Builder::auroraParameters)).constructor(AuroraParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuroraParameters").build()).build();

    private static final SdkField<AuroraPostgreSqlParameters> AURORA_POSTGRE_SQL_PARAMETERS_FIELD = SdkField
            .<AuroraPostgreSqlParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSourceParameters::auroraPostgreSqlParameters))
            .setter(setter(Builder::auroraPostgreSqlParameters))
            .constructor(AuroraPostgreSqlParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuroraPostgreSqlParameters").build())
            .build();

    private static final SdkField<AwsIotAnalyticsParameters> AWS_IOT_ANALYTICS_PARAMETERS_FIELD = SdkField
            .<AwsIotAnalyticsParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSourceParameters::awsIotAnalyticsParameters)).setter(setter(Builder::awsIotAnalyticsParameters))
            .constructor(AwsIotAnalyticsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIotAnalyticsParameters").build())
            .build();

    private static final SdkField<JiraParameters> JIRA_PARAMETERS_FIELD = SdkField
            .<JiraParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::jiraParameters))
            .setter(setter(Builder::jiraParameters)).constructor(JiraParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraParameters").build()).build();

    private static final SdkField<MariaDbParameters> MARIA_DB_PARAMETERS_FIELD = SdkField
            .<MariaDbParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::mariaDbParameters))
            .setter(setter(Builder::mariaDbParameters)).constructor(MariaDbParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MariaDbParameters").build()).build();

    private static final SdkField<MySqlParameters> MY_SQL_PARAMETERS_FIELD = SdkField
            .<MySqlParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::mySqlParameters))
            .setter(setter(Builder::mySqlParameters)).constructor(MySqlParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySqlParameters").build()).build();

    private static final SdkField<PostgreSqlParameters> POSTGRE_SQL_PARAMETERS_FIELD = SdkField
            .<PostgreSqlParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::postgreSqlParameters))
            .setter(setter(Builder::postgreSqlParameters)).constructor(PostgreSqlParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSqlParameters").build())
            .build();

    private static final SdkField<PrestoParameters> PRESTO_PARAMETERS_FIELD = SdkField
            .<PrestoParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::prestoParameters))
            .setter(setter(Builder::prestoParameters)).constructor(PrestoParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrestoParameters").build()).build();

    private static final SdkField<RdsParameters> RDS_PARAMETERS_FIELD = SdkField
            .<RdsParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::rdsParameters))
            .setter(setter(Builder::rdsParameters)).constructor(RdsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsParameters").build()).build();

    private static final SdkField<RedshiftParameters> REDSHIFT_PARAMETERS_FIELD = SdkField
            .<RedshiftParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::redshiftParameters))
            .setter(setter(Builder::redshiftParameters)).constructor(RedshiftParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftParameters").build())
            .build();

    private static final SdkField<S3Parameters> S3_PARAMETERS_FIELD = SdkField.<S3Parameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSourceParameters::s3Parameters)).setter(setter(Builder::s3Parameters))
            .constructor(S3Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Parameters").build()).build();

    private static final SdkField<ServiceNowParameters> SERVICE_NOW_PARAMETERS_FIELD = SdkField
            .<ServiceNowParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::serviceNowParameters))
            .setter(setter(Builder::serviceNowParameters)).constructor(ServiceNowParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNowParameters").build())
            .build();

    private static final SdkField<SnowflakeParameters> SNOWFLAKE_PARAMETERS_FIELD = SdkField
            .<SnowflakeParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::snowflakeParameters))
            .setter(setter(Builder::snowflakeParameters)).constructor(SnowflakeParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeParameters").build())
            .build();

    private static final SdkField<SparkParameters> SPARK_PARAMETERS_FIELD = SdkField
            .<SparkParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::sparkParameters))
            .setter(setter(Builder::sparkParameters)).constructor(SparkParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkParameters").build()).build();

    private static final SdkField<SqlServerParameters> SQL_SERVER_PARAMETERS_FIELD = SdkField
            .<SqlServerParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::sqlServerParameters))
            .setter(setter(Builder::sqlServerParameters)).constructor(SqlServerParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlServerParameters").build())
            .build();

    private static final SdkField<TeradataParameters> TERADATA_PARAMETERS_FIELD = SdkField
            .<TeradataParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::teradataParameters))
            .setter(setter(Builder::teradataParameters)).constructor(TeradataParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeradataParameters").build())
            .build();

    private static final SdkField<TwitterParameters> TWITTER_PARAMETERS_FIELD = SdkField
            .<TwitterParameters> builder(MarshallingType.SDK_POJO).getter(getter(DataSourceParameters::twitterParameters))
            .setter(setter(Builder::twitterParameters)).constructor(TwitterParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwitterParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AMAZON_ELASTICSEARCH_PARAMETERS_FIELD, ATHENA_PARAMETERS_FIELD, AURORA_PARAMETERS_FIELD,
            AURORA_POSTGRE_SQL_PARAMETERS_FIELD, AWS_IOT_ANALYTICS_PARAMETERS_FIELD, JIRA_PARAMETERS_FIELD,
            MARIA_DB_PARAMETERS_FIELD, MY_SQL_PARAMETERS_FIELD, POSTGRE_SQL_PARAMETERS_FIELD, PRESTO_PARAMETERS_FIELD,
            RDS_PARAMETERS_FIELD, REDSHIFT_PARAMETERS_FIELD, S3_PARAMETERS_FIELD, SERVICE_NOW_PARAMETERS_FIELD,
            SNOWFLAKE_PARAMETERS_FIELD, SPARK_PARAMETERS_FIELD, SQL_SERVER_PARAMETERS_FIELD, TERADATA_PARAMETERS_FIELD,
            TWITTER_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmazonElasticsearchParameters amazonElasticsearchParameters;

    private final AthenaParameters athenaParameters;

    private final AuroraParameters auroraParameters;

    private final AuroraPostgreSqlParameters auroraPostgreSqlParameters;

    private final AwsIotAnalyticsParameters awsIotAnalyticsParameters;

    private final JiraParameters jiraParameters;

    private final MariaDbParameters mariaDbParameters;

    private final MySqlParameters mySqlParameters;

    private final PostgreSqlParameters postgreSqlParameters;

    private final PrestoParameters prestoParameters;

    private final RdsParameters rdsParameters;

    private final RedshiftParameters redshiftParameters;

    private final S3Parameters s3Parameters;

    private final ServiceNowParameters serviceNowParameters;

    private final SnowflakeParameters snowflakeParameters;

    private final SparkParameters sparkParameters;

    private final SqlServerParameters sqlServerParameters;

    private final TeradataParameters teradataParameters;

    private final TwitterParameters twitterParameters;

    private DataSourceParameters(BuilderImpl builder) {
        this.amazonElasticsearchParameters = builder.amazonElasticsearchParameters;
        this.athenaParameters = builder.athenaParameters;
        this.auroraParameters = builder.auroraParameters;
        this.auroraPostgreSqlParameters = builder.auroraPostgreSqlParameters;
        this.awsIotAnalyticsParameters = builder.awsIotAnalyticsParameters;
        this.jiraParameters = builder.jiraParameters;
        this.mariaDbParameters = builder.mariaDbParameters;
        this.mySqlParameters = builder.mySqlParameters;
        this.postgreSqlParameters = builder.postgreSqlParameters;
        this.prestoParameters = builder.prestoParameters;
        this.rdsParameters = builder.rdsParameters;
        this.redshiftParameters = builder.redshiftParameters;
        this.s3Parameters = builder.s3Parameters;
        this.serviceNowParameters = builder.serviceNowParameters;
        this.snowflakeParameters = builder.snowflakeParameters;
        this.sparkParameters = builder.sparkParameters;
        this.sqlServerParameters = builder.sqlServerParameters;
        this.teradataParameters = builder.teradataParameters;
        this.twitterParameters = builder.twitterParameters;
    }

    /**
     * <p>
     * Amazon Elasticsearch Service parameters.
     * </p>
     * 
     * @return Amazon Elasticsearch Service parameters.
     */
    public AmazonElasticsearchParameters amazonElasticsearchParameters() {
        return amazonElasticsearchParameters;
    }

    /**
     * <p>
     * Amazon Athena parameters.
     * </p>
     * 
     * @return Amazon Athena parameters.
     */
    public AthenaParameters athenaParameters() {
        return athenaParameters;
    }

    /**
     * <p>
     * Amazon Aurora MySQL parameters.
     * </p>
     * 
     * @return Amazon Aurora MySQL parameters.
     */
    public AuroraParameters auroraParameters() {
        return auroraParameters;
    }

    /**
     * <p>
     * Aurora PostgreSQL parameters.
     * </p>
     * 
     * @return Aurora PostgreSQL parameters.
     */
    public AuroraPostgreSqlParameters auroraPostgreSqlParameters() {
        return auroraPostgreSqlParameters;
    }

    /**
     * <p>
     * AWS IoT Analytics parameters.
     * </p>
     * 
     * @return AWS IoT Analytics parameters.
     */
    public AwsIotAnalyticsParameters awsIotAnalyticsParameters() {
        return awsIotAnalyticsParameters;
    }

    /**
     * <p>
     * Jira parameters.
     * </p>
     * 
     * @return Jira parameters.
     */
    public JiraParameters jiraParameters() {
        return jiraParameters;
    }

    /**
     * <p>
     * MariaDB parameters.
     * </p>
     * 
     * @return MariaDB parameters.
     */
    public MariaDbParameters mariaDbParameters() {
        return mariaDbParameters;
    }

    /**
     * <p>
     * MySQL parameters.
     * </p>
     * 
     * @return MySQL parameters.
     */
    public MySqlParameters mySqlParameters() {
        return mySqlParameters;
    }

    /**
     * <p>
     * PostgreSQL parameters.
     * </p>
     * 
     * @return PostgreSQL parameters.
     */
    public PostgreSqlParameters postgreSqlParameters() {
        return postgreSqlParameters;
    }

    /**
     * <p>
     * Presto parameters.
     * </p>
     * 
     * @return Presto parameters.
     */
    public PrestoParameters prestoParameters() {
        return prestoParameters;
    }

    /**
     * <p>
     * Amazon RDS parameters.
     * </p>
     * 
     * @return Amazon RDS parameters.
     */
    public RdsParameters rdsParameters() {
        return rdsParameters;
    }

    /**
     * <p>
     * Amazon Redshift parameters.
     * </p>
     * 
     * @return Amazon Redshift parameters.
     */
    public RedshiftParameters redshiftParameters() {
        return redshiftParameters;
    }

    /**
     * <p>
     * S3 parameters.
     * </p>
     * 
     * @return S3 parameters.
     */
    public S3Parameters s3Parameters() {
        return s3Parameters;
    }

    /**
     * <p>
     * ServiceNow parameters.
     * </p>
     * 
     * @return ServiceNow parameters.
     */
    public ServiceNowParameters serviceNowParameters() {
        return serviceNowParameters;
    }

    /**
     * <p>
     * Snowflake parameters.
     * </p>
     * 
     * @return Snowflake parameters.
     */
    public SnowflakeParameters snowflakeParameters() {
        return snowflakeParameters;
    }

    /**
     * <p>
     * Spark parameters.
     * </p>
     * 
     * @return Spark parameters.
     */
    public SparkParameters sparkParameters() {
        return sparkParameters;
    }

    /**
     * <p>
     * SQL Server parameters.
     * </p>
     * 
     * @return SQL Server parameters.
     */
    public SqlServerParameters sqlServerParameters() {
        return sqlServerParameters;
    }

    /**
     * <p>
     * Teradata parameters.
     * </p>
     * 
     * @return Teradata parameters.
     */
    public TeradataParameters teradataParameters() {
        return teradataParameters;
    }

    /**
     * <p>
     * Twitter parameters.
     * </p>
     * 
     * @return Twitter parameters.
     */
    public TwitterParameters twitterParameters() {
        return twitterParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonElasticsearchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(athenaParameters());
        hashCode = 31 * hashCode + Objects.hashCode(auroraParameters());
        hashCode = 31 * hashCode + Objects.hashCode(auroraPostgreSqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotAnalyticsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(jiraParameters());
        hashCode = 31 * hashCode + Objects.hashCode(mariaDbParameters());
        hashCode = 31 * hashCode + Objects.hashCode(mySqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(postgreSqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(prestoParameters());
        hashCode = 31 * hashCode + Objects.hashCode(rdsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftParameters());
        hashCode = 31 * hashCode + Objects.hashCode(s3Parameters());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNowParameters());
        hashCode = 31 * hashCode + Objects.hashCode(snowflakeParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sparkParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sqlServerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(teradataParameters());
        hashCode = 31 * hashCode + Objects.hashCode(twitterParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceParameters)) {
            return false;
        }
        DataSourceParameters other = (DataSourceParameters) obj;
        return Objects.equals(amazonElasticsearchParameters(), other.amazonElasticsearchParameters())
                && Objects.equals(athenaParameters(), other.athenaParameters())
                && Objects.equals(auroraParameters(), other.auroraParameters())
                && Objects.equals(auroraPostgreSqlParameters(), other.auroraPostgreSqlParameters())
                && Objects.equals(awsIotAnalyticsParameters(), other.awsIotAnalyticsParameters())
                && Objects.equals(jiraParameters(), other.jiraParameters())
                && Objects.equals(mariaDbParameters(), other.mariaDbParameters())
                && Objects.equals(mySqlParameters(), other.mySqlParameters())
                && Objects.equals(postgreSqlParameters(), other.postgreSqlParameters())
                && Objects.equals(prestoParameters(), other.prestoParameters())
                && Objects.equals(rdsParameters(), other.rdsParameters())
                && Objects.equals(redshiftParameters(), other.redshiftParameters())
                && Objects.equals(s3Parameters(), other.s3Parameters())
                && Objects.equals(serviceNowParameters(), other.serviceNowParameters())
                && Objects.equals(snowflakeParameters(), other.snowflakeParameters())
                && Objects.equals(sparkParameters(), other.sparkParameters())
                && Objects.equals(sqlServerParameters(), other.sqlServerParameters())
                && Objects.equals(teradataParameters(), other.teradataParameters())
                && Objects.equals(twitterParameters(), other.twitterParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSourceParameters").add("AmazonElasticsearchParameters", amazonElasticsearchParameters())
                .add("AthenaParameters", athenaParameters()).add("AuroraParameters", auroraParameters())
                .add("AuroraPostgreSqlParameters", auroraPostgreSqlParameters())
                .add("AwsIotAnalyticsParameters", awsIotAnalyticsParameters()).add("JiraParameters", jiraParameters())
                .add("MariaDbParameters", mariaDbParameters()).add("MySqlParameters", mySqlParameters())
                .add("PostgreSqlParameters", postgreSqlParameters()).add("PrestoParameters", prestoParameters())
                .add("RdsParameters", rdsParameters()).add("RedshiftParameters", redshiftParameters())
                .add("S3Parameters", s3Parameters()).add("ServiceNowParameters", serviceNowParameters())
                .add("SnowflakeParameters", snowflakeParameters()).add("SparkParameters", sparkParameters())
                .add("SqlServerParameters", sqlServerParameters()).add("TeradataParameters", teradataParameters())
                .add("TwitterParameters", twitterParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonElasticsearchParameters":
            return Optional.ofNullable(clazz.cast(amazonElasticsearchParameters()));
        case "AthenaParameters":
            return Optional.ofNullable(clazz.cast(athenaParameters()));
        case "AuroraParameters":
            return Optional.ofNullable(clazz.cast(auroraParameters()));
        case "AuroraPostgreSqlParameters":
            return Optional.ofNullable(clazz.cast(auroraPostgreSqlParameters()));
        case "AwsIotAnalyticsParameters":
            return Optional.ofNullable(clazz.cast(awsIotAnalyticsParameters()));
        case "JiraParameters":
            return Optional.ofNullable(clazz.cast(jiraParameters()));
        case "MariaDbParameters":
            return Optional.ofNullable(clazz.cast(mariaDbParameters()));
        case "MySqlParameters":
            return Optional.ofNullable(clazz.cast(mySqlParameters()));
        case "PostgreSqlParameters":
            return Optional.ofNullable(clazz.cast(postgreSqlParameters()));
        case "PrestoParameters":
            return Optional.ofNullable(clazz.cast(prestoParameters()));
        case "RdsParameters":
            return Optional.ofNullable(clazz.cast(rdsParameters()));
        case "RedshiftParameters":
            return Optional.ofNullable(clazz.cast(redshiftParameters()));
        case "S3Parameters":
            return Optional.ofNullable(clazz.cast(s3Parameters()));
        case "ServiceNowParameters":
            return Optional.ofNullable(clazz.cast(serviceNowParameters()));
        case "SnowflakeParameters":
            return Optional.ofNullable(clazz.cast(snowflakeParameters()));
        case "SparkParameters":
            return Optional.ofNullable(clazz.cast(sparkParameters()));
        case "SqlServerParameters":
            return Optional.ofNullable(clazz.cast(sqlServerParameters()));
        case "TeradataParameters":
            return Optional.ofNullable(clazz.cast(teradataParameters()));
        case "TwitterParameters":
            return Optional.ofNullable(clazz.cast(twitterParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceParameters, T> g) {
        return obj -> g.apply((DataSourceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceParameters> {
        /**
         * <p>
         * Amazon Elasticsearch Service parameters.
         * </p>
         * 
         * @param amazonElasticsearchParameters
         *        Amazon Elasticsearch Service parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonElasticsearchParameters(AmazonElasticsearchParameters amazonElasticsearchParameters);

        /**
         * <p>
         * Amazon Elasticsearch Service parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link AmazonElasticsearchParameters.Builder} avoiding
         * the need to create one manually via {@link AmazonElasticsearchParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AmazonElasticsearchParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #amazonElasticsearchParameters(AmazonElasticsearchParameters)}
         * .
         * 
         * @param amazonElasticsearchParameters
         *        a consumer that will call methods on {@link AmazonElasticsearchParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonElasticsearchParameters(AmazonElasticsearchParameters)
         */
        default Builder amazonElasticsearchParameters(
                Consumer<AmazonElasticsearchParameters.Builder> amazonElasticsearchParameters) {
            return amazonElasticsearchParameters(AmazonElasticsearchParameters.builder()
                    .applyMutation(amazonElasticsearchParameters).build());
        }

        /**
         * <p>
         * Amazon Athena parameters.
         * </p>
         * 
         * @param athenaParameters
         *        Amazon Athena parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaParameters(AthenaParameters athenaParameters);

        /**
         * <p>
         * Amazon Athena parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link AthenaParameters.Builder} avoiding the need to
         * create one manually via {@link AthenaParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AthenaParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #athenaParameters(AthenaParameters)}.
         * 
         * @param athenaParameters
         *        a consumer that will call methods on {@link AthenaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaParameters(AthenaParameters)
         */
        default Builder athenaParameters(Consumer<AthenaParameters.Builder> athenaParameters) {
            return athenaParameters(AthenaParameters.builder().applyMutation(athenaParameters).build());
        }

        /**
         * <p>
         * Amazon Aurora MySQL parameters.
         * </p>
         * 
         * @param auroraParameters
         *        Amazon Aurora MySQL parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auroraParameters(AuroraParameters auroraParameters);

        /**
         * <p>
         * Amazon Aurora MySQL parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link AuroraParameters.Builder} avoiding the need to
         * create one manually via {@link AuroraParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuroraParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #auroraParameters(AuroraParameters)}.
         * 
         * @param auroraParameters
         *        a consumer that will call methods on {@link AuroraParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auroraParameters(AuroraParameters)
         */
        default Builder auroraParameters(Consumer<AuroraParameters.Builder> auroraParameters) {
            return auroraParameters(AuroraParameters.builder().applyMutation(auroraParameters).build());
        }

        /**
         * <p>
         * Aurora PostgreSQL parameters.
         * </p>
         * 
         * @param auroraPostgreSqlParameters
         *        Aurora PostgreSQL parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auroraPostgreSqlParameters(AuroraPostgreSqlParameters auroraPostgreSqlParameters);

        /**
         * <p>
         * Aurora PostgreSQL parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link AuroraPostgreSqlParameters.Builder} avoiding the
         * need to create one manually via {@link AuroraPostgreSqlParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuroraPostgreSqlParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #auroraPostgreSqlParameters(AuroraPostgreSqlParameters)}.
         * 
         * @param auroraPostgreSqlParameters
         *        a consumer that will call methods on {@link AuroraPostgreSqlParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auroraPostgreSqlParameters(AuroraPostgreSqlParameters)
         */
        default Builder auroraPostgreSqlParameters(Consumer<AuroraPostgreSqlParameters.Builder> auroraPostgreSqlParameters) {
            return auroraPostgreSqlParameters(AuroraPostgreSqlParameters.builder().applyMutation(auroraPostgreSqlParameters)
                    .build());
        }

        /**
         * <p>
         * AWS IoT Analytics parameters.
         * </p>
         * 
         * @param awsIotAnalyticsParameters
         *        AWS IoT Analytics parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotAnalyticsParameters(AwsIotAnalyticsParameters awsIotAnalyticsParameters);

        /**
         * <p>
         * AWS IoT Analytics parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsIotAnalyticsParameters.Builder} avoiding the
         * need to create one manually via {@link AwsIotAnalyticsParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsIotAnalyticsParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #awsIotAnalyticsParameters(AwsIotAnalyticsParameters)}.
         * 
         * @param awsIotAnalyticsParameters
         *        a consumer that will call methods on {@link AwsIotAnalyticsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIotAnalyticsParameters(AwsIotAnalyticsParameters)
         */
        default Builder awsIotAnalyticsParameters(Consumer<AwsIotAnalyticsParameters.Builder> awsIotAnalyticsParameters) {
            return awsIotAnalyticsParameters(AwsIotAnalyticsParameters.builder().applyMutation(awsIotAnalyticsParameters).build());
        }

        /**
         * <p>
         * Jira parameters.
         * </p>
         * 
         * @param jiraParameters
         *        Jira parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraParameters(JiraParameters jiraParameters);

        /**
         * <p>
         * Jira parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link JiraParameters.Builder} avoiding the need to
         * create one manually via {@link JiraParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link JiraParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #jiraParameters(JiraParameters)}.
         * 
         * @param jiraParameters
         *        a consumer that will call methods on {@link JiraParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jiraParameters(JiraParameters)
         */
        default Builder jiraParameters(Consumer<JiraParameters.Builder> jiraParameters) {
            return jiraParameters(JiraParameters.builder().applyMutation(jiraParameters).build());
        }

        /**
         * <p>
         * MariaDB parameters.
         * </p>
         * 
         * @param mariaDbParameters
         *        MariaDB parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mariaDbParameters(MariaDbParameters mariaDbParameters);

        /**
         * <p>
         * MariaDB parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link MariaDbParameters.Builder} avoiding the need to
         * create one manually via {@link MariaDbParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MariaDbParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #mariaDbParameters(MariaDbParameters)}.
         * 
         * @param mariaDbParameters
         *        a consumer that will call methods on {@link MariaDbParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mariaDbParameters(MariaDbParameters)
         */
        default Builder mariaDbParameters(Consumer<MariaDbParameters.Builder> mariaDbParameters) {
            return mariaDbParameters(MariaDbParameters.builder().applyMutation(mariaDbParameters).build());
        }

        /**
         * <p>
         * MySQL parameters.
         * </p>
         * 
         * @param mySqlParameters
         *        MySQL parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mySqlParameters(MySqlParameters mySqlParameters);

        /**
         * <p>
         * MySQL parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link MySqlParameters.Builder} avoiding the need to
         * create one manually via {@link MySqlParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MySqlParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #mySqlParameters(MySqlParameters)}.
         * 
         * @param mySqlParameters
         *        a consumer that will call methods on {@link MySqlParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mySqlParameters(MySqlParameters)
         */
        default Builder mySqlParameters(Consumer<MySqlParameters.Builder> mySqlParameters) {
            return mySqlParameters(MySqlParameters.builder().applyMutation(mySqlParameters).build());
        }

        /**
         * <p>
         * PostgreSQL parameters.
         * </p>
         * 
         * @param postgreSqlParameters
         *        PostgreSQL parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postgreSqlParameters(PostgreSqlParameters postgreSqlParameters);

        /**
         * <p>
         * PostgreSQL parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link PostgreSqlParameters.Builder} avoiding the need
         * to create one manually via {@link PostgreSqlParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link PostgreSqlParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #postgreSqlParameters(PostgreSqlParameters)}.
         * 
         * @param postgreSqlParameters
         *        a consumer that will call methods on {@link PostgreSqlParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postgreSqlParameters(PostgreSqlParameters)
         */
        default Builder postgreSqlParameters(Consumer<PostgreSqlParameters.Builder> postgreSqlParameters) {
            return postgreSqlParameters(PostgreSqlParameters.builder().applyMutation(postgreSqlParameters).build());
        }

        /**
         * <p>
         * Presto parameters.
         * </p>
         * 
         * @param prestoParameters
         *        Presto parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prestoParameters(PrestoParameters prestoParameters);

        /**
         * <p>
         * Presto parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link PrestoParameters.Builder} avoiding the need to
         * create one manually via {@link PrestoParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link PrestoParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #prestoParameters(PrestoParameters)}.
         * 
         * @param prestoParameters
         *        a consumer that will call methods on {@link PrestoParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prestoParameters(PrestoParameters)
         */
        default Builder prestoParameters(Consumer<PrestoParameters.Builder> prestoParameters) {
            return prestoParameters(PrestoParameters.builder().applyMutation(prestoParameters).build());
        }

        /**
         * <p>
         * Amazon RDS parameters.
         * </p>
         * 
         * @param rdsParameters
         *        Amazon RDS parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsParameters(RdsParameters rdsParameters);

        /**
         * <p>
         * Amazon RDS parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link RdsParameters.Builder} avoiding the need to
         * create one manually via {@link RdsParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link RdsParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #rdsParameters(RdsParameters)}.
         * 
         * @param rdsParameters
         *        a consumer that will call methods on {@link RdsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsParameters(RdsParameters)
         */
        default Builder rdsParameters(Consumer<RdsParameters.Builder> rdsParameters) {
            return rdsParameters(RdsParameters.builder().applyMutation(rdsParameters).build());
        }

        /**
         * <p>
         * Amazon Redshift parameters.
         * </p>
         * 
         * @param redshiftParameters
         *        Amazon Redshift parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftParameters(RedshiftParameters redshiftParameters);

        /**
         * <p>
         * Amazon Redshift parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link RedshiftParameters.Builder} avoiding the need to
         * create one manually via {@link RedshiftParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftParameters(RedshiftParameters)}.
         * 
         * @param redshiftParameters
         *        a consumer that will call methods on {@link RedshiftParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftParameters(RedshiftParameters)
         */
        default Builder redshiftParameters(Consumer<RedshiftParameters.Builder> redshiftParameters) {
            return redshiftParameters(RedshiftParameters.builder().applyMutation(redshiftParameters).build());
        }

        /**
         * <p>
         * S3 parameters.
         * </p>
         * 
         * @param s3Parameters
         *        S3 parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Parameters(S3Parameters s3Parameters);

        /**
         * <p>
         * S3 parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Parameters.Builder} avoiding the need to
         * create one manually via {@link S3Parameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Parameters.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Parameters(S3Parameters)}.
         * 
         * @param s3Parameters
         *        a consumer that will call methods on {@link S3Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Parameters(S3Parameters)
         */
        default Builder s3Parameters(Consumer<S3Parameters.Builder> s3Parameters) {
            return s3Parameters(S3Parameters.builder().applyMutation(s3Parameters).build());
        }

        /**
         * <p>
         * ServiceNow parameters.
         * </p>
         * 
         * @param serviceNowParameters
         *        ServiceNow parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNowParameters(ServiceNowParameters serviceNowParameters);

        /**
         * <p>
         * ServiceNow parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceNowParameters.Builder} avoiding the need
         * to create one manually via {@link ServiceNowParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceNowParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceNowParameters(ServiceNowParameters)}.
         * 
         * @param serviceNowParameters
         *        a consumer that will call methods on {@link ServiceNowParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNowParameters(ServiceNowParameters)
         */
        default Builder serviceNowParameters(Consumer<ServiceNowParameters.Builder> serviceNowParameters) {
            return serviceNowParameters(ServiceNowParameters.builder().applyMutation(serviceNowParameters).build());
        }

        /**
         * <p>
         * Snowflake parameters.
         * </p>
         * 
         * @param snowflakeParameters
         *        Snowflake parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflakeParameters(SnowflakeParameters snowflakeParameters);

        /**
         * <p>
         * Snowflake parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link SnowflakeParameters.Builder} avoiding the need
         * to create one manually via {@link SnowflakeParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnowflakeParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #snowflakeParameters(SnowflakeParameters)}.
         * 
         * @param snowflakeParameters
         *        a consumer that will call methods on {@link SnowflakeParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflakeParameters(SnowflakeParameters)
         */
        default Builder snowflakeParameters(Consumer<SnowflakeParameters.Builder> snowflakeParameters) {
            return snowflakeParameters(SnowflakeParameters.builder().applyMutation(snowflakeParameters).build());
        }

        /**
         * <p>
         * Spark parameters.
         * </p>
         * 
         * @param sparkParameters
         *        Spark parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkParameters(SparkParameters sparkParameters);

        /**
         * <p>
         * Spark parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link SparkParameters.Builder} avoiding the need to
         * create one manually via {@link SparkParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link SparkParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #sparkParameters(SparkParameters)}.
         * 
         * @param sparkParameters
         *        a consumer that will call methods on {@link SparkParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkParameters(SparkParameters)
         */
        default Builder sparkParameters(Consumer<SparkParameters.Builder> sparkParameters) {
            return sparkParameters(SparkParameters.builder().applyMutation(sparkParameters).build());
        }

        /**
         * <p>
         * SQL Server parameters.
         * </p>
         * 
         * @param sqlServerParameters
         *        SQL Server parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlServerParameters(SqlServerParameters sqlServerParameters);

        /**
         * <p>
         * SQL Server parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link SqlServerParameters.Builder} avoiding the need
         * to create one manually via {@link SqlServerParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqlServerParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #sqlServerParameters(SqlServerParameters)}.
         * 
         * @param sqlServerParameters
         *        a consumer that will call methods on {@link SqlServerParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlServerParameters(SqlServerParameters)
         */
        default Builder sqlServerParameters(Consumer<SqlServerParameters.Builder> sqlServerParameters) {
            return sqlServerParameters(SqlServerParameters.builder().applyMutation(sqlServerParameters).build());
        }

        /**
         * <p>
         * Teradata parameters.
         * </p>
         * 
         * @param teradataParameters
         *        Teradata parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teradataParameters(TeradataParameters teradataParameters);

        /**
         * <p>
         * Teradata parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link TeradataParameters.Builder} avoiding the need to
         * create one manually via {@link TeradataParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link TeradataParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #teradataParameters(TeradataParameters)}.
         * 
         * @param teradataParameters
         *        a consumer that will call methods on {@link TeradataParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teradataParameters(TeradataParameters)
         */
        default Builder teradataParameters(Consumer<TeradataParameters.Builder> teradataParameters) {
            return teradataParameters(TeradataParameters.builder().applyMutation(teradataParameters).build());
        }

        /**
         * <p>
         * Twitter parameters.
         * </p>
         * 
         * @param twitterParameters
         *        Twitter parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twitterParameters(TwitterParameters twitterParameters);

        /**
         * <p>
         * Twitter parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link TwitterParameters.Builder} avoiding the need to
         * create one manually via {@link TwitterParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link TwitterParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #twitterParameters(TwitterParameters)}.
         * 
         * @param twitterParameters
         *        a consumer that will call methods on {@link TwitterParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #twitterParameters(TwitterParameters)
         */
        default Builder twitterParameters(Consumer<TwitterParameters.Builder> twitterParameters) {
            return twitterParameters(TwitterParameters.builder().applyMutation(twitterParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmazonElasticsearchParameters amazonElasticsearchParameters;

        private AthenaParameters athenaParameters;

        private AuroraParameters auroraParameters;

        private AuroraPostgreSqlParameters auroraPostgreSqlParameters;

        private AwsIotAnalyticsParameters awsIotAnalyticsParameters;

        private JiraParameters jiraParameters;

        private MariaDbParameters mariaDbParameters;

        private MySqlParameters mySqlParameters;

        private PostgreSqlParameters postgreSqlParameters;

        private PrestoParameters prestoParameters;

        private RdsParameters rdsParameters;

        private RedshiftParameters redshiftParameters;

        private S3Parameters s3Parameters;

        private ServiceNowParameters serviceNowParameters;

        private SnowflakeParameters snowflakeParameters;

        private SparkParameters sparkParameters;

        private SqlServerParameters sqlServerParameters;

        private TeradataParameters teradataParameters;

        private TwitterParameters twitterParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceParameters model) {
            amazonElasticsearchParameters(model.amazonElasticsearchParameters);
            athenaParameters(model.athenaParameters);
            auroraParameters(model.auroraParameters);
            auroraPostgreSqlParameters(model.auroraPostgreSqlParameters);
            awsIotAnalyticsParameters(model.awsIotAnalyticsParameters);
            jiraParameters(model.jiraParameters);
            mariaDbParameters(model.mariaDbParameters);
            mySqlParameters(model.mySqlParameters);
            postgreSqlParameters(model.postgreSqlParameters);
            prestoParameters(model.prestoParameters);
            rdsParameters(model.rdsParameters);
            redshiftParameters(model.redshiftParameters);
            s3Parameters(model.s3Parameters);
            serviceNowParameters(model.serviceNowParameters);
            snowflakeParameters(model.snowflakeParameters);
            sparkParameters(model.sparkParameters);
            sqlServerParameters(model.sqlServerParameters);
            teradataParameters(model.teradataParameters);
            twitterParameters(model.twitterParameters);
        }

        public final AmazonElasticsearchParameters.Builder getAmazonElasticsearchParameters() {
            return amazonElasticsearchParameters != null ? amazonElasticsearchParameters.toBuilder() : null;
        }

        @Override
        public final Builder amazonElasticsearchParameters(AmazonElasticsearchParameters amazonElasticsearchParameters) {
            this.amazonElasticsearchParameters = amazonElasticsearchParameters;
            return this;
        }

        public final void setAmazonElasticsearchParameters(AmazonElasticsearchParameters.BuilderImpl amazonElasticsearchParameters) {
            this.amazonElasticsearchParameters = amazonElasticsearchParameters != null ? amazonElasticsearchParameters.build()
                    : null;
        }

        public final AthenaParameters.Builder getAthenaParameters() {
            return athenaParameters != null ? athenaParameters.toBuilder() : null;
        }

        @Override
        public final Builder athenaParameters(AthenaParameters athenaParameters) {
            this.athenaParameters = athenaParameters;
            return this;
        }

        public final void setAthenaParameters(AthenaParameters.BuilderImpl athenaParameters) {
            this.athenaParameters = athenaParameters != null ? athenaParameters.build() : null;
        }

        public final AuroraParameters.Builder getAuroraParameters() {
            return auroraParameters != null ? auroraParameters.toBuilder() : null;
        }

        @Override
        public final Builder auroraParameters(AuroraParameters auroraParameters) {
            this.auroraParameters = auroraParameters;
            return this;
        }

        public final void setAuroraParameters(AuroraParameters.BuilderImpl auroraParameters) {
            this.auroraParameters = auroraParameters != null ? auroraParameters.build() : null;
        }

        public final AuroraPostgreSqlParameters.Builder getAuroraPostgreSqlParameters() {
            return auroraPostgreSqlParameters != null ? auroraPostgreSqlParameters.toBuilder() : null;
        }

        @Override
        public final Builder auroraPostgreSqlParameters(AuroraPostgreSqlParameters auroraPostgreSqlParameters) {
            this.auroraPostgreSqlParameters = auroraPostgreSqlParameters;
            return this;
        }

        public final void setAuroraPostgreSqlParameters(AuroraPostgreSqlParameters.BuilderImpl auroraPostgreSqlParameters) {
            this.auroraPostgreSqlParameters = auroraPostgreSqlParameters != null ? auroraPostgreSqlParameters.build() : null;
        }

        public final AwsIotAnalyticsParameters.Builder getAwsIotAnalyticsParameters() {
            return awsIotAnalyticsParameters != null ? awsIotAnalyticsParameters.toBuilder() : null;
        }

        @Override
        public final Builder awsIotAnalyticsParameters(AwsIotAnalyticsParameters awsIotAnalyticsParameters) {
            this.awsIotAnalyticsParameters = awsIotAnalyticsParameters;
            return this;
        }

        public final void setAwsIotAnalyticsParameters(AwsIotAnalyticsParameters.BuilderImpl awsIotAnalyticsParameters) {
            this.awsIotAnalyticsParameters = awsIotAnalyticsParameters != null ? awsIotAnalyticsParameters.build() : null;
        }

        public final JiraParameters.Builder getJiraParameters() {
            return jiraParameters != null ? jiraParameters.toBuilder() : null;
        }

        @Override
        public final Builder jiraParameters(JiraParameters jiraParameters) {
            this.jiraParameters = jiraParameters;
            return this;
        }

        public final void setJiraParameters(JiraParameters.BuilderImpl jiraParameters) {
            this.jiraParameters = jiraParameters != null ? jiraParameters.build() : null;
        }

        public final MariaDbParameters.Builder getMariaDbParameters() {
            return mariaDbParameters != null ? mariaDbParameters.toBuilder() : null;
        }

        @Override
        public final Builder mariaDbParameters(MariaDbParameters mariaDbParameters) {
            this.mariaDbParameters = mariaDbParameters;
            return this;
        }

        public final void setMariaDbParameters(MariaDbParameters.BuilderImpl mariaDbParameters) {
            this.mariaDbParameters = mariaDbParameters != null ? mariaDbParameters.build() : null;
        }

        public final MySqlParameters.Builder getMySqlParameters() {
            return mySqlParameters != null ? mySqlParameters.toBuilder() : null;
        }

        @Override
        public final Builder mySqlParameters(MySqlParameters mySqlParameters) {
            this.mySqlParameters = mySqlParameters;
            return this;
        }

        public final void setMySqlParameters(MySqlParameters.BuilderImpl mySqlParameters) {
            this.mySqlParameters = mySqlParameters != null ? mySqlParameters.build() : null;
        }

        public final PostgreSqlParameters.Builder getPostgreSqlParameters() {
            return postgreSqlParameters != null ? postgreSqlParameters.toBuilder() : null;
        }

        @Override
        public final Builder postgreSqlParameters(PostgreSqlParameters postgreSqlParameters) {
            this.postgreSqlParameters = postgreSqlParameters;
            return this;
        }

        public final void setPostgreSqlParameters(PostgreSqlParameters.BuilderImpl postgreSqlParameters) {
            this.postgreSqlParameters = postgreSqlParameters != null ? postgreSqlParameters.build() : null;
        }

        public final PrestoParameters.Builder getPrestoParameters() {
            return prestoParameters != null ? prestoParameters.toBuilder() : null;
        }

        @Override
        public final Builder prestoParameters(PrestoParameters prestoParameters) {
            this.prestoParameters = prestoParameters;
            return this;
        }

        public final void setPrestoParameters(PrestoParameters.BuilderImpl prestoParameters) {
            this.prestoParameters = prestoParameters != null ? prestoParameters.build() : null;
        }

        public final RdsParameters.Builder getRdsParameters() {
            return rdsParameters != null ? rdsParameters.toBuilder() : null;
        }

        @Override
        public final Builder rdsParameters(RdsParameters rdsParameters) {
            this.rdsParameters = rdsParameters;
            return this;
        }

        public final void setRdsParameters(RdsParameters.BuilderImpl rdsParameters) {
            this.rdsParameters = rdsParameters != null ? rdsParameters.build() : null;
        }

        public final RedshiftParameters.Builder getRedshiftParameters() {
            return redshiftParameters != null ? redshiftParameters.toBuilder() : null;
        }

        @Override
        public final Builder redshiftParameters(RedshiftParameters redshiftParameters) {
            this.redshiftParameters = redshiftParameters;
            return this;
        }

        public final void setRedshiftParameters(RedshiftParameters.BuilderImpl redshiftParameters) {
            this.redshiftParameters = redshiftParameters != null ? redshiftParameters.build() : null;
        }

        public final S3Parameters.Builder getS3Parameters() {
            return s3Parameters != null ? s3Parameters.toBuilder() : null;
        }

        @Override
        public final Builder s3Parameters(S3Parameters s3Parameters) {
            this.s3Parameters = s3Parameters;
            return this;
        }

        public final void setS3Parameters(S3Parameters.BuilderImpl s3Parameters) {
            this.s3Parameters = s3Parameters != null ? s3Parameters.build() : null;
        }

        public final ServiceNowParameters.Builder getServiceNowParameters() {
            return serviceNowParameters != null ? serviceNowParameters.toBuilder() : null;
        }

        @Override
        public final Builder serviceNowParameters(ServiceNowParameters serviceNowParameters) {
            this.serviceNowParameters = serviceNowParameters;
            return this;
        }

        public final void setServiceNowParameters(ServiceNowParameters.BuilderImpl serviceNowParameters) {
            this.serviceNowParameters = serviceNowParameters != null ? serviceNowParameters.build() : null;
        }

        public final SnowflakeParameters.Builder getSnowflakeParameters() {
            return snowflakeParameters != null ? snowflakeParameters.toBuilder() : null;
        }

        @Override
        public final Builder snowflakeParameters(SnowflakeParameters snowflakeParameters) {
            this.snowflakeParameters = snowflakeParameters;
            return this;
        }

        public final void setSnowflakeParameters(SnowflakeParameters.BuilderImpl snowflakeParameters) {
            this.snowflakeParameters = snowflakeParameters != null ? snowflakeParameters.build() : null;
        }

        public final SparkParameters.Builder getSparkParameters() {
            return sparkParameters != null ? sparkParameters.toBuilder() : null;
        }

        @Override
        public final Builder sparkParameters(SparkParameters sparkParameters) {
            this.sparkParameters = sparkParameters;
            return this;
        }

        public final void setSparkParameters(SparkParameters.BuilderImpl sparkParameters) {
            this.sparkParameters = sparkParameters != null ? sparkParameters.build() : null;
        }

        public final SqlServerParameters.Builder getSqlServerParameters() {
            return sqlServerParameters != null ? sqlServerParameters.toBuilder() : null;
        }

        @Override
        public final Builder sqlServerParameters(SqlServerParameters sqlServerParameters) {
            this.sqlServerParameters = sqlServerParameters;
            return this;
        }

        public final void setSqlServerParameters(SqlServerParameters.BuilderImpl sqlServerParameters) {
            this.sqlServerParameters = sqlServerParameters != null ? sqlServerParameters.build() : null;
        }

        public final TeradataParameters.Builder getTeradataParameters() {
            return teradataParameters != null ? teradataParameters.toBuilder() : null;
        }

        @Override
        public final Builder teradataParameters(TeradataParameters teradataParameters) {
            this.teradataParameters = teradataParameters;
            return this;
        }

        public final void setTeradataParameters(TeradataParameters.BuilderImpl teradataParameters) {
            this.teradataParameters = teradataParameters != null ? teradataParameters.build() : null;
        }

        public final TwitterParameters.Builder getTwitterParameters() {
            return twitterParameters != null ? twitterParameters.toBuilder() : null;
        }

        @Override
        public final Builder twitterParameters(TwitterParameters twitterParameters) {
            this.twitterParameters = twitterParameters;
            return this;
        }

        public final void setTwitterParameters(TwitterParameters.BuilderImpl twitterParameters) {
            this.twitterParameters = twitterParameters != null ? twitterParameters.build() : null;
        }

        @Override
        public DataSourceParameters build() {
            return new DataSourceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
