/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSetSummary;
import software.amazon.awssdk.services.quicksight.model.DataSetSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSetsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListDataSetsResponse> {
    private static final SdkField<List<DataSetSummary>> DATA_SET_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDataSetsResponse.getter(ListDataSetsResponse::dataSetSummaries)).setter(ListDataSetsResponse.setter(Builder::dataSetSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDataSetsResponse.getter(ListDataSetsResponse::nextToken)).setter(ListDataSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDataSetsResponse.getter(ListDataSetsResponse::requestId)).setter(ListDataSetsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListDataSetsResponse.getter(ListDataSetsResponse::status)).setter(ListDataSetsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final List<DataSetSummary> dataSetSummaries;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private ListDataSetsResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetSummaries = builder.dataSetSummaries;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public boolean hasDataSetSummaries() {
        return this.dataSetSummaries != null && !(this.dataSetSummaries instanceof SdkAutoConstructList);
    }

    public List<DataSetSummary> dataSetSummaries() {
        return this.dataSetSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetsResponse)) {
            return false;
        }
        ListDataSetsResponse other = (ListDataSetsResponse)((Object)obj);
        return Objects.equals(this.dataSetSummaries(), other.dataSetSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ListDataSetsResponse").add("DataSetSummaries", this.dataSetSummaries()).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetSummaries": {
                return Optional.ofNullable(clazz.cast(this.dataSetSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetsResponse, T> g) {
        return obj -> g.apply((ListDataSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<DataSetSummary> dataSetSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetsResponse model) {
            super(model);
            this.dataSetSummaries(model.dataSetSummaries);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final Collection<DataSetSummary.Builder> getDataSetSummaries() {
            return this.dataSetSummaries != null ? (Collection)this.dataSetSummaries.stream().map(DataSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSetSummaries(Collection<DataSetSummary> dataSetSummaries) {
            this.dataSetSummaries = DataSetSummaryListCopier.copy(dataSetSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetSummaries(DataSetSummary ... dataSetSummaries) {
            this.dataSetSummaries(Arrays.asList(dataSetSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetSummaries(Consumer<DataSetSummary.Builder> ... dataSetSummaries) {
            this.dataSetSummaries(Stream.of(dataSetSummaries).map(c -> (DataSetSummary)((DataSetSummary.Builder)DataSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSetSummaries(Collection<DataSetSummary.BuilderImpl> dataSetSummaries) {
            this.dataSetSummaries = DataSetSummaryListCopier.copyFromBuilder(dataSetSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListDataSetsResponse build() {
            return new ListDataSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSetsResponse> {
        public Builder dataSetSummaries(Collection<DataSetSummary> var1);

        public Builder dataSetSummaries(DataSetSummary ... var1);

        public Builder dataSetSummaries(Consumer<DataSetSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

