/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDashboardRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateDashboardRequest.Builder, UpdateDashboardRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDashboardRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDashboardRequest::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDashboardRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DashboardSourceEntity> SOURCE_ENTITY_FIELD = SdkField
            .<DashboardSourceEntity> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDashboardRequest::sourceEntity))
            .setter(setter(Builder::sourceEntity)).constructor(DashboardSourceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()).build();

    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.<Parameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDashboardRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDashboardRequest::versionDescription)).setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<DashboardPublishOptions> DASHBOARD_PUBLISH_OPTIONS_FIELD = SdkField
            .<DashboardPublishOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDashboardRequest::dashboardPublishOptions)).setter(setter(Builder::dashboardPublishOptions))
            .constructor(DashboardPublishOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardPublishOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, NAME_FIELD, SOURCE_ENTITY_FIELD, PARAMETERS_FIELD, VERSION_DESCRIPTION_FIELD,
            DASHBOARD_PUBLISH_OPTIONS_FIELD));

    private final String awsAccountId;

    private final String dashboardId;

    private final String name;

    private final DashboardSourceEntity sourceEntity;

    private final Parameters parameters;

    private final String versionDescription;

    private final DashboardPublishOptions dashboardPublishOptions;

    private UpdateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.name = builder.name;
        this.sourceEntity = builder.sourceEntity;
        this.parameters = builder.parameters;
        this.versionDescription = builder.versionDescription;
        this.dashboardPublishOptions = builder.dashboardPublishOptions;
    }

    /**
     * <p>
     * The ID of the AWS account that contains the dashboard that you're updating.
     * </p>
     * 
     * @return The ID of the AWS account that contains the dashboard that you're updating.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the dashboard.
     * </p>
     * 
     * @return The ID for the dashboard.
     */
    public String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The display name of the dashboard.
     * </p>
     * 
     * @return The display name of the dashboard.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you
     * specify the type of object you're using as source. You can only update a dashboard from a template, so you use a
     * <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the
     * analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>, specify
     * the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS
     * Account and any QuickSight-supported AWS Region.
     * </p>
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets
     * for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     * </p>
     * 
     * @return The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>,
     *         you specify the type of object you're using as source. You can only update a dashboard from a template,
     *         so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis,
     *         first convert the analysis to a template by using the <a>CreateTemplate</a> API operation. For
     *         <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The
     *         <code>SourceTemplate</code> ARN can contain any AWS Account and any QuickSight-supported AWS Region. </p>
     *         <p>
     *         Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement
     *         datasets for the placeholders listed in the original. The schema in each dataset must match its
     *         placeholder.
     */
    public DashboardSourceEntity sourceEntity() {
        return sourceEntity;
    }

    /**
     * <p>
     * A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A
     * dashboard can have any type of parameters, and some parameters might accept multiple values.
     * </p>
     * 
     * @return A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard.
     *         A dashboard can have any type of parameters, and some parameters might accept multiple values.
     */
    public Parameters parameters() {
        return parameters;
    }

    /**
     * <p>
     * A description for the first version of the dashboard being created.
     * </p>
     * 
     * @return A description for the first version of the dashboard being created.
     */
    public String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * Options for publishing the dashboard when you create it:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables the
     * left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is
     * <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .csv format isn't enabled when
     * this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
     * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Options for publishing the dashboard when you create it:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight
     *         disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time)
     *         filtering. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .csv format isn't
     *         enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
     *         <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
     *         </p>
     *         </li>
     */
    public DashboardPublishOptions dashboardPublishOptions() {
        return dashboardPublishOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardPublishOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardRequest)) {
            return false;
        }
        UpdateDashboardRequest other = (UpdateDashboardRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(name(), other.name()) && Objects.equals(sourceEntity(), other.sourceEntity())
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(dashboardPublishOptions(), other.dashboardPublishOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDashboardRequest").add("AwsAccountId", awsAccountId()).add("DashboardId", dashboardId())
                .add("Name", name()).add("SourceEntity", sourceEntity()).add("Parameters", parameters())
                .add("VersionDescription", versionDescription()).add("DashboardPublishOptions", dashboardPublishOptions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SourceEntity":
            return Optional.ofNullable(clazz.cast(sourceEntity()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "DashboardPublishOptions":
            return Optional.ofNullable(clazz.cast(dashboardPublishOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardRequest, T> g) {
        return obj -> g.apply((UpdateDashboardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDashboardRequest> {
        /**
         * <p>
         * The ID of the AWS account that contains the dashboard that you're updating.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account that contains the dashboard that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The ID for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The display name of the dashboard.
         * </p>
         * 
         * @param name
         *        The display name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source. You can only update a dashboard from a template, so you
         * use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert
         * the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>,
         * specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can
         * contain any AWS Account and any QuickSight-supported AWS Region.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement
         * datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * </p>
         * 
         * @param sourceEntity
         *        The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>,
         *        you specify the type of object you're using as source. You can only update a dashboard from a
         *        template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an
         *        analysis, first convert the analysis to a template by using the <a>CreateTemplate</a> API operation.
         *        For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The
         *        <code>SourceTemplate</code> ARN can contain any AWS Account and any QuickSight-supported AWS Region.
         *        </p>
         *        <p>
         *        Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the
         *        replacement datasets for the placeholders listed in the original. The schema in each dataset must
         *        match its placeholder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntity(DashboardSourceEntity sourceEntity);

        /**
         * <p>
         * The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source. You can only update a dashboard from a template, so you
         * use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert
         * the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>,
         * specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can
         * contain any AWS Account and any QuickSight-supported AWS Region.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement
         * datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * </p>
         * This is a convenience that creates an instance of the {@link DashboardSourceEntity.Builder} avoiding the need
         * to create one manually via {@link DashboardSourceEntity#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashboardSourceEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceEntity(DashboardSourceEntity)}.
         * 
         * @param sourceEntity
         *        a consumer that will call methods on {@link DashboardSourceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEntity(DashboardSourceEntity)
         */
        default Builder sourceEntity(Consumer<DashboardSourceEntity.Builder> sourceEntity) {
            return sourceEntity(DashboardSourceEntity.builder().applyMutation(sourceEntity).build());
        }

        /**
         * <p>
         * A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A
         * dashboard can have any type of parameters, and some parameters might accept multiple values.
         * </p>
         * 
         * @param parameters
         *        A structure that contains the parameters of the dashboard. These are parameter overrides for a
         *        dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple
         *        values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameters parameters);

        /**
         * <p>
         * A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A
         * dashboard can have any type of parameters, and some parameters might accept multiple values.
         * </p>
         * This is a convenience that creates an instance of the {@link Parameters.Builder} avoiding the need to create
         * one manually via {@link Parameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Parameters.Builder#build()} is called immediately and its result
         * is passed to {@link #parameters(Parameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(Parameters)
         */
        default Builder parameters(Consumer<Parameters.Builder> parameters) {
            return parameters(Parameters.builder().applyMutation(parameters).build());
        }

        /**
         * <p>
         * A description for the first version of the dashboard being created.
         * </p>
         * 
         * @param versionDescription
         *        A description for the first version of the dashboard being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * Options for publishing the dashboard when you create it:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables
         * the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This
         * option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .csv format isn't enabled
         * when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
         * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dashboardPublishOptions
         *        Options for publishing the dashboard when you create it:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight
         *        disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time)
         *        filtering. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .csv format isn't
         *        enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be
         *        either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by
         *        default.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions);

        /**
         * <p>
         * Options for publishing the dashboard when you create it:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables
         * the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This
         * option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .csv format isn't enabled
         * when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
         * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link DashboardPublishOptions.Builder} avoiding the
         * need to create one manually via {@link DashboardPublishOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashboardPublishOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #dashboardPublishOptions(DashboardPublishOptions)}.
         * 
         * @param dashboardPublishOptions
         *        a consumer that will call methods on {@link DashboardPublishOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardPublishOptions(DashboardPublishOptions)
         */
        default Builder dashboardPublishOptions(Consumer<DashboardPublishOptions.Builder> dashboardPublishOptions) {
            return dashboardPublishOptions(DashboardPublishOptions.builder().applyMutation(dashboardPublishOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String name;

        private DashboardSourceEntity sourceEntity;

        private Parameters parameters;

        private String versionDescription;

        private DashboardPublishOptions dashboardPublishOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            name(model.name);
            sourceEntity(model.sourceEntity);
            parameters(model.parameters);
            versionDescription(model.versionDescription);
            dashboardPublishOptions(model.dashboardPublishOptions);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final DashboardSourceEntity.Builder getSourceEntity() {
            return sourceEntity != null ? sourceEntity.toBuilder() : null;
        }

        @Override
        public final Builder sourceEntity(DashboardSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final void setSourceEntity(DashboardSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        public final Parameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        public final DashboardPublishOptions.Builder getDashboardPublishOptions() {
            return dashboardPublishOptions != null ? dashboardPublishOptions.toBuilder() : null;
        }

        @Override
        public final Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions;
            return this;
        }

        public final void setDashboardPublishOptions(DashboardPublishOptions.BuilderImpl dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions != null ? dashboardPublishOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardRequest build() {
            return new UpdateDashboardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
