/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Redshift parameters. The <code>ClusterId</code> field can be blank if <code>Host</code> and <code>Port</code>
 * are both set. The <code>Host</code> and <code>Port</code> fields can be blank if the <code>ClusterId</code> field is
 * set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftParameters.Builder, RedshiftParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftParameters::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RedshiftParameters::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftParameters::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RedshiftParameters::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD,
            DATABASE_FIELD, CLUSTER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String host;

    private final Integer port;

    private final String database;

    private final String clusterId;

    private RedshiftParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.database = builder.database;
        this.clusterId = builder.clusterId;
    }

    /**
     * <p>
     * Host. This field can be blank if <code>ClusterId</code> is provided.
     * </p>
     * 
     * @return Host. This field can be blank if <code>ClusterId</code> is provided.
     */
    public String host() {
        return host;
    }

    /**
     * <p>
     * Port. This field can be blank if the <code>ClusterId</code> is provided.
     * </p>
     * 
     * @return Port. This field can be blank if the <code>ClusterId</code> is provided.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * Database.
     * </p>
     * 
     * @return Database.
     */
    public String database() {
        return database;
    }

    /**
     * <p>
     * Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are provided.
     * </p>
     * 
     * @return Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are provided.
     */
    public String clusterId() {
        return clusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftParameters)) {
            return false;
        }
        RedshiftParameters other = (RedshiftParameters) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(port(), other.port())
                && Objects.equals(database(), other.database()) && Objects.equals(clusterId(), other.clusterId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RedshiftParameters").add("Host", host()).add("Port", port()).add("Database", database())
                .add("ClusterId", clusterId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftParameters, T> g) {
        return obj -> g.apply((RedshiftParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftParameters> {
        /**
         * <p>
         * Host. This field can be blank if <code>ClusterId</code> is provided.
         * </p>
         * 
         * @param host
         *        Host. This field can be blank if <code>ClusterId</code> is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * Port. This field can be blank if the <code>ClusterId</code> is provided.
         * </p>
         * 
         * @param port
         *        Port. This field can be blank if the <code>ClusterId</code> is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Database.
         * </p>
         * 
         * @param database
         *        Database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are provided.
         * </p>
         * 
         * @param clusterId
         *        Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private Integer port;

        private String database;

        private String clusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftParameters model) {
            host(model.host);
            port(model.port);
            database(model.database);
            clusterId(model.clusterId);
        }

        public final String getHost() {
            return host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabase() {
            return database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public RedshiftParameters build() {
            return new RedshiftParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
