/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTemplateResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeTemplateResponse.Builder, DescribeTemplateResponse> {
    private static final SdkField<Template> TEMPLATE_FIELD = SdkField.<Template> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeTemplateResponse::template)).setter(setter(Builder::template)).constructor(Template::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Template").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeTemplateResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTemplateResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_FIELD, STATUS_FIELD,
            REQUEST_ID_FIELD));

    private final Template template;

    private final Integer status;

    private final String requestId;

    private DescribeTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.template = builder.template;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The template structure for the object you want to describe.
     * </p>
     * 
     * @return The template structure for the object you want to describe.
     */
    public Template template() {
        return template;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    /**
     * Returns the value of the RequestId property for this object.
     * 
     * @return The value of the RequestId property for this object.
     */
    public String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTemplateResponse)) {
            return false;
        }
        DescribeTemplateResponse other = (DescribeTemplateResponse) obj;
        return Objects.equals(template(), other.template()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTemplateResponse").add("Template", template()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Template":
            return Optional.ofNullable(clazz.cast(template()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTemplateResponse, T> g) {
        return obj -> g.apply((DescribeTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTemplateResponse> {
        /**
         * <p>
         * The template structure for the object you want to describe.
         * </p>
         * 
         * @param template
         *        The template structure for the object you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Template template);

        /**
         * <p>
         * The template structure for the object you want to describe.
         * </p>
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #template(Template)}.
         * 
         * @param template
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #template(Template)
         */
        default Builder template(Consumer<Template.Builder> template) {
            return template(Template.builder().applyMutation(template).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * Sets the value of the RequestId property for this object.
         *
         * @param requestId
         *        The new value for the RequestId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Template template;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTemplateResponse model) {
            super(model);
            template(model.template);
            status(model.status);
            requestId(model.requestId);
        }

        public final Template.Builder getTemplate() {
            return template != null ? template.toBuilder() : null;
        }

        @Override
        public final Builder template(Template template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(Template.BuilderImpl template) {
            this.template = template != null ? template.build() : null;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public DescribeTemplateResponse build() {
            return new DescribeTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
