/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options for the layout of tiles on a sheet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TileLayoutStyle implements SdkPojo, Serializable, ToCopyableBuilder<TileLayoutStyle.Builder, TileLayoutStyle> {
    private static final SdkField<GutterStyle> GUTTER_FIELD = SdkField.<GutterStyle> builder(MarshallingType.SDK_POJO)
            .getter(getter(TileLayoutStyle::gutter)).setter(setter(Builder::gutter)).constructor(GutterStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gutter").build()).build();

    private static final SdkField<MarginStyle> MARGIN_FIELD = SdkField.<MarginStyle> builder(MarshallingType.SDK_POJO)
            .getter(getter(TileLayoutStyle::margin)).setter(setter(Builder::margin)).constructor(MarginStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Margin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUTTER_FIELD, MARGIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final GutterStyle gutter;

    private final MarginStyle margin;

    private TileLayoutStyle(BuilderImpl builder) {
        this.gutter = builder.gutter;
        this.margin = builder.margin;
    }

    /**
     * <p>
     * The gutter settings that apply between tiles.
     * </p>
     * 
     * @return The gutter settings that apply between tiles.
     */
    public GutterStyle gutter() {
        return gutter;
    }

    /**
     * <p>
     * The margin settings that apply around the outside edge of sheets.
     * </p>
     * 
     * @return The margin settings that apply around the outside edge of sheets.
     */
    public MarginStyle margin() {
        return margin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gutter());
        hashCode = 31 * hashCode + Objects.hashCode(margin());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TileLayoutStyle)) {
            return false;
        }
        TileLayoutStyle other = (TileLayoutStyle) obj;
        return Objects.equals(gutter(), other.gutter()) && Objects.equals(margin(), other.margin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TileLayoutStyle").add("Gutter", gutter()).add("Margin", margin()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gutter":
            return Optional.ofNullable(clazz.cast(gutter()));
        case "Margin":
            return Optional.ofNullable(clazz.cast(margin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TileLayoutStyle, T> g) {
        return obj -> g.apply((TileLayoutStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TileLayoutStyle> {
        /**
         * <p>
         * The gutter settings that apply between tiles.
         * </p>
         * 
         * @param gutter
         *        The gutter settings that apply between tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gutter(GutterStyle gutter);

        /**
         * <p>
         * The gutter settings that apply between tiles.
         * </p>
         * This is a convenience that creates an instance of the {@link GutterStyle.Builder} avoiding the need to create
         * one manually via {@link GutterStyle#builder()}.
         *
         * When the {@link Consumer} completes, {@link GutterStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #gutter(GutterStyle)}.
         * 
         * @param gutter
         *        a consumer that will call methods on {@link GutterStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gutter(GutterStyle)
         */
        default Builder gutter(Consumer<GutterStyle.Builder> gutter) {
            return gutter(GutterStyle.builder().applyMutation(gutter).build());
        }

        /**
         * <p>
         * The margin settings that apply around the outside edge of sheets.
         * </p>
         * 
         * @param margin
         *        The margin settings that apply around the outside edge of sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder margin(MarginStyle margin);

        /**
         * <p>
         * The margin settings that apply around the outside edge of sheets.
         * </p>
         * This is a convenience that creates an instance of the {@link MarginStyle.Builder} avoiding the need to create
         * one manually via {@link MarginStyle#builder()}.
         *
         * When the {@link Consumer} completes, {@link MarginStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #margin(MarginStyle)}.
         * 
         * @param margin
         *        a consumer that will call methods on {@link MarginStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #margin(MarginStyle)
         */
        default Builder margin(Consumer<MarginStyle.Builder> margin) {
            return margin(MarginStyle.builder().applyMutation(margin).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GutterStyle gutter;

        private MarginStyle margin;

        private BuilderImpl() {
        }

        private BuilderImpl(TileLayoutStyle model) {
            gutter(model.gutter);
            margin(model.margin);
        }

        public final GutterStyle.Builder getGutter() {
            return gutter != null ? gutter.toBuilder() : null;
        }

        @Override
        public final Builder gutter(GutterStyle gutter) {
            this.gutter = gutter;
            return this;
        }

        public final void setGutter(GutterStyle.BuilderImpl gutter) {
            this.gutter = gutter != null ? gutter.build() : null;
        }

        public final MarginStyle.Builder getMargin() {
            return margin != null ? margin.toBuilder() : null;
        }

        @Override
        public final Builder margin(MarginStyle margin) {
            this.margin = margin;
            return this;
        }

        public final void setMargin(MarginStyle.BuilderImpl margin) {
            this.margin = margin != null ? margin.build() : null;
        }

        @Override
        public TileLayoutStyle build() {
            return new TileLayoutStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
