/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A version of a template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateVersion implements SdkPojo, Serializable, ToCopyableBuilder<TemplateVersion.Builder, TemplateVersion> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TemplateVersion::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<List<TemplateError>> ERRORS_FIELD = SdkField
            .<List<TemplateError>> builder(MarshallingType.LIST)
            .getter(getter(TemplateVersion::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateError> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TemplateVersion::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateVersion::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<DataSetConfiguration>> DATA_SET_CONFIGURATIONS_FIELD = SdkField
            .<List<DataSetConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(TemplateVersion::dataSetConfigurations))
            .setter(setter(Builder::dataSetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateVersion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SOURCE_ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateVersion::sourceEntityArn)).setter(setter(Builder::sourceEntityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntityArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            ERRORS_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD, DATA_SET_CONFIGURATIONS_FIELD, DESCRIPTION_FIELD,
            SOURCE_ENTITY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdTime;

    private final List<TemplateError> errors;

    private final Long versionNumber;

    private final String status;

    private final List<DataSetConfiguration> dataSetConfigurations;

    private final String description;

    private final String sourceEntityArn;

    private TemplateVersion(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.errors = builder.errors;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.dataSetConfigurations = builder.dataSetConfigurations;
        this.description = builder.description;
        this.sourceEntityArn = builder.sourceEntityArn;
    }

    /**
     * <p>
     * The time that this template version was created.
     * </p>
     * 
     * @return The time that this template version was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors associated with the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Errors associated with the template.
     */
    public List<TemplateError> errors() {
        return errors;
    }

    /**
     * <p>
     * The version number of the template.
     * </p>
     * 
     * @return The version number of the template.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The HTTP status of the request.
     * @see ResourceStatus
     */
    public ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The HTTP status of the request.
     * @see ResourceStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns true if the DataSetConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDataSetConfigurations() {
        return dataSetConfigurations != null && !(dataSetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the template
     * should be bound to new datasets matching the same schema described through this API. .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataSetConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the
     *         template should be bound to new datasets matching the same schema described through this API. .
     */
    public List<DataSetConfiguration> dataSetConfigurations() {
        return dataSetConfigurations;
    }

    /**
     * <p>
     * The description of the template.
     * </p>
     * 
     * @return The description of the template.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the analysis or template which was used to create this template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the analysis or template which was used to create this template.
     */
    public String sourceEntityArn() {
        return sourceEntityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(errors());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntityArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateVersion)) {
            return false;
        }
        TemplateVersion other = (TemplateVersion) obj;
        return Objects.equals(createdTime(), other.createdTime()) && Objects.equals(errors(), other.errors())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(dataSetConfigurations(), other.dataSetConfigurations())
                && Objects.equals(description(), other.description())
                && Objects.equals(sourceEntityArn(), other.sourceEntityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TemplateVersion").add("CreatedTime", createdTime()).add("Errors", errors())
                .add("VersionNumber", versionNumber()).add("Status", statusAsString())
                .add("DataSetConfigurations", dataSetConfigurations()).add("Description", description())
                .add("SourceEntityArn", sourceEntityArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DataSetConfigurations":
            return Optional.ofNullable(clazz.cast(dataSetConfigurations()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SourceEntityArn":
            return Optional.ofNullable(clazz.cast(sourceEntityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateVersion, T> g) {
        return obj -> g.apply((TemplateVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateVersion> {
        /**
         * <p>
         * The time that this template version was created.
         * </p>
         * 
         * @param createdTime
         *        The time that this template version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Errors associated with the template.
         * </p>
         * 
         * @param errors
         *        Errors associated with the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<TemplateError> errors);

        /**
         * <p>
         * Errors associated with the template.
         * </p>
         * 
         * @param errors
         *        Errors associated with the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(TemplateError... errors);

        /**
         * <p>
         * Errors associated with the template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TemplateError>.Builder} avoiding the need
         * to create one manually via {@link List<TemplateError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateError>.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<TemplateError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<TemplateError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<TemplateError>)
         */
        Builder errors(Consumer<TemplateError.Builder>... errors);

        /**
         * <p>
         * The version number of the template.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the template
         * should be bound to new datasets matching the same schema described through this API. .
         * </p>
         * 
         * @param dataSetConfigurations
         *        Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the
         *        template should be bound to new datasets matching the same schema described through this API. .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetConfigurations(Collection<DataSetConfiguration> dataSetConfigurations);

        /**
         * <p>
         * Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the template
         * should be bound to new datasets matching the same schema described through this API. .
         * </p>
         * 
         * @param dataSetConfigurations
         *        Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the
         *        template should be bound to new datasets matching the same schema described through this API. .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetConfigurations(DataSetConfiguration... dataSetConfigurations);

        /**
         * <p>
         * Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the template
         * should be bound to new datasets matching the same schema described through this API. .
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSetConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<DataSetConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSetConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSetConfigurations(List<DataSetConfiguration>)}.
         * 
         * @param dataSetConfigurations
         *        a consumer that will call methods on {@link List<DataSetConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetConfigurations(List<DataSetConfiguration>)
         */
        Builder dataSetConfigurations(Consumer<DataSetConfiguration.Builder>... dataSetConfigurations);

        /**
         * <p>
         * The description of the template.
         * </p>
         * 
         * @param description
         *        The description of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the analysis or template which was used to create this template.
         * </p>
         * 
         * @param sourceEntityArn
         *        The Amazon Resource Name (ARN) of the analysis or template which was used to create this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntityArn(String sourceEntityArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdTime;

        private List<TemplateError> errors = DefaultSdkAutoConstructList.getInstance();

        private Long versionNumber;

        private String status;

        private List<DataSetConfiguration> dataSetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String sourceEntityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateVersion model) {
            createdTime(model.createdTime);
            errors(model.errors);
            versionNumber(model.versionNumber);
            status(model.status);
            dataSetConfigurations(model.dataSetConfigurations);
            description(model.description);
            sourceEntityArn(model.sourceEntityArn);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<TemplateError.Builder> getErrors() {
            return errors != null ? errors.stream().map(TemplateError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<TemplateError> errors) {
            this.errors = TemplateErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(TemplateError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<TemplateError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> TemplateError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<TemplateError.BuilderImpl> errors) {
            this.errors = TemplateErrorListCopier.copyFromBuilder(errors);
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<DataSetConfiguration.Builder> getDataSetConfigurations() {
            return dataSetConfigurations != null ? dataSetConfigurations.stream().map(DataSetConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSetConfigurations(Collection<DataSetConfiguration> dataSetConfigurations) {
            this.dataSetConfigurations = DataSetConfigurationListCopier.copy(dataSetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetConfigurations(DataSetConfiguration... dataSetConfigurations) {
            dataSetConfigurations(Arrays.asList(dataSetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetConfigurations(Consumer<DataSetConfiguration.Builder>... dataSetConfigurations) {
            dataSetConfigurations(Stream.of(dataSetConfigurations)
                    .map(c -> DataSetConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSetConfigurations(Collection<DataSetConfiguration.BuilderImpl> dataSetConfigurations) {
            this.dataSetConfigurations = DataSetConfigurationListCopier.copyFromBuilder(dataSetConfigurations);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSourceEntityArn() {
            return sourceEntityArn;
        }

        @Override
        public final Builder sourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
            return this;
        }

        public final void setSourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
        }

        @Override
        public TemplateVersion build() {
            return new TemplateVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
