/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IdentityType;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.UserRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterUserRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, RegisterUserRequest> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::identityTypeAsString)).setter(RegisterUserRequest.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::email)).setter(RegisterUserRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> USER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::userRoleAsString)).setter(RegisterUserRequest.setter(Builder::userRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()}).build();
    private static final SdkField<String> IAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::iamArn)).setter(RegisterUserRequest.setter(Builder::iamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamArn").build()}).build();
    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::sessionName)).setter(RegisterUserRequest.setter(Builder::sessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionName").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::awsAccountId)).setter(RegisterUserRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::namespace)).setter(RegisterUserRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterUserRequest.getter(RegisterUserRequest::userName)).setter(RegisterUserRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD, EMAIL_FIELD, USER_ROLE_FIELD, IAM_ARN_FIELD, SESSION_NAME_FIELD, AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, USER_NAME_FIELD));
    private final String identityType;
    private final String email;
    private final String userRole;
    private final String iamArn;
    private final String sessionName;
    private final String awsAccountId;
    private final String namespace;
    private final String userName;

    private RegisterUserRequest(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.email = builder.email;
        this.userRole = builder.userRole;
        this.iamArn = builder.iamArn;
        this.sessionName = builder.sessionName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.userName = builder.userName;
    }

    public IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public String identityTypeAsString() {
        return this.identityType;
    }

    public String email() {
        return this.email;
    }

    public UserRole userRole() {
        return UserRole.fromValue(this.userRole);
    }

    public String userRoleAsString() {
        return this.userRole;
    }

    public String iamArn() {
        return this.iamArn;
    }

    public String sessionName() {
        return this.sessionName;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String namespace() {
        return this.namespace;
    }

    public String userName() {
        return this.userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUserRequest)) {
            return false;
        }
        RegisterUserRequest other = (RegisterUserRequest)((Object)obj);
        return Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.userRoleAsString(), other.userRoleAsString()) && Objects.equals(this.iamArn(), other.iamArn()) && Objects.equals(this.sessionName(), other.sessionName()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.userName(), other.userName());
    }

    public String toString() {
        return ToString.builder((String)"RegisterUserRequest").add("IdentityType", (Object)this.identityTypeAsString()).add("Email", (Object)this.email()).add("UserRole", (Object)this.userRoleAsString()).add("IamArn", (Object)this.iamArn()).add("SessionName", (Object)this.sessionName()).add("AwsAccountId", (Object)this.awsAccountId()).add("Namespace", (Object)this.namespace()).add("UserName", (Object)this.userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "UserRole": {
                return Optional.ofNullable(clazz.cast(this.userRoleAsString()));
            }
            case "IamArn": {
                return Optional.ofNullable(clazz.cast(this.iamArn()));
            }
            case "SessionName": {
                return Optional.ofNullable(clazz.cast(this.sessionName()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterUserRequest, T> g) {
        return obj -> g.apply((RegisterUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String identityType;
        private String email;
        private String userRole;
        private String iamArn;
        private String sessionName;
        private String awsAccountId;
        private String namespace;
        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUserRequest model) {
            super(model);
            this.identityType(model.identityType);
            this.email(model.email);
            this.userRole(model.userRole);
            this.iamArn(model.iamArn);
            this.sessionName(model.sessionName);
            this.awsAccountId(model.awsAccountId);
            this.namespace(model.namespace);
            this.userName(model.userName);
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getUserRole() {
            return this.userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        @Override
        public final Builder userRole(UserRole userRole) {
            this.userRole(userRole == null ? null : userRole.toString());
            return this;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        public final String getIamArn() {
            return this.iamArn;
        }

        @Override
        public final Builder iamArn(String iamArn) {
            this.iamArn = iamArn;
            return this;
        }

        public final void setIamArn(String iamArn) {
            this.iamArn = iamArn;
        }

        public final String getSessionName() {
            return this.sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterUserRequest build() {
            return new RegisterUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterUserRequest> {
        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder email(String var1);

        public Builder userRole(String var1);

        public Builder userRole(UserRole var1);

        public Builder iamArn(String var1);

        public Builder sessionName(String var1);

        public Builder awsAccountId(String var1);

        public Builder namespace(String var1);

        public Builder userName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

