/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The customizations associated with your AWS account for QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountCustomization implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountCustomization.Builder, AccountCustomization> {
    private static final SdkField<String> DEFAULT_THEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccountCustomization::defaultTheme)).setter(setter(Builder::defaultTheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTheme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_THEME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultTheme;

    private AccountCustomization(BuilderImpl builder) {
        this.defaultTheme = builder.defaultTheme;
    }

    /**
     * <p>
     * The default theme for this QuickSight subscription.
     * </p>
     * 
     * @return The default theme for this QuickSight subscription.
     */
    public String defaultTheme() {
        return defaultTheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultTheme());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountCustomization)) {
            return false;
        }
        AccountCustomization other = (AccountCustomization) obj;
        return Objects.equals(defaultTheme(), other.defaultTheme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccountCustomization").add("DefaultTheme", defaultTheme()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultTheme":
            return Optional.ofNullable(clazz.cast(defaultTheme()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountCustomization, T> g) {
        return obj -> g.apply((AccountCustomization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountCustomization> {
        /**
         * <p>
         * The default theme for this QuickSight subscription.
         * </p>
         * 
         * @param defaultTheme
         *        The default theme for this QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTheme(String defaultTheme);
    }

    static final class BuilderImpl implements Builder {
        private String defaultTheme;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountCustomization model) {
            defaultTheme(model.defaultTheme);
        }

        public final String getDefaultTheme() {
            return defaultTheme;
        }

        @Override
        public final Builder defaultTheme(String defaultTheme) {
            this.defaultTheme = defaultTheme;
            return this;
        }

        public final void setDefaultTheme(String defaultTheme) {
            this.defaultTheme = defaultTheme;
        }

        @Override
        public AccountCustomization build() {
            return new AccountCustomization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
