/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ThemeErrorListCopier {
    static List<ThemeError> copy(Collection<ThemeError> themeErrorListParam) {
        if (themeErrorListParam == null || themeErrorListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<ThemeError> themeErrorListParamCopy = new ArrayList<>(themeErrorListParam);
        return Collections.unmodifiableList(themeErrorListParamCopy);
    }

    static List<ThemeError> copyFromBuilder(Collection<? extends ThemeError.Builder> themeErrorListParam) {
        if (themeErrorListParam == null) {
            return null;
        }
        return copy(themeErrorListParam.stream().map(ThemeError.Builder::build).collect(toList()));
    }
}
