/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccountCustomizationRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateAccountCustomizationRequest.Builder, CreateAccountCustomizationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAccountCustomizationRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAccountCustomizationRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<AccountCustomization> ACCOUNT_CUSTOMIZATION_FIELD = SdkField
            .<AccountCustomization> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateAccountCustomizationRequest::accountCustomization))
            .setter(setter(Builder::accountCustomization)).constructor(AccountCustomization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountCustomization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            NAMESPACE_FIELD, ACCOUNT_CUSTOMIZATION_FIELD));

    private final String awsAccountId;

    private final String namespace;

    private final AccountCustomization accountCustomization;

    private CreateAccountCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.accountCustomization = builder.accountCustomization;
    }

    /**
     * <p>
     * The ID for the AWS account that you want to customize QuickSight for.
     * </p>
     * 
     * @return The ID for the AWS account that you want to customize QuickSight for.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The QuickSight namespace that you want to add customizations to.
     * </p>
     * 
     * @return The QuickSight namespace that you want to add customizations to.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The QuickSight customizations you're adding in the current AWS Region. You can add these to an AWS account and a
     * QuickSight namespace.
     * </p>
     * <p>
     * For example, you could add a default theme by setting <code>AccountCustomization</code> to the midnight theme:
     * <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }. </code>. Or, you
     * could add a custom theme by specifying
     * <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>
     * .
     * </p>
     * 
     * @return The QuickSight customizations you're adding in the current AWS Region. You can add these to an AWS
     *         account and a QuickSight namespace. </p>
     *         <p>
     *         For example, you could add a default theme by setting <code>AccountCustomization</code> to the midnight
     *         theme:
     *         <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }. </code>. Or,
     *         you could add a custom theme by specifying
     *         <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>.
     */
    public AccountCustomization accountCustomization() {
        return accountCustomization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(accountCustomization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountCustomizationRequest)) {
            return false;
        }
        CreateAccountCustomizationRequest other = (CreateAccountCustomizationRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(accountCustomization(), other.accountCustomization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAccountCustomizationRequest").add("AwsAccountId", awsAccountId())
                .add("Namespace", namespace()).add("AccountCustomization", accountCustomization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "AccountCustomization":
            return Optional.ofNullable(clazz.cast(accountCustomization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountCustomizationRequest, T> g) {
        return obj -> g.apply((CreateAccountCustomizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccountCustomizationRequest> {
        /**
         * <p>
         * The ID for the AWS account that you want to customize QuickSight for.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account that you want to customize QuickSight for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The QuickSight namespace that you want to add customizations to.
         * </p>
         * 
         * @param namespace
         *        The QuickSight namespace that you want to add customizations to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The QuickSight customizations you're adding in the current AWS Region. You can add these to an AWS account
         * and a QuickSight namespace.
         * </p>
         * <p>
         * For example, you could add a default theme by setting <code>AccountCustomization</code> to the midnight
         * theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }. </code>.
         * Or, you could add a custom theme by specifying
         * <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>
         * .
         * </p>
         * 
         * @param accountCustomization
         *        The QuickSight customizations you're adding in the current AWS Region. You can add these to an AWS
         *        account and a QuickSight namespace. </p>
         *        <p>
         *        For example, you could add a default theme by setting <code>AccountCustomization</code> to the
         *        midnight theme:
         *        <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }. </code>.
         *        Or, you could add a custom theme by specifying
         *        <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountCustomization(AccountCustomization accountCustomization);

        /**
         * <p>
         * The QuickSight customizations you're adding in the current AWS Region. You can add these to an AWS account
         * and a QuickSight namespace.
         * </p>
         * <p>
         * For example, you could add a default theme by setting <code>AccountCustomization</code> to the midnight
         * theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }. </code>.
         * Or, you could add a custom theme by specifying
         * <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>
         * .
         * </p>
         * This is a convenience that creates an instance of the {@link AccountCustomization.Builder} avoiding the need
         * to create one manually via {@link AccountCustomization#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountCustomization.Builder#build()} is called immediately and
         * its result is passed to {@link #accountCustomization(AccountCustomization)}.
         * 
         * @param accountCustomization
         *        a consumer that will call methods on {@link AccountCustomization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountCustomization(AccountCustomization)
         */
        default Builder accountCustomization(Consumer<AccountCustomization.Builder> accountCustomization) {
            return accountCustomization(AccountCustomization.builder().applyMutation(accountCustomization).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String namespace;

        private AccountCustomization accountCustomization;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountCustomizationRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            accountCustomization(model.accountCustomization);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final AccountCustomization.Builder getAccountCustomization() {
            return accountCustomization != null ? accountCustomization.toBuilder() : null;
        }

        @Override
        public final Builder accountCustomization(AccountCustomization accountCustomization) {
            this.accountCustomization = accountCustomization;
            return this;
        }

        public final void setAccountCustomization(AccountCustomization.BuilderImpl accountCustomization) {
            this.accountCustomization = accountCustomization != null ? accountCustomization.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccountCustomizationRequest build() {
            return new CreateAccountCustomizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
