/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary metadata that describes an analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisSummary implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisSummary.Builder, AnalysisSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisSummary::analysisId)).setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AnalysisSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AnalysisSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ANALYSIS_ID_FIELD,
            NAME_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String analysisId;

    private final String name;

    private final String status;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private AnalysisSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.analysisId = builder.analysisId;
        this.name = builder.name;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the analysis.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the analysis.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the analysis. This ID displays in the URL.
     * </p>
     * 
     * @return The ID of the analysis. This ID displays in the URL.
     */
    public String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The name of the analysis. This name is displayed in the QuickSight console.
     * </p>
     * 
     * @return The name of the analysis. This name is displayed in the QuickSight console.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The last known status for the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The last known status for the analysis.
     * @see ResourceStatus
     */
    public ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The last known status for the analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The last known status for the analysis.
     * @see ResourceStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that the analysis was created.
     * </p>
     * 
     * @return The time that the analysis was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time that the analysis was last updated.
     * </p>
     * 
     * @return The time that the analysis was last updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSummary)) {
            return false;
        }
        AnalysisSummary other = (AnalysisSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(analysisId(), other.analysisId())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AnalysisSummary").add("Arn", arn()).add("AnalysisId", analysisId()).add("Name", name())
                .add("Status", statusAsString()).add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSummary, T> g) {
        return obj -> g.apply((AnalysisSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the analysis.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the analysis. This ID displays in the URL.
         * </p>
         * 
         * @param analysisId
         *        The ID of the analysis. This ID displays in the URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The name of the analysis. This name is displayed in the QuickSight console.
         * </p>
         * 
         * @param name
         *        The name of the analysis. This name is displayed in the QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The last known status for the analysis.
         * </p>
         * 
         * @param status
         *        The last known status for the analysis.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The last known status for the analysis.
         * </p>
         * 
         * @param status
         *        The last known status for the analysis.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * The time that the analysis was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the analysis was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time that the analysis was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time that the analysis was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String analysisId;

        private String name;

        private String status;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSummary model) {
            arn(model.arn);
            analysisId(model.analysisId);
            name(model.name);
            status(model.status);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public AnalysisSummary build() {
            return new AnalysisSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
