/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataSetPermissionsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateDataSetPermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataSetPermissionsRequest.getter(UpdateDataSetPermissionsRequest::awsAccountId)).setter(UpdateDataSetPermissionsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataSetPermissionsRequest.getter(UpdateDataSetPermissionsRequest::dataSetId)).setter(UpdateDataSetPermissionsRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final SdkField<List<ResourcePermission>> GRANT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateDataSetPermissionsRequest.getter(UpdateDataSetPermissionsRequest::grantPermissions)).setter(UpdateDataSetPermissionsRequest.setter(Builder::grantPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcePermission>> REVOKE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateDataSetPermissionsRequest.getter(UpdateDataSetPermissionsRequest::revokePermissions)).setter(UpdateDataSetPermissionsRequest.setter(Builder::revokePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DATA_SET_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));
    private final String awsAccountId;
    private final String dataSetId;
    private final List<ResourcePermission> grantPermissions;
    private final List<ResourcePermission> revokePermissions;

    private UpdateDataSetPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSetId = builder.dataSetId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String dataSetId() {
        return this.dataSetId;
    }

    public boolean hasGrantPermissions() {
        return this.grantPermissions != null && !(this.grantPermissions instanceof SdkAutoConstructList);
    }

    public List<ResourcePermission> grantPermissions() {
        return this.grantPermissions;
    }

    public boolean hasRevokePermissions() {
        return this.revokePermissions != null && !(this.revokePermissions instanceof SdkAutoConstructList);
    }

    public List<ResourcePermission> revokePermissions() {
        return this.revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.revokePermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSetPermissionsRequest)) {
            return false;
        }
        UpdateDataSetPermissionsRequest other = (UpdateDataSetPermissionsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.grantPermissions(), other.grantPermissions()) && Objects.equals(this.revokePermissions(), other.revokePermissions());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDataSetPermissionsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DataSetId", (Object)this.dataSetId()).add("GrantPermissions", this.grantPermissions()).add("RevokePermissions", this.revokePermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "GrantPermissions": {
                return Optional.ofNullable(clazz.cast(this.grantPermissions()));
            }
            case "RevokePermissions": {
                return Optional.ofNullable(clazz.cast(this.revokePermissions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSetPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateDataSetPermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dataSetId;
        private List<ResourcePermission> grantPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcePermission> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSetPermissionsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dataSetId(model.dataSetId);
            this.grantPermissions(model.grantPermissions);
            this.revokePermissions(model.revokePermissions);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final Collection<ResourcePermission.Builder> getGrantPermissions() {
            return this.grantPermissions != null ? (Collection)this.grantPermissions.stream().map(ResourcePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder grantPermissions(Collection<ResourcePermission> grantPermissions) {
            this.grantPermissions = ResourcePermissionListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(ResourcePermission ... grantPermissions) {
            this.grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<ResourcePermission.Builder> ... grantPermissions) {
            this.grantPermissions(Stream.of(grantPermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGrantPermissions(Collection<ResourcePermission.BuilderImpl> grantPermissions) {
            this.grantPermissions = ResourcePermissionListCopier.copyFromBuilder(grantPermissions);
        }

        public final Collection<ResourcePermission.Builder> getRevokePermissions() {
            return this.revokePermissions != null ? (Collection)this.revokePermissions.stream().map(ResourcePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revokePermissions(Collection<ResourcePermission> revokePermissions) {
            this.revokePermissions = ResourcePermissionListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(ResourcePermission ... revokePermissions) {
            this.revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<ResourcePermission.Builder> ... revokePermissions) {
            this.revokePermissions(Stream.of(revokePermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevokePermissions(Collection<ResourcePermission.BuilderImpl> revokePermissions) {
            this.revokePermissions = ResourcePermissionListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSetPermissionsRequest build() {
            return new UpdateDataSetPermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataSetPermissionsRequest> {
        public Builder awsAccountId(String var1);

        public Builder dataSetId(String var1);

        public Builder grantPermissions(Collection<ResourcePermission> var1);

        public Builder grantPermissions(ResourcePermission ... var1);

        public Builder grantPermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder revokePermissions(Collection<ResourcePermission> var1);

        public Builder revokePermissions(ResourcePermission ... var1);

        public Builder revokePermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

