/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionEmbedUrlRequest extends QuickSightRequest implements
        ToCopyableBuilder<GetSessionEmbedUrlRequest.Builder, GetSessionEmbedUrlRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSessionEmbedUrlRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSessionEmbedUrlRequest::entryPoint)).setter(setter(Builder::entryPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("entry-point").build()).build();

    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetSessionEmbedUrlRequest::sessionLifetimeInMinutes))
            .setter(setter(Builder::sessionLifetimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("session-lifetime").build())
            .build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSessionEmbedUrlRequest::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("user-arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ENTRY_POINT_FIELD, SESSION_LIFETIME_IN_MINUTES_FIELD, USER_ARN_FIELD));

    private final String awsAccountId;

    private final String entryPoint;

    private final Long sessionLifetimeInMinutes;

    private final String userArn;

    private GetSessionEmbedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.entryPoint = builder.entryPoint;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.userArn = builder.userArn;
    }

    /**
     * <p>
     * The ID for the AWS account associated with your QuickSight subscription.
     * </p>
     * 
     * @return The ID for the AWS account associated with your QuickSight subscription.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The URL you use to access the embedded session. The entry point URL is constrained to the following paths:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>/start</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/analyses</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/dashboards</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/favorites</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the
     * QuickSight console URL of the dashboard
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the
     * QuickSight console URL of the analysis
     * </p>
     * </li>
     * </ul>
     * 
     * @return The URL you use to access the embedded session. The entry point URL is constrained to the following
     *         paths:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>/start</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/analyses</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/dashboards</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/favorites</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from
     *         the QuickSight console URL of the dashboard
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the
     *         QuickSight console URL of the analysis
     *         </p>
     *         </li>
     */
    public String entryPoint() {
        return entryPoint;
    }

    /**
     * <p>
     * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     * </p>
     * 
     * @return How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     */
    public Long sessionLifetimeInMinutes() {
        return sessionLifetimeInMinutes;
    }

    /**
     * <p>
     * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You
     * can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to
     * be authenticated as one of the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Active Directory (AD) users or group members
     * </p>
     * </li>
     * <li>
     * <p>
     * Invited nonfederated users
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect,
     * or IAM federation
     * </p>
     * </li>
     * </ol>
     * <p>
     * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
     * </p>
     * 
     * @return The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity
     *         type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or
     *         admins). They need to be authenticated as one of the following:</p>
     *         <ol>
     *         <li>
     *         <p>
     *         Active Directory (AD) users or group members
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Invited nonfederated users
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID
     *         Connect, or IAM federation
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
     */
    public String userArn() {
        return userArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionEmbedUrlRequest)) {
            return false;
        }
        GetSessionEmbedUrlRequest other = (GetSessionEmbedUrlRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(entryPoint(), other.entryPoint())
                && Objects.equals(sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes())
                && Objects.equals(userArn(), other.userArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSessionEmbedUrlRequest").add("AwsAccountId", awsAccountId()).add("EntryPoint", entryPoint())
                .add("SessionLifetimeInMinutes", sessionLifetimeInMinutes()).add("UserArn", userArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "EntryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "SessionLifetimeInMinutes":
            return Optional.ofNullable(clazz.cast(sessionLifetimeInMinutes()));
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionEmbedUrlRequest, T> g) {
        return obj -> g.apply((GetSessionEmbedUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionEmbedUrlRequest> {
        /**
         * <p>
         * The ID for the AWS account associated with your QuickSight subscription.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account associated with your QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The URL you use to access the embedded session. The entry point URL is constrained to the following paths:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>/start</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/analyses</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/dashboards</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/favorites</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the
         * QuickSight console URL of the dashboard
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the
         * QuickSight console URL of the analysis
         * </p>
         * </li>
         * </ul>
         * 
         * @param entryPoint
         *        The URL you use to access the embedded session. The entry point URL is constrained to the following
         *        paths:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>/start</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/analyses</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/dashboards</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/favorites</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key
         *        from the QuickSight console URL of the dashboard
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from
         *        the QuickSight console URL of the analysis
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(String entryPoint);

        /**
         * <p>
         * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         * </p>
         * 
         * @param sessionLifetimeInMinutes
         *        How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes);

        /**
         * <p>
         * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type.
         * You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They
         * need to be authenticated as one of the following:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Active Directory (AD) users or group members
         * </p>
         * </li>
         * <li>
         * <p>
         * Invited nonfederated users
         * </p>
         * </li>
         * <li>
         * <p>
         * IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID
         * Connect, or IAM federation
         * </p>
         * </li>
         * </ol>
         * <p>
         * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
         * </p>
         * 
         * @param userArn
         *        The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity
         *        type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or
         *        admins). They need to be authenticated as one of the following:</p>
         *        <ol>
         *        <li>
         *        <p>
         *        Active Directory (AD) users or group members
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Invited nonfederated users
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML,
         *        OpenID Connect, or IAM federation
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String entryPoint;

        private Long sessionLifetimeInMinutes;

        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionEmbedUrlRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            entryPoint(model.entryPoint);
            sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            userArn(model.userArn);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getEntryPoint() {
            return entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        public final Long getSessionLifetimeInMinutes() {
            return sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSessionEmbedUrlRequest build() {
            return new GetSessionEmbedUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
