/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options for margins around the outside edge of sheets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MarginStyle implements SdkPojo, Serializable, ToCopyableBuilder<MarginStyle.Builder, MarginStyle> {
    private static final SdkField<Boolean> SHOW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MarginStyle::show)).setter(setter(Builder::show))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Show").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHOW_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean show;

    private MarginStyle(BuilderImpl builder) {
        this.show = builder.show;
    }

    /**
     * <p>
     * This Boolean value controls whether to display sheet margins.
     * </p>
     * 
     * @return This Boolean value controls whether to display sheet margins.
     */
    public Boolean show() {
        return show;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(show());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarginStyle)) {
            return false;
        }
        MarginStyle other = (MarginStyle) obj;
        return Objects.equals(show(), other.show());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MarginStyle").add("Show", show()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Show":
            return Optional.ofNullable(clazz.cast(show()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MarginStyle, T> g) {
        return obj -> g.apply((MarginStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MarginStyle> {
        /**
         * <p>
         * This Boolean value controls whether to display sheet margins.
         * </p>
         * 
         * @param show
         *        This Boolean value controls whether to display sheet margins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder show(Boolean show);
    }

    static final class BuilderImpl implements Builder {
        private Boolean show;

        private BuilderImpl() {
        }

        private BuilderImpl(MarginStyle model) {
            show(model.show);
        }

        public final Boolean getShow() {
            return show;
        }

        @Override
        public final Builder show(Boolean show) {
            this.show = show;
            return this;
        }

        public final void setShow(Boolean show) {
            this.show = show;
        }

        @Override
        public MarginStyle build() {
            return new MarginStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
