/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThemeAliasRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateThemeAliasRequest.Builder, UpdateThemeAliasRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeAliasRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeAliasRequest::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThemeId").build()).build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeAliasRequest::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AliasName").build()).build();

    private static final SdkField<Long> THEME_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateThemeAliasRequest::themeVersionNumber)).setter(setter(Builder::themeVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            THEME_ID_FIELD, ALIAS_NAME_FIELD, THEME_VERSION_NUMBER_FIELD));

    private final String awsAccountId;

    private final String themeId;

    private final String aliasName;

    private final Long themeVersionNumber;

    private UpdateThemeAliasRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.themeId = builder.themeId;
        this.aliasName = builder.aliasName;
        this.themeVersionNumber = builder.themeVersionNumber;
    }

    /**
     * <p>
     * The ID of the AWS account that contains the theme alias that you're updating.
     * </p>
     * 
     * @return The ID of the AWS account that contains the theme alias that you're updating.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the theme.
     * </p>
     * 
     * @return The ID for the theme.
     */
    public String themeId() {
        return themeId;
    }

    /**
     * <p>
     * The name of the theme alias that you want to update.
     * </p>
     * 
     * @return The name of the theme alias that you want to update.
     */
    public String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The version number of the theme that the alias should reference.
     * </p>
     * 
     * @return The version number of the theme that the alias should reference.
     */
    public Long themeVersionNumber() {
        return themeVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(themeVersionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeAliasRequest)) {
            return false;
        }
        UpdateThemeAliasRequest other = (UpdateThemeAliasRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(themeId(), other.themeId())
                && Objects.equals(aliasName(), other.aliasName())
                && Objects.equals(themeVersionNumber(), other.themeVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateThemeAliasRequest").add("AwsAccountId", awsAccountId()).add("ThemeId", themeId())
                .add("AliasName", aliasName()).add("ThemeVersionNumber", themeVersionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "ThemeVersionNumber":
            return Optional.ofNullable(clazz.cast(themeVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeAliasRequest, T> g) {
        return obj -> g.apply((UpdateThemeAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateThemeAliasRequest> {
        /**
         * <p>
         * The ID of the AWS account that contains the theme alias that you're updating.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the AWS account that contains the theme alias that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the theme.
         * </p>
         * 
         * @param themeId
         *        The ID for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);

        /**
         * <p>
         * The name of the theme alias that you want to update.
         * </p>
         * 
         * @param aliasName
         *        The name of the theme alias that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The version number of the theme that the alias should reference.
         * </p>
         * 
         * @param themeVersionNumber
         *        The version number of the theme that the alias should reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeVersionNumber(Long themeVersionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String themeId;

        private String aliasName;

        private Long themeVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeAliasRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            themeId(model.themeId);
            aliasName(model.aliasName);
            themeVersionNumber(model.themeVersionNumber);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getThemeId() {
            return themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        public final String getAliasName() {
            return aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final Long getThemeVersionNumber() {
            return themeVersionNumber;
        }

        @Override
        public final Builder themeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
            return this;
        }

        public final void setThemeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThemeAliasRequest build() {
            return new UpdateThemeAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
