/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThemeResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateThemeResponse.Builder, UpdateThemeResponse> {
    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeResponse::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeResponse::versionArn)).setter(setter(Builder::versionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionArn").build()).build();

    private static final SdkField<String> CREATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeResponse::creationStatusAsString)).setter(setter(Builder::creationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationStatus").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateThemeResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateThemeResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THEME_ID_FIELD, ARN_FIELD,
            VERSION_ARN_FIELD, CREATION_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private final String themeId;

    private final String arn;

    private final String versionArn;

    private final String creationStatus;

    private final Integer status;

    private final String requestId;

    private UpdateThemeResponse(BuilderImpl builder) {
        super(builder);
        this.themeId = builder.themeId;
        this.arn = builder.arn;
        this.versionArn = builder.versionArn;
        this.creationStatus = builder.creationStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ID for the theme.
     * </p>
     * 
     * @return The ID for the theme.
     */
    public String themeId() {
        return themeId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the theme.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the theme.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the new version of the theme.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the new version of the theme.
     */
    public String versionArn() {
        return versionArn;
    }

    /**
     * <p>
     * The creation status of the theme.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of the theme.
     * @see ResourceStatus
     */
    public ResourceStatus creationStatus() {
        return ResourceStatus.fromValue(creationStatus);
    }

    /**
     * <p>
     * The creation status of the theme.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #creationStatusAsString}.
     * </p>
     * 
     * @return The creation status of the theme.
     * @see ResourceStatus
     */
    public String creationStatusAsString() {
        return creationStatus;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(versionArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeResponse)) {
            return false;
        }
        UpdateThemeResponse other = (UpdateThemeResponse) obj;
        return Objects.equals(themeId(), other.themeId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(versionArn(), other.versionArn())
                && Objects.equals(creationStatusAsString(), other.creationStatusAsString())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateThemeResponse").add("ThemeId", themeId()).add("Arn", arn())
                .add("VersionArn", versionArn()).add("CreationStatus", creationStatusAsString()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "VersionArn":
            return Optional.ofNullable(clazz.cast(versionArn()));
        case "CreationStatus":
            return Optional.ofNullable(clazz.cast(creationStatusAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeResponse, T> g) {
        return obj -> g.apply((UpdateThemeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateThemeResponse> {
        /**
         * <p>
         * The ID for the theme.
         * </p>
         * 
         * @param themeId
         *        The ID for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the theme.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the new version of the theme.
         * </p>
         * 
         * @param versionArn
         *        The Amazon Resource Name (ARN) for the new version of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionArn(String versionArn);

        /**
         * <p>
         * The creation status of the theme.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of the theme.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(String creationStatus);

        /**
         * <p>
         * The creation status of the theme.
         * </p>
         * 
         * @param creationStatus
         *        The creation status of the theme.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder creationStatus(ResourceStatus creationStatus);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String themeId;

        private String arn;

        private String versionArn;

        private String creationStatus;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeResponse model) {
            super(model);
            themeId(model.themeId);
            arn(model.arn);
            versionArn(model.versionArn);
            creationStatus(model.creationStatus);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getThemeId() {
            return themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getVersionArn() {
            return versionArn;
        }

        @Override
        public final Builder versionArn(String versionArn) {
            this.versionArn = versionArn;
            return this;
        }

        public final void setVersionArn(String versionArn) {
            this.versionArn = versionArn;
        }

        public final String getCreationStatus() {
            return creationStatus;
        }

        @Override
        public final Builder creationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public final Builder creationStatus(ResourceStatus creationStatus) {
            this.creationStatus(creationStatus == null ? null : creationStatus.toString());
            return this;
        }

        public final void setCreationStatus(String creationStatus) {
            this.creationStatus = creationStatus;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public UpdateThemeResponse build() {
            return new UpdateThemeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
