/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSetImportMode;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionDataSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSetSummary.getter(DataSetSummary::arn)).setter(DataSetSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSetSummary.getter(DataSetSummary::dataSetId)).setter(DataSetSummary.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSetSummary.getter(DataSetSummary::name)).setter(DataSetSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DataSetSummary.getter(DataSetSummary::createdTime)).setter(DataSetSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DataSetSummary.getter(DataSetSummary::lastUpdatedTime)).setter(DataSetSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSetSummary.getter(DataSetSummary::importModeAsString)).setter(DataSetSummary.setter(Builder::importMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()}).build();
    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DataSetSummary.getter(DataSetSummary::rowLevelPermissionDataSet)).setter(DataSetSummary.setter(Builder::rowLevelPermissionDataSet)).constructor(RowLevelPermissionDataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_ID_FIELD, NAME_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, IMPORT_MODE_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String dataSetId;
    private final String name;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String importMode;
    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;

    private DataSetSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.importMode = builder.importMode;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
    }

    public String arn() {
        return this.arn;
    }

    public String dataSetId() {
        return this.dataSetId;
    }

    public String name() {
        return this.name;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(this.importMode);
    }

    public String importModeAsString() {
        return this.importMode;
    }

    public RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return this.rowLevelPermissionDataSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLevelPermissionDataSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetSummary)) {
            return false;
        }
        DataSetSummary other = (DataSetSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.importModeAsString(), other.importModeAsString()) && Objects.equals(this.rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet());
    }

    public String toString() {
        return ToString.builder((String)"DataSetSummary").add("Arn", (Object)this.arn()).add("DataSetId", (Object)this.dataSetId()).add("Name", (Object)this.name()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("ImportMode", (Object)this.importModeAsString()).add("RowLevelPermissionDataSet", (Object)this.rowLevelPermissionDataSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "ImportMode": {
                return Optional.ofNullable(clazz.cast(this.importModeAsString()));
            }
            case "RowLevelPermissionDataSet": {
                return Optional.ofNullable(clazz.cast(this.rowLevelPermissionDataSet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetSummary, T> g) {
        return obj -> g.apply((DataSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String dataSetId;
        private String name;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String importMode;
        private RowLevelPermissionDataSet rowLevelPermissionDataSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetSummary model) {
            this.arn(model.arn);
            this.dataSetId(model.dataSetId);
            this.name(model.name);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.importMode(model.importMode);
            this.rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getImportMode() {
            return this.importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return this.rowLevelPermissionDataSet != null ? this.rowLevelPermissionDataSet.toBuilder() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        public DataSetSummary build() {
            return new DataSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetSummary> {
        public Builder arn(String var1);

        public Builder dataSetId(String var1);

        public Builder name(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder importMode(String var1);

        public Builder importMode(DataSetImportMode var1);

        public Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet var1);

        default public Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return this.rowLevelPermissionDataSet((RowLevelPermissionDataSet)((RowLevelPermissionDataSet.Builder)RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet)).build());
        }
    }
}

