/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The QuickSight settings associated with your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettings implements SdkPojo, Serializable, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(AccountSettings::accountName)).setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(AccountSettings::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<String> DEFAULT_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultNamespace").getter(getter(AccountSettings::defaultNamespace))
            .setter(setter(Builder::defaultNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNamespace").build()).build();

    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationEmail").getter(getter(AccountSettings::notificationEmail))
            .setter(setter(Builder::notificationEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD,
            EDITION_FIELD, DEFAULT_NAMESPACE_FIELD, NOTIFICATION_EMAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountName;

    private final String edition;

    private final String defaultNamespace;

    private final String notificationEmail;

    private AccountSettings(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.edition = builder.edition;
        this.defaultNamespace = builder.defaultNamespace;
        this.notificationEmail = builder.notificationEmail;
    }

    /**
     * <p>
     * The "account name" you provided for the QuickSight subscription in your AWS account. You create this name when
     * you sign up for QuickSight. It is unique in all of AWS and it appears only in the console when users sign in.
     * </p>
     * 
     * @return The "account name" you provided for the QuickSight subscription in your AWS account. You create this name
     *         when you sign up for QuickSight. It is unique in all of AWS and it appears only in the console when users
     *         sign in.
     */
    public String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
     * @see Edition
     */
    public Edition edition() {
        return Edition.fromValue(edition);
    }

    /**
     * <p>
     * The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
     * @see Edition
     */
    public String editionAsString() {
        return edition;
    }

    /**
     * <p>
     * The default QuickSight namespace for your AWS account.
     * </p>
     * 
     * @return The default QuickSight namespace for your AWS account.
     */
    public String defaultNamespace() {
        return defaultNamespace;
    }

    /**
     * <p>
     * The main notification email for your QuickSight subscription.
     * </p>
     * 
     * @return The main notification email for your QuickSight subscription.
     */
    public String notificationEmail() {
        return notificationEmail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEmail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        return Objects.equals(accountName(), other.accountName()) && Objects.equals(editionAsString(), other.editionAsString())
                && Objects.equals(defaultNamespace(), other.defaultNamespace())
                && Objects.equals(notificationEmail(), other.notificationEmail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccountSettings").add("AccountName", accountName()).add("Edition", editionAsString())
                .add("DefaultNamespace", defaultNamespace()).add("NotificationEmail", notificationEmail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        case "DefaultNamespace":
            return Optional.ofNullable(clazz.cast(defaultNamespace()));
        case "NotificationEmail":
            return Optional.ofNullable(clazz.cast(notificationEmail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * The "account name" you provided for the QuickSight subscription in your AWS account. You create this name
         * when you sign up for QuickSight. It is unique in all of AWS and it appears only in the console when users
         * sign in.
         * </p>
         * 
         * @param accountName
         *        The "account name" you provided for the QuickSight subscription in your AWS account. You create this
         *        name when you sign up for QuickSight. It is unique in all of AWS and it appears only in the console
         *        when users sign in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
         * </p>
         * 
         * @param edition
         *        The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
         * </p>
         * 
         * @param edition
         *        The edition of QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(Edition edition);

        /**
         * <p>
         * The default QuickSight namespace for your AWS account.
         * </p>
         * 
         * @param defaultNamespace
         *        The default QuickSight namespace for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultNamespace(String defaultNamespace);

        /**
         * <p>
         * The main notification email for your QuickSight subscription.
         * </p>
         * 
         * @param notificationEmail
         *        The main notification email for your QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEmail(String notificationEmail);
    }

    static final class BuilderImpl implements Builder {
        private String accountName;

        private String edition;

        private String defaultNamespace;

        private String notificationEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            accountName(model.accountName);
            edition(model.edition);
            defaultNamespace(model.defaultNamespace);
            notificationEmail(model.notificationEmail);
        }

        public final String getAccountName() {
            return accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getEdition() {
            return edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        public final String getDefaultNamespace() {
            return defaultNamespace;
        }

        @Override
        public final Builder defaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public final void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        public final String getNotificationEmail() {
            return notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
