/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Twitter parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TwitterParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<TwitterParameters.Builder, TwitterParameters> {
    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Query")
            .getter(getter(TwitterParameters::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()).build();

    private static final SdkField<Integer> MAX_ROWS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRows").getter(getter(TwitterParameters::maxRows)).setter(setter(Builder::maxRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, MAX_ROWS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String query;

    private final Integer maxRows;

    private TwitterParameters(BuilderImpl builder) {
        this.query = builder.query;
        this.maxRows = builder.maxRows;
    }

    /**
     * <p>
     * Twitter query string.
     * </p>
     * 
     * @return Twitter query string.
     */
    public String query() {
        return query;
    }

    /**
     * <p>
     * Maximum number of rows to query Twitter.
     * </p>
     * 
     * @return Maximum number of rows to query Twitter.
     */
    public Integer maxRows() {
        return maxRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(maxRows());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TwitterParameters)) {
            return false;
        }
        TwitterParameters other = (TwitterParameters) obj;
        return Objects.equals(query(), other.query()) && Objects.equals(maxRows(), other.maxRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TwitterParameters").add("Query", query()).add("MaxRows", maxRows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Query":
            return Optional.ofNullable(clazz.cast(query()));
        case "MaxRows":
            return Optional.ofNullable(clazz.cast(maxRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TwitterParameters, T> g) {
        return obj -> g.apply((TwitterParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TwitterParameters> {
        /**
         * <p>
         * Twitter query string.
         * </p>
         * 
         * @param query
         *        Twitter query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);

        /**
         * <p>
         * Maximum number of rows to query Twitter.
         * </p>
         * 
         * @param maxRows
         *        Maximum number of rows to query Twitter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRows(Integer maxRows);
    }

    static final class BuilderImpl implements Builder {
        private String query;

        private Integer maxRows;

        private BuilderImpl() {
        }

        private BuilderImpl(TwitterParameters model) {
            query(model.query);
            maxRows(model.maxRows);
        }

        public final String getQuery() {
            return query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final Integer getMaxRows() {
            return maxRows;
        }

        @Override
        public final Builder maxRows(Integer maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public final void setMaxRows(Integer maxRows) {
            this.maxRows = maxRows;
        }

        @Override
        public TwitterParameters build() {
            return new TwitterParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
