/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.quicksight.model.AccessDeniedException;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.ConcurrentUpdatingException;
import software.amazon.awssdk.services.quicksight.model.ConflictException;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.DomainNotWhitelistedException;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.IdentityTypeNotSupportedException;
import software.amazon.awssdk.services.quicksight.model.InternalFailureException;
import software.amazon.awssdk.services.quicksight.model.InvalidNextTokenException;
import software.amazon.awssdk.services.quicksight.model.InvalidParameterValueException;
import software.amazon.awssdk.services.quicksight.model.LimitExceededException;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemesResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.PreconditionNotMetException;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.services.quicksight.model.QuickSightUserNotFoundException;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceExistsException;
import software.amazon.awssdk.services.quicksight.model.ResourceNotFoundException;
import software.amazon.awssdk.services.quicksight.model.ResourceUnavailableException;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import software.amazon.awssdk.services.quicksight.model.TagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.TagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ThrottlingException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedUserEditionException;
import software.amazon.awssdk.services.quicksight.model.UntagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.UntagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;
import software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable;
import software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable;
import software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable;

/**
 * Service client for accessing Amazon QuickSight. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon QuickSight API Reference</fullname>
 * <p>
 * Amazon QuickSight is a fully managed, serverless business intelligence service for the AWS Cloud that makes it easy
 * to extend data and insights to every user in your organization. This API reference contains documentation for a
 * programming interface that you can use to manage Amazon QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface QuickSightClient extends SdkClient {
    String SERVICE_NAME = "quicksight";

    /**
     * Create a {@link QuickSightClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QuickSightClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QuickSightClient}.
     */
    static QuickSightClientBuilder builder() {
        return new DefaultQuickSightClientBuilder();
    }

    /**
     * <p>
     * Cancels an ongoing ingestion of data into SPICE.
     * </p>
     *
     * @param cancelIngestionRequest
     * @return Result of the CancelIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CancelIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelIngestionResponse cancelIngestion(CancelIngestionRequest cancelIngestionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ResourceExistsException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an ongoing ingestion of data into SPICE.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link CancelIngestionRequest#builder()}
     * </p>
     *
     * @param cancelIngestionRequest
     *        A {@link Consumer} that will call methods on {@link CancelIngestionRequest.Builder} to create a request.
     * @return Result of the CancelIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CancelIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelIngestionResponse cancelIngestion(Consumer<CancelIngestionRequest.Builder> cancelIngestionRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return cancelIngestion(CancelIngestionRequest.builder().applyMutation(cancelIngestionRequest).build());
    }

    /**
     * <p>
     * Creates Amazon QuickSight customizations the current AWS Region. Currently, you can add a custom default theme by
     * using the <code>CreateAccountCustomization</code> or <code>UpdateAccountCustomization</code> API operation. To
     * further customize QuickSight by removing QuickSight sample assets and videos for all new users, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing QuickSight</a>
     * in the <i>Amazon QuickSight User Guide.</i>
     * </p>
     * <p>
     * You can create customizations for your AWS account or, if you specify a namespace, for a QuickSight namespace
     * instead. Customizations that apply to a namespace always override customizations that apply to an AWS account. To
     * find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation.
     * </p>
     * <p>
     * Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default,
     * make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme
     * isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the
     * current permissions by using the <code> <a>DescribeThemePermissions</a> </code> API operation. To share the
     * theme, grant permissions by using the <code> <a>UpdateThemePermissions</a> </code> API operation.
     * </p>
     *
     * @param createAccountCustomizationRequest
     * @return Result of the CreateAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountCustomizationResponse createAccountCustomization(
            CreateAccountCustomizationRequest createAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates Amazon QuickSight customizations the current AWS Region. Currently, you can add a custom default theme by
     * using the <code>CreateAccountCustomization</code> or <code>UpdateAccountCustomization</code> API operation. To
     * further customize QuickSight by removing QuickSight sample assets and videos for all new users, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing QuickSight</a>
     * in the <i>Amazon QuickSight User Guide.</i>
     * </p>
     * <p>
     * You can create customizations for your AWS account or, if you specify a namespace, for a QuickSight namespace
     * instead. Customizations that apply to a namespace always override customizations that apply to an AWS account. To
     * find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation.
     * </p>
     * <p>
     * Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default,
     * make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme
     * isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the
     * current permissions by using the <code> <a>DescribeThemePermissions</a> </code> API operation. To share the
     * theme, grant permissions by using the <code> <a>UpdateThemePermissions</a> </code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountCustomizationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAccountCustomizationRequest#builder()}
     * </p>
     *
     * @param createAccountCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccountCustomizationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountCustomizationResponse createAccountCustomization(
            Consumer<CreateAccountCustomizationRequest.Builder> createAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return createAccountCustomization(CreateAccountCustomizationRequest.builder()
                .applyMutation(createAccountCustomizationRequest).build());
    }

    /**
     * <p>
     * Creates an analysis in Amazon QuickSight.
     * </p>
     *
     * @param createAnalysisRequest
     * @return Result of the CreateAnalysis operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAnalysisResponse createAnalysis(CreateAnalysisRequest createAnalysisRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, ThrottlingException, ResourceExistsException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an analysis in Amazon QuickSight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnalysisRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAnalysisRequest#builder()}
     * </p>
     *
     * @param createAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link CreateAnalysisRequest.Builder} to create a request.
     * @return Result of the CreateAnalysis operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAnalysisResponse createAnalysis(Consumer<CreateAnalysisRequest.Builder> createAnalysisRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ThrottlingException, ResourceExistsException,
            ConflictException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return createAnalysis(CreateAnalysisRequest.builder().applyMutation(createAnalysisRequest).build());
    }

    /**
     * <p>
     * Creates a dashboard from a template. To first create a template, see the <code> <a>CreateTemplate</a> </code> API
     * operation.
     * </p>
     * <p>
     * A dashboard is an entity in QuickSight that identifies QuickSight reports, created from analyses. You can share
     * QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have
     * the correct permissions, you can create a dashboard from a template that exists in a different AWS account.
     * </p>
     *
     * @param createDashboardRequest
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ThrottlingException, ResourceExistsException,
            ConflictException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dashboard from a template. To first create a template, see the <code> <a>CreateTemplate</a> </code> API
     * operation.
     * </p>
     * <p>
     * A dashboard is an entity in QuickSight that identifies QuickSight reports, created from analyses. You can share
     * QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have
     * the correct permissions, you can create a dashboard from a template that exists in a different AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDashboardRequest#builder()}
     * </p>
     *
     * @param createDashboardRequest
     *        A {@link Consumer} that will call methods on {@link CreateDashboardRequest.Builder} to create a request.
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDashboardResponse createDashboard(Consumer<CreateDashboardRequest.Builder> createDashboardRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ThrottlingException, ResourceExistsException,
            ConflictException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return createDashboard(CreateDashboardRequest.builder().applyMutation(createDashboardRequest).build());
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     *
     * @param createDataSetRequest
     * @return Result of the CreateDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSetResponse createDataSet(CreateDataSetRequest createDataSetRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, LimitExceededException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDataSetRequest#builder()}
     * </p>
     *
     * @param createDataSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSetRequest.Builder} to create a request.
     * @return Result of the CreateDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSetResponse createDataSet(Consumer<CreateDataSetRequest.Builder> createDataSetRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, LimitExceededException,
            ResourceExistsException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return createDataSet(CreateDataSetRequest.builder().applyMutation(createDataSetRequest).build());
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, LimitExceededException,
            ResourceNotFoundException, ResourceExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceRequest.Builder} to create a request.
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, LimitExceededException,
            ResourceNotFoundException, ResourceExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, LimitExceededException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request. The
     *        request object for this operation.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, PreconditionNotMetException, LimitExceededException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return Result of the CreateGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGroupMembershipResponse createGroupMembership(CreateGroupMembershipRequest createGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupMembershipRequest#builder()}
     * </p>
     *
     * @param createGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGroupMembershipResponse createGroupMembership(
            Consumer<CreateGroupMembershipRequest.Builder> createGroupMembershipRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return createGroupMembership(CreateGroupMembershipRequest.builder().applyMutation(createGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy
     * will be assigned to specified groups or users of Amazon QuickSight. The users and groups need to be in the same
     * namespace.
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     * @return Result of the CreateIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIamPolicyAssignmentResponse createIAMPolicyAssignment(
            CreateIamPolicyAssignmentRequest createIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy
     * will be assigned to specified groups or users of Amazon QuickSight. The users and groups need to be in the same
     * namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIamPolicyAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateIAMPolicyAssignmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIamPolicyAssignmentResponse createIAMPolicyAssignment(
            Consumer<CreateIamPolicyAssignmentRequest.Builder> createIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return createIAMPolicyAssignment(CreateIamPolicyAssignmentRequest.builder()
                .applyMutation(createIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion on a dataset
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an
     * example, see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the AWS Knowledge Center. Tags
     * are visible on the tagged dataset, but not on the ingestion resource.
     * </p>
     *
     * @param createIngestionRequest
     * @return Result of the CreateIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIngestionResponse createIngestion(CreateIngestionRequest createIngestionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion on a dataset
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an
     * example, see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the AWS Knowledge Center. Tags
     * are visible on the tagged dataset, but not on the ingestion resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIngestionRequest#builder()}
     * </p>
     *
     * @param createIngestionRequest
     *        A {@link Consumer} that will call methods on {@link CreateIngestionRequest.Builder} to create a request.
     * @return Result of the CreateIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIngestionResponse createIngestion(Consumer<CreateIngestionRequest.Builder> createIngestionRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            LimitExceededException, ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return createIngestion(CreateIngestionRequest.builder().applyMutation(createIngestionRequest).build());
    }

    /**
     * <p>
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     * </p>
     * <p>
     * A namespace allows you to isolate the QuickSight users and groups that are registered for that namespace. Users
     * that access the namespace can share assets only with other users or groups in the same namespace. They can't see
     * users and groups in other namespaces. You can create a namespace after your AWS account is subscribed to
     * QuickSight. The namespace must be unique within the AWS account. By default, there is a limit of 100 namespaces
     * per AWS account. To increase your limit, create a ticket with AWS Support.
     * </p>
     *
     * @param createNamespaceRequest
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNamespaceResponse createNamespace(CreateNamespaceRequest createNamespaceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, PreconditionNotMetException, ConflictException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     * </p>
     * <p>
     * A namespace allows you to isolate the QuickSight users and groups that are registered for that namespace. Users
     * that access the namespace can share assets only with other users or groups in the same namespace. They can't see
     * users and groups in other namespaces. You can create a namespace after your AWS account is subscribed to
     * QuickSight. The namespace must be unique within the AWS account. By default, there is a limit of 100 namespaces
     * per AWS account. To increase your limit, create a ticket with AWS Support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNamespaceRequest#builder()}
     * </p>
     *
     * @param createNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link CreateNamespaceRequest.Builder} to create a request.
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNamespaceResponse createNamespace(Consumer<CreateNamespaceRequest.Builder> createNamespaceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            LimitExceededException, ResourceExistsException, PreconditionNotMetException, ConflictException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return createNamespace(CreateNamespaceRequest.builder().applyMutation(createNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a template from an existing QuickSight analysis or template. You can use the resulting template to create
     * a dashboard.
     * </p>
     * <p>
     * A <i>template</i> is an entity in QuickSight that encapsulates the metadata required to create an analysis and
     * that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace
     * the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset
     * placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     * </p>
     *
     * @param createTemplateRequest
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, LimitExceededException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a template from an existing QuickSight analysis or template. You can use the resulting template to create
     * a dashboard.
     * </p>
     * <p>
     * A <i>template</i> is an entity in QuickSight that encapsulates the metadata required to create an analysis and
     * that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace
     * the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset
     * placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTemplateRequest#builder()}
     * </p>
     *
     * @param createTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateTemplateRequest.Builder} to create a request.
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTemplateResponse createTemplate(Consumer<CreateTemplateRequest.Builder> createTemplateRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, LimitExceededException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return createTemplate(CreateTemplateRequest.builder().applyMutation(createTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     *
     * @param createTemplateAliasRequest
     * @return Result of the CreateTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTemplateAliasResponse createTemplateAlias(CreateTemplateAliasRequest createTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, ConflictException, ResourceExistsException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTemplateAliasRequest#builder()}
     * </p>
     *
     * @param createTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateTemplateAliasRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTemplateAliasResponse createTemplateAlias(
            Consumer<CreateTemplateAliasRequest.Builder> createTemplateAliasRequest) throws ThrottlingException,
            ResourceNotFoundException, ConflictException, ResourceExistsException, LimitExceededException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return createTemplateAlias(CreateTemplateAliasRequest.builder().applyMutation(createTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Creates a theme.
     * </p>
     * <p>
     * A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param createThemeRequest
     * @return Result of the CreateTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateThemeResponse createTheme(CreateThemeRequest createThemeRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a theme.
     * </p>
     * <p>
     * A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateThemeRequest#builder()}
     * </p>
     *
     * @param createThemeRequest
     *        A {@link Consumer} that will call methods on {@link CreateThemeRequest.Builder} to create a request.
     * @return Result of the CreateTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateThemeResponse createTheme(Consumer<CreateThemeRequest.Builder> createThemeRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, LimitExceededException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return createTheme(CreateThemeRequest.builder().applyMutation(createThemeRequest).build());
    }

    /**
     * <p>
     * Creates a theme alias for a theme.
     * </p>
     *
     * @param createThemeAliasRequest
     * @return Result of the CreateThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateThemeAliasResponse createThemeAlias(CreateThemeAliasRequest createThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, LimitExceededException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a theme alias for a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThemeAliasRequest.Builder} avoiding the need
     * to create one manually via {@link CreateThemeAliasRequest#builder()}
     * </p>
     *
     * @param createThemeAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateThemeAliasRequest.Builder} to create a request.
     * @return Result of the CreateThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateThemeAliasResponse createThemeAlias(Consumer<CreateThemeAliasRequest.Builder> createThemeAliasRequest)
            throws ConflictException, InvalidParameterValueException, LimitExceededException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return createThemeAlias(CreateThemeAliasRequest.builder().applyMutation(createThemeAliasRequest).build());
    }

    /**
     * <p>
     * Deletes all Amazon QuickSight customizations in this AWS Region for the specified AWS account and QuickSight
     * namespace.
     * </p>
     *
     * @param deleteAccountCustomizationRequest
     * @return Result of the DeleteAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountCustomizationResponse deleteAccountCustomization(
            DeleteAccountCustomizationRequest deleteAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all Amazon QuickSight customizations in this AWS Region for the specified AWS account and QuickSight
     * namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountCustomizationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccountCustomizationRequest#builder()}
     * </p>
     *
     * @param deleteAccountCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccountCustomizationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountCustomizationResponse deleteAccountCustomization(
            Consumer<DeleteAccountCustomizationRequest.Builder> deleteAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteAccountCustomization(DeleteAccountCustomizationRequest.builder()
                .applyMutation(deleteAccountCustomizationRequest).build());
    }

    /**
     * <p>
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can
     * restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. QuickSight
     * attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery window. At the
     * end of the recovery window, QuickSight deletes the analysis permanently.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the
     * <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API
     * until it's deleted, so you can describe it but you can't make a template from it.
     * </p>
     * <p>
     * An analysis that's scheduled for deletion isn't accessible in the QuickSight console. To access it in the
     * console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     * </p>
     *
     * @param deleteAnalysisRequest
     * @return Result of the DeleteAnalysis operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAnalysisResponse deleteAnalysis(DeleteAnalysisRequest deleteAnalysisRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can
     * restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. QuickSight
     * attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery window. At the
     * end of the recovery window, QuickSight deletes the analysis permanently.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the
     * <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API
     * until it's deleted, so you can describe it but you can't make a template from it.
     * </p>
     * <p>
     * An analysis that's scheduled for deletion isn't accessible in the QuickSight console. To access it in the
     * console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnalysisRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAnalysisRequest#builder()}
     * </p>
     *
     * @param deleteAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAnalysisRequest.Builder} to create a request.
     * @return Result of the DeleteAnalysis operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAnalysisResponse deleteAnalysis(Consumer<DeleteAnalysisRequest.Builder> deleteAnalysisRequest)
            throws ThrottlingException, InvalidParameterValueException, ConflictException, ResourceNotFoundException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return deleteAnalysis(DeleteAnalysisRequest.builder().applyMutation(deleteAnalysisRequest).build());
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDashboardRequest#builder()}
     * </p>
     *
     * @param deleteDashboardRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDashboardRequest.Builder} to create a request.
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDashboardResponse deleteDashboard(Consumer<DeleteDashboardRequest.Builder> deleteDashboardRequest)
            throws ThrottlingException, InvalidParameterValueException, ConflictException, ResourceNotFoundException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return deleteDashboard(DeleteDashboardRequest.builder().applyMutation(deleteDashboardRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     *
     * @param deleteDataSetRequest
     * @return Result of the DeleteDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSetResponse deleteDataSet(DeleteDataSetRequest deleteDataSetRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDataSetRequest#builder()}
     * </p>
     *
     * @param deleteDataSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSetRequest.Builder} to create a request.
     * @return Result of the DeleteDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSetResponse deleteDataSet(Consumer<DeleteDataSetRequest.Builder> deleteDataSetRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteDataSet(DeleteDataSetRequest.builder().applyMutation(deleteDataSetRequest).build());
    }

    /**
     * <p>
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data
     * source.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data
     * source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSourceRequest.Builder} to create a request.
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return Result of the DeleteGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGroupMembershipResponse deleteGroupMembership(DeleteGroupMembershipRequest deleteGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGroupMembershipRequest#builder()}
     * </p>
     *
     * @param deleteGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGroupMembershipResponse deleteGroupMembership(
            Consumer<DeleteGroupMembershipRequest.Builder> deleteGroupMembershipRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteGroupMembership(DeleteGroupMembershipRequest.builder().applyMutation(deleteGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes an existing IAM policy assignment.
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     * @return Result of the DeleteIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIamPolicyAssignmentResponse deleteIAMPolicyAssignment(
            DeleteIamPolicyAssignmentRequest deleteIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing IAM policy assignment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIamPolicyAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIAMPolicyAssignmentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIamPolicyAssignmentResponse deleteIAMPolicyAssignment(
            Consumer<DeleteIamPolicyAssignmentRequest.Builder> deleteIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteIAMPolicyAssignment(DeleteIamPolicyAssignmentRequest.builder()
                .applyMutation(deleteIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous
     * process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these
     * assets, you use the API operations for the relevant asset.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous
     * process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these
     * assets, you use the API operations for the relevant asset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNamespaceRequest.Builder} to create a request.
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     *
     * @param deleteTemplateRequest
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ConflictException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTemplateRequest#builder()}
     * </p>
     *
     * @param deleteTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTemplateRequest.Builder} to create a request.
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTemplateResponse deleteTemplate(Consumer<DeleteTemplateRequest.Builder> deleteTemplateRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ConflictException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return deleteTemplate(DeleteTemplateRequest.builder().applyMutation(deleteTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the
     * version of the template that the alias points to.
     * </p>
     *
     * @param deleteTemplateAliasRequest
     * @return Result of the DeleteTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTemplateAliasResponse deleteTemplateAlias(DeleteTemplateAliasRequest deleteTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the
     * version of the template that the alias points to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTemplateAliasRequest#builder()}
     * </p>
     *
     * @param deleteTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTemplateAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTemplateAliasResponse deleteTemplateAlias(
            Consumer<DeleteTemplateAliasRequest.Builder> deleteTemplateAliasRequest) throws ThrottlingException,
            ResourceNotFoundException, UnsupportedUserEditionException, ConflictException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return deleteTemplateAlias(DeleteTemplateAliasRequest.builder().applyMutation(deleteTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Deletes a theme.
     * </p>
     *
     * @param deleteThemeRequest
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteThemeResponse deleteTheme(DeleteThemeRequest deleteThemeRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThemeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteThemeRequest#builder()}
     * </p>
     *
     * @param deleteThemeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThemeRequest.Builder} to create a request.
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteThemeResponse deleteTheme(Consumer<DeleteThemeRequest.Builder> deleteThemeRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return deleteTheme(DeleteThemeRequest.builder().applyMutation(deleteThemeRequest).build());
    }

    /**
     * <p>
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you
     * delete the version of the theme that the alias points to.
     * </p>
     *
     * @param deleteThemeAliasRequest
     * @return Result of the DeleteThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteThemeAliasResponse deleteThemeAlias(DeleteThemeAliasRequest deleteThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you
     * delete the version of the theme that the alias points to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThemeAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteThemeAliasRequest#builder()}
     * </p>
     *
     * @param deleteThemeAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThemeAliasRequest.Builder} to create a request.
     * @return Result of the DeleteThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteThemeAliasResponse deleteThemeAlias(Consumer<DeleteThemeAliasRequest.Builder> deleteThemeAliasRequest)
            throws ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return deleteThemeAlias(DeleteThemeAliasRequest.builder().applyMutation(deleteThemeAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     * @return Result of the DeleteUserByPrincipalId operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUserByPrincipalId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserByPrincipalIdResponse deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserByPrincipalIdRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteUserByPrincipalIdRequest#builder()}
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserByPrincipalIdRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserByPrincipalId operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUserByPrincipalId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserByPrincipalIdResponse deleteUserByPrincipalId(
            Consumer<DeleteUserByPrincipalIdRequest.Builder> deleteUserByPrincipalIdRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest.builder().applyMutation(deleteUserByPrincipalIdRequest)
                .build());
    }

    /**
     * <p>
     * Describes the customizations associated with the provided AWS account and Amazon QuickSight namespace in an AWS
     * Region. The QuickSight console evaluates which customizations to apply by running this API operation with the
     * <code>Resolved</code> flag included.
     * </p>
     * <p>
     * To determine what customizations display when you run this command, it can help to visualize the relationship of
     * the entities involved.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS Account</code> - The AWS account exists at the top of the hierarchy. It has the potential to use all of
     * the AWS Regions and AWS Services. When you subscribe to QuickSight, you choose one AWS Region to use as your home
     * Region. That's where your free SPICE capacity is located. You can use QuickSight in any supported AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS Region</code> - In each AWS Region where you sign in to QuickSight at least once, QuickSight acts as a
     * separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US
     * East (N. Virginia). Generally speaking, these users have access to QuickSight in any AWS Region, unless they are
     * constrained to a namespace.
     * </p>
     * <p>
     * To run the command in a different AWS Region, you change your Region settings. If you're using the AWS CLI, you
     * can use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line
     * options</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>aws configure</code> to change your default AWS Region. Use Enter to key the same settings for your
     * keys. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the AWS CLI</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code> - A QuickSight namespace is a partition that contains users and assets (data sources,
     * datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also
     * be part of the same namespace. People who share a namespace are completely isolated from users and assets in
     * other namespaces, even if they are in the same AWS account and AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Applied customizations</code> - Within an AWS Region, a set of QuickSight customizations can apply to an
     * AWS account or to a namespace. Settings that you apply to a namespace override settings that you apply to an AWS
     * account. All settings are isolated to a single AWS Region. To apply them in other AWS Regions, run the
     * <code>CreateAccountCustomization</code> command in each AWS Region where you want to apply the same
     * customizations.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountCustomizationRequest
     * @return Result of the DescribeAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountCustomizationResponse describeAccountCustomization(
            DescribeAccountCustomizationRequest describeAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the customizations associated with the provided AWS account and Amazon QuickSight namespace in an AWS
     * Region. The QuickSight console evaluates which customizations to apply by running this API operation with the
     * <code>Resolved</code> flag included.
     * </p>
     * <p>
     * To determine what customizations display when you run this command, it can help to visualize the relationship of
     * the entities involved.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS Account</code> - The AWS account exists at the top of the hierarchy. It has the potential to use all of
     * the AWS Regions and AWS Services. When you subscribe to QuickSight, you choose one AWS Region to use as your home
     * Region. That's where your free SPICE capacity is located. You can use QuickSight in any supported AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS Region</code> - In each AWS Region where you sign in to QuickSight at least once, QuickSight acts as a
     * separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US
     * East (N. Virginia). Generally speaking, these users have access to QuickSight in any AWS Region, unless they are
     * constrained to a namespace.
     * </p>
     * <p>
     * To run the command in a different AWS Region, you change your Region settings. If you're using the AWS CLI, you
     * can use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line
     * options</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>aws configure</code> to change your default AWS Region. Use Enter to key the same settings for your
     * keys. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the AWS CLI</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code> - A QuickSight namespace is a partition that contains users and assets (data sources,
     * datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also
     * be part of the same namespace. People who share a namespace are completely isolated from users and assets in
     * other namespaces, even if they are in the same AWS account and AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Applied customizations</code> - Within an AWS Region, a set of QuickSight customizations can apply to an
     * AWS account or to a namespace. Settings that you apply to a namespace override settings that you apply to an AWS
     * account. All settings are isolated to a single AWS Region. To apply them in other AWS Regions, run the
     * <code>CreateAccountCustomization</code> command in each AWS Region where you want to apply the same
     * customizations.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountCustomizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountCustomizationRequest#builder()}
     * </p>
     *
     * @param describeAccountCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountCustomizationRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountCustomizationResponse describeAccountCustomization(
            Consumer<DescribeAccountCustomizationRequest.Builder> describeAccountCustomizationRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return describeAccountCustomization(DescribeAccountCustomizationRequest.builder()
                .applyMutation(describeAccountCustomizationRequest).build());
    }

    /**
     * <p>
     * Describes the settings that were used when your QuickSight subscription was first created in this AWS account.
     * </p>
     *
     * @param describeAccountSettingsRequest
     * @return Result of the DescribeAccountSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountSettingsResponse describeAccountSettings(DescribeAccountSettingsRequest describeAccountSettingsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings that were used when your QuickSight subscription was first created in this AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountSettingsRequest#builder()}
     * </p>
     *
     * @param describeAccountSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountSettingsResponse describeAccountSettings(
            Consumer<DescribeAccountSettingsRequest.Builder> describeAccountSettingsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return describeAccountSettings(DescribeAccountSettingsRequest.builder().applyMutation(describeAccountSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Provides a summary of the metadata for an analysis.
     * </p>
     *
     * @param describeAnalysisRequest
     * @return Result of the DescribeAnalysis operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAnalysisResponse describeAnalysis(DescribeAnalysisRequest describeAnalysisRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a summary of the metadata for an analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnalysisRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAnalysisRequest#builder()}
     * </p>
     *
     * @param describeAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAnalysisRequest.Builder} to create a request.
     * @return Result of the DescribeAnalysis operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAnalysisResponse describeAnalysis(Consumer<DescribeAnalysisRequest.Builder> describeAnalysisRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return describeAnalysis(DescribeAnalysisRequest.builder().applyMutation(describeAnalysisRequest).build());
    }

    /**
     * <p>
     * Provides the read and write permissions for an analysis.
     * </p>
     *
     * @param describeAnalysisPermissionsRequest
     * @return Result of the DescribeAnalysisPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysisPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnalysisPermissionsResponse describeAnalysisPermissions(
            DescribeAnalysisPermissionsRequest describeAnalysisPermissionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the read and write permissions for an analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnalysisPermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAnalysisPermissionsRequest#builder()}
     * </p>
     *
     * @param describeAnalysisPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAnalysisPermissionsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeAnalysisPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysisPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAnalysisPermissionsResponse describeAnalysisPermissions(
            Consumer<DescribeAnalysisPermissionsRequest.Builder> describeAnalysisPermissionsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return describeAnalysisPermissions(DescribeAnalysisPermissionsRequest.builder()
                .applyMutation(describeAnalysisPermissionsRequest).build());
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDashboardResponse describeDashboard(DescribeDashboardRequest describeDashboardRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDashboardRequest#builder()}
     * </p>
     *
     * @param describeDashboardRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDashboardRequest.Builder} to create a request.
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDashboardResponse describeDashboard(Consumer<DescribeDashboardRequest.Builder> describeDashboardRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return describeDashboard(DescribeDashboardRequest.builder().applyMutation(describeDashboardRequest).build());
    }

    /**
     * <p>
     * Describes read and write permissions for a dashboard.
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     * @return Result of the DescribeDashboardPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDashboardPermissionsResponse describeDashboardPermissions(
            DescribeDashboardPermissionsRequest describeDashboardPermissionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes read and write permissions for a dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDashboardPermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDashboardPermissionsRequest#builder()}
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDashboardPermissionsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeDashboardPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDashboardPermissionsResponse describeDashboardPermissions(
            Consumer<DescribeDashboardPermissionsRequest.Builder> describeDashboardPermissionsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return describeDashboardPermissions(DescribeDashboardPermissionsRequest.builder()
                .applyMutation(describeDashboardPermissionsRequest).build());
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     *
     * @param describeDataSetRequest
     * @return Result of the DescribeDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataSetResponse describeDataSet(DescribeDataSetRequest describeDataSetRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDataSetRequest#builder()}
     * </p>
     *
     * @param describeDataSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSetRequest.Builder} to create a request.
     * @return Result of the DescribeDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataSetResponse describeDataSet(Consumer<DescribeDataSetRequest.Builder> describeDataSetRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return describeDataSet(DescribeDataSetRequest.builder().applyMutation(describeDataSetRequest).build());
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     * @return Result of the DescribeDataSetPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSetPermissionsResponse describeDataSetPermissions(
            DescribeDataSetPermissionsRequest describeDataSetPermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSetPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDataSetPermissionsRequest#builder()}
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSetPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDataSetPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSetPermissionsResponse describeDataSetPermissions(
            Consumer<DescribeDataSetPermissionsRequest.Builder> describeDataSetPermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return describeDataSetPermissions(DescribeDataSetPermissionsRequest.builder()
                .applyMutation(describeDataSetPermissionsRequest).build());
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return Result of the DescribeDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataSourceResponse describeDataSource(DescribeDataSourceRequest describeDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSourceRequest#builder()}
     * </p>
     *
     * @param describeDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataSourceResponse describeDataSource(Consumer<DescribeDataSourceRequest.Builder> describeDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return describeDataSource(DescribeDataSourceRequest.builder().applyMutation(describeDataSourceRequest).build());
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     * @return Result of the DescribeDataSourcePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSourcePermissionsResponse describeDataSourcePermissions(
            DescribeDataSourcePermissionsRequest describeDataSourcePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataSourcePermissionsRequest#builder()}
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourcePermissionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDataSourcePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSourcePermissionsResponse describeDataSourcePermissions(
            Consumer<DescribeDataSourcePermissionsRequest.Builder> describeDataSourcePermissionsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return describeDataSourcePermissions(DescribeDataSourcePermissionsRequest.builder()
                .applyMutation(describeDataSourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeGroupRequest
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGroupRequest.Builder} to create a request.
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupResponse describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Describes an existing IAM policy assignment, as specified by the assignment name.
     * </p>
     *
     * @param describeIamPolicyAssignmentRequest
     * @return Result of the DescribeIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIamPolicyAssignmentResponse describeIAMPolicyAssignment(
            DescribeIamPolicyAssignmentRequest describeIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing IAM policy assignment, as specified by the assignment name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIamPolicyAssignmentRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param describeIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIAMPolicyAssignmentRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIamPolicyAssignmentResponse describeIAMPolicyAssignment(
            Consumer<DescribeIamPolicyAssignmentRequest.Builder> describeIamPolicyAssignmentRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return describeIAMPolicyAssignment(DescribeIamPolicyAssignmentRequest.builder()
                .applyMutation(describeIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Describes a SPICE ingestion.
     * </p>
     *
     * @param describeIngestionRequest
     * @return Result of the DescribeIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIngestionResponse describeIngestion(DescribeIngestionRequest describeIngestionRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a SPICE ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeIngestionRequest#builder()}
     * </p>
     *
     * @param describeIngestionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIngestionRequest.Builder} to create a request.
     * @return Result of the DescribeIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeIngestion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIngestionResponse describeIngestion(Consumer<DescribeIngestionRequest.Builder> describeIngestionRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return describeIngestion(DescribeIngestionRequest.builder().applyMutation(describeIngestionRequest).build());
    }

    /**
     * <p>
     * Describes the current namespace.
     * </p>
     *
     * @param describeNamespaceRequest
     * @return Result of the DescribeNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest describeNamespaceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeNamespaceRequest#builder()}
     * </p>
     *
     * @param describeNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNamespaceRequest.Builder} to create a request.
     * @return Result of the DescribeNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeNamespaceResponse describeNamespace(Consumer<DescribeNamespaceRequest.Builder> describeNamespaceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return describeNamespace(DescribeNamespaceRequest.builder().applyMutation(describeNamespaceRequest).build());
    }

    /**
     * <p>
     * Describes a template's metadata.
     * </p>
     *
     * @param describeTemplateRequest
     * @return Result of the DescribeTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTemplateResponse describeTemplate(DescribeTemplateRequest describeTemplateRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, ConflictException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a template's metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTemplateRequest#builder()}
     * </p>
     *
     * @param describeTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTemplateRequest.Builder} to create a request.
     * @return Result of the DescribeTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTemplateResponse describeTemplate(Consumer<DescribeTemplateRequest.Builder> describeTemplateRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, ConflictException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return describeTemplate(DescribeTemplateRequest.builder().applyMutation(describeTemplateRequest).build());
    }

    /**
     * <p>
     * Describes the template alias for a template.
     * </p>
     *
     * @param describeTemplateAliasRequest
     * @return Result of the DescribeTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTemplateAliasResponse describeTemplateAlias(DescribeTemplateAliasRequest describeTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the template alias for a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTemplateAliasRequest#builder()}
     * </p>
     *
     * @param describeTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTemplateAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTemplateAliasResponse describeTemplateAlias(
            Consumer<DescribeTemplateAliasRequest.Builder> describeTemplateAliasRequest) throws ThrottlingException,
            ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return describeTemplateAlias(DescribeTemplateAliasRequest.builder().applyMutation(describeTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Describes read and write permissions on a template.
     * </p>
     *
     * @param describeTemplatePermissionsRequest
     * @return Result of the DescribeTemplatePermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTemplatePermissionsResponse describeTemplatePermissions(
            DescribeTemplatePermissionsRequest describeTemplatePermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes read and write permissions on a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTemplatePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTemplatePermissionsRequest#builder()}
     * </p>
     *
     * @param describeTemplatePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTemplatePermissionsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeTemplatePermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTemplatePermissionsResponse describeTemplatePermissions(
            Consumer<DescribeTemplatePermissionsRequest.Builder> describeTemplatePermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return describeTemplatePermissions(DescribeTemplatePermissionsRequest.builder()
                .applyMutation(describeTemplatePermissionsRequest).build());
    }

    /**
     * <p>
     * Describes a theme.
     * </p>
     *
     * @param describeThemeRequest
     * @return Result of the DescribeTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeThemeResponse describeTheme(DescribeThemeRequest describeThemeRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThemeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeThemeRequest#builder()}
     * </p>
     *
     * @param describeThemeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThemeRequest.Builder} to create a request.
     * @return Result of the DescribeTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeThemeResponse describeTheme(Consumer<DescribeThemeRequest.Builder> describeThemeRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return describeTheme(DescribeThemeRequest.builder().applyMutation(describeThemeRequest).build());
    }

    /**
     * <p>
     * Describes the alias for a theme.
     * </p>
     *
     * @param describeThemeAliasRequest
     * @return Result of the DescribeThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeThemeAliasResponse describeThemeAlias(DescribeThemeAliasRequest describeThemeAliasRequest)
            throws ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the alias for a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThemeAliasRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeThemeAliasRequest#builder()}
     * </p>
     *
     * @param describeThemeAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThemeAliasRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeThemeAliasResponse describeThemeAlias(Consumer<DescribeThemeAliasRequest.Builder> describeThemeAliasRequest)
            throws ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return describeThemeAlias(DescribeThemeAliasRequest.builder().applyMutation(describeThemeAliasRequest).build());
    }

    /**
     * <p>
     * Describes the read and write permissions for a theme.
     * </p>
     *
     * @param describeThemePermissionsRequest
     * @return Result of the DescribeThemePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeThemePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeThemePermissionsResponse describeThemePermissions(
            DescribeThemePermissionsRequest describeThemePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the read and write permissions for a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThemePermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeThemePermissionsRequest#builder()}
     * </p>
     *
     * @param describeThemePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThemePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeThemePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeThemePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeThemePermissionsResponse describeThemePermissions(
            Consumer<DescribeThemePermissionsRequest.Builder> describeThemePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return describeThemePermissions(DescribeThemePermissionsRequest.builder().applyMutation(describeThemePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return Result of the DescribeUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Generates a session URL and authorization code that you can use to embed an Amazon QuickSight read-only dashboard
     * in your web server code. Before you use this command, make sure that you have configured the dashboards and
     * permissions.
     * </p>
     * <p>
     * Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user's browser. The
     * following rules apply to the combination of URL and authorization code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * They must be used together.
     * </p>
     * </li>
     * <li>
     * <p>
     * They can be used one time only.
     * </p>
     * </li>
     * <li>
     * <p>
     * They are valid for 5 minutes after you run this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resulting user session is valid for 10 hours.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-dashboards.html">Embedding Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i> .
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     * @return Result of the GetDashboardEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws DomainNotWhitelistedException
     *         The domain specified isn't on the allow list. All domains for embedded dashboards must be added to the
     *         approved list by an Amazon QuickSight admin.
     * @throws QuickSightUserNotFoundException
     *         The user with the provided name isn't found. This error can happen in any operation that requires finding
     *         a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so
     *         on.
     * @throws IdentityTypeNotSupportedException
     *         The identity type specified isn't supported. Supported identity types include <code>IAM</code> and
     *         <code>QUICKSIGHT</code>.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDashboardEmbedUrlResponse getDashboardEmbedUrl(GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, DomainNotWhitelistedException, QuickSightUserNotFoundException,
            IdentityTypeNotSupportedException, SessionLifetimeInMinutesInvalidException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a session URL and authorization code that you can use to embed an Amazon QuickSight read-only dashboard
     * in your web server code. Before you use this command, make sure that you have configured the dashboards and
     * permissions.
     * </p>
     * <p>
     * Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user's browser. The
     * following rules apply to the combination of URL and authorization code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * They must be used together.
     * </p>
     * </li>
     * <li>
     * <p>
     * They can be used one time only.
     * </p>
     * </li>
     * <li>
     * <p>
     * They are valid for 5 minutes after you run this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resulting user session is valid for 10 hours.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-dashboards.html">Embedding Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i> .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDashboardEmbedUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetDashboardEmbedUrlRequest#builder()}
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetDashboardEmbedUrlRequest.Builder} to create a
     *        request.
     * @return Result of the GetDashboardEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws DomainNotWhitelistedException
     *         The domain specified isn't on the allow list. All domains for embedded dashboards must be added to the
     *         approved list by an Amazon QuickSight admin.
     * @throws QuickSightUserNotFoundException
     *         The user with the provided name isn't found. This error can happen in any operation that requires finding
     *         a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so
     *         on.
     * @throws IdentityTypeNotSupportedException
     *         The identity type specified isn't supported. Supported identity types include <code>IAM</code> and
     *         <code>QUICKSIGHT</code>.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDashboardEmbedUrlResponse getDashboardEmbedUrl(
            Consumer<GetDashboardEmbedUrlRequest.Builder> getDashboardEmbedUrlRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            DomainNotWhitelistedException, QuickSightUserNotFoundException, IdentityTypeNotSupportedException,
            SessionLifetimeInMinutesInvalidException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return getDashboardEmbedUrl(GetDashboardEmbedUrlRequest.builder().applyMutation(getDashboardEmbedUrlRequest).build());
    }

    /**
     * <p>
     * Generates a session URL and authorization code that you can use to embed the Amazon QuickSight console in your
     * web server code. Use <code>GetSessionEmbedUrl</code> where you want to provide an authoring portal that allows
     * users to create data sources, datasets, analyses, and dashboards. The users who access an embedded QuickSight
     * console need belong to the author or admin security cohort. If you want to restrict permissions to some of these
     * features, add a custom permissions profile to the user with the <code> <a>UpdateUser</a> </code> API operation.
     * Use <code> <a>RegisterUser</a> </code> API operation to add a new user with a custom permission profile attached.
     * For more information, see the following sections in the <i>Amazon QuickSight User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-the-quicksight-console.html">Embedding the
     * Amazon QuickSight Console</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     * >Customizing Access to the Amazon QuickSight Console</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getSessionEmbedUrlRequest
     * @return Result of the GetSessionEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws QuickSightUserNotFoundException
     *         The user with the provided name isn't found. This error can happen in any operation that requires finding
     *         a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so
     *         on.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetSessionEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSessionEmbedUrlResponse getSessionEmbedUrl(GetSessionEmbedUrlRequest getSessionEmbedUrlRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, QuickSightUserNotFoundException, SessionLifetimeInMinutesInvalidException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a session URL and authorization code that you can use to embed the Amazon QuickSight console in your
     * web server code. Use <code>GetSessionEmbedUrl</code> where you want to provide an authoring portal that allows
     * users to create data sources, datasets, analyses, and dashboards. The users who access an embedded QuickSight
     * console need belong to the author or admin security cohort. If you want to restrict permissions to some of these
     * features, add a custom permissions profile to the user with the <code> <a>UpdateUser</a> </code> API operation.
     * Use <code> <a>RegisterUser</a> </code> API operation to add a new user with a custom permission profile attached.
     * For more information, see the following sections in the <i>Amazon QuickSight User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-the-quicksight-console.html">Embedding the
     * Amazon QuickSight Console</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     * >Customizing Access to the Amazon QuickSight Console</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionEmbedUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetSessionEmbedUrlRequest#builder()}
     * </p>
     *
     * @param getSessionEmbedUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetSessionEmbedUrlRequest.Builder} to create a
     *        request.
     * @return Result of the GetSessionEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws QuickSightUserNotFoundException
     *         The user with the provided name isn't found. This error can happen in any operation that requires finding
     *         a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so
     *         on.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetSessionEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSessionEmbedUrlResponse getSessionEmbedUrl(Consumer<GetSessionEmbedUrlRequest.Builder> getSessionEmbedUrlRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, QuickSightUserNotFoundException, SessionLifetimeInMinutesInvalidException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return getSessionEmbedUrl(GetSessionEmbedUrlRequest.builder().applyMutation(getSessionEmbedUrlRequest).build());
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified AWS account.
     * </p>
     *
     * @param listAnalysesRequest
     * @return Result of the ListAnalyses operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAnalysesResponse listAnalyses(ListAnalysesRequest listAnalysesRequest) throws ThrottlingException,
            InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalysesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnalysesRequest#builder()}
     * </p>
     *
     * @param listAnalysesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnalysesRequest.Builder} to create a request.
     * @return Result of the ListAnalyses operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAnalysesResponse listAnalyses(Consumer<ListAnalysesRequest.Builder> listAnalysesRequest)
            throws ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listAnalyses(ListAnalysesRequest.builder().applyMutation(listAnalysesRequest).build());
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)} operation.</b>
     * </p>
     *
     * @param listAnalysesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAnalysesIterable listAnalysesPaginator(ListAnalysesRequest listAnalysesRequest) throws ThrottlingException,
            InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalysesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnalysesRequest#builder()}
     * </p>
     *
     * @param listAnalysesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnalysesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAnalysesIterable listAnalysesPaginator(Consumer<ListAnalysesRequest.Builder> listAnalysesRequest)
            throws ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listAnalysesPaginator(ListAnalysesRequest.builder().applyMutation(listAnalysesRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the QuickSight subscription.
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return Result of the ListDashboardVersions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDashboardVersionsResponse listDashboardVersions(ListDashboardVersionsRequest listDashboardVersionsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the QuickSight subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDashboardVersionsRequest#builder()}
     * </p>
     *
     * @param listDashboardVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDashboardVersions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDashboardVersionsResponse listDashboardVersions(
            Consumer<ListDashboardVersionsRequest.Builder> listDashboardVersionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return listDashboardVersions(ListDashboardVersionsRequest.builder().applyMutation(listDashboardVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the QuickSight subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client.listDashboardVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client
     *             .listDashboardVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client.listDashboardVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDashboardVersionsIterable listDashboardVersionsPaginator(ListDashboardVersionsRequest listDashboardVersionsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the QuickSight subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client.listDashboardVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client
     *             .listDashboardVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client.listDashboardVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDashboardVersionsRequest#builder()}
     * </p>
     *
     * @param listDashboardVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboardVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDashboardVersionsIterable listDashboardVersionsPaginator(
            Consumer<ListDashboardVersionsRequest.Builder> listDashboardVersionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return listDashboardVersionsPaginator(ListDashboardVersionsRequest.builder().applyMutation(listDashboardVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists dashboards in an AWS account.
     * </p>
     *
     * @param listDashboardsRequest
     * @return Result of the ListDashboards operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws ThrottlingException,
            InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists dashboards in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardsRequest.Builder} to create a request.
     * @return Result of the ListDashboards operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDashboardsResponse listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest)
            throws ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listDashboards(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Lists dashboards in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client
     *             .listDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation.</b>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDashboardsIterable listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest)
            throws ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists dashboards in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client
     *             .listDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDashboardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDashboardsRequest#builder()}
     * </p>
     *
     * @param listDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link ListDashboardsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDashboardsIterable listDashboardsPaginator(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest)
            throws ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listDashboardsPaginator(ListDashboardsRequest.builder().applyMutation(listDashboardsRequest).build());
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current AWS account in an AWS Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     *
     * @param listDataSetsRequest
     * @return Result of the ListDataSets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsResponse listDataSets(ListDataSetsRequest listDataSetsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, InvalidNextTokenException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current AWS account in an AWS Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return Result of the ListDataSets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsResponse listDataSets(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return listDataSets(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current AWS account in an AWS Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param listDataSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsIterable listDataSetsPaginator(ListDataSetsRequest listDataSetsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, InvalidNextTokenException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current AWS account in an AWS Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsIterable listDataSetsPaginator(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return listDataSetsPaginator(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * Lists data sources in current AWS Region that belong to this AWS account.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, InvalidNextTokenException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data sources in current AWS Region that belong to this AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return Result of the ListDataSources operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists data sources in current AWS Region that belong to this AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists data sources in current AWS Region that belong to this AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return Result of the ListGroupMemberships operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsResponse listGroupMemberships(ListGroupMembershipsRequest listGroupMembershipsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupMembershipsRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsRequest.Builder} to create a
     *        request.
     * @return Result of the ListGroupMemberships operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupMembershipsResponse listGroupMemberships(
            Consumer<ListGroupMembershipsRequest.Builder> listGroupMembershipsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listGroupMemberships(ListGroupMembershipsRequest.builder().applyMutation(listGroupMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return Result of the ListGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists IAM policy assignments in the current Amazon QuickSight account.
     * </p>
     *
     * @param listIamPolicyAssignmentsRequest
     * @return Result of the ListIAMPolicyAssignments operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIAMPolicyAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIamPolicyAssignmentsResponse listIAMPolicyAssignments(
            ListIamPolicyAssignmentsRequest listIamPolicyAssignmentsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists IAM policy assignments in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIamPolicyAssignmentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIamPolicyAssignmentsRequest#builder()}
     * </p>
     *
     * @param listIamPolicyAssignmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIAMPolicyAssignmentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListIAMPolicyAssignments operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIAMPolicyAssignments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIamPolicyAssignmentsResponse listIAMPolicyAssignments(
            Consumer<ListIamPolicyAssignmentsRequest.Builder> listIamPolicyAssignmentsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return listIAMPolicyAssignments(ListIamPolicyAssignmentsRequest.builder().applyMutation(listIamPolicyAssignmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to
     * the specified user and group or groups that the user belongs to.
     * </p>
     *
     * @param listIamPolicyAssignmentsForUserRequest
     * @return Result of the ListIAMPolicyAssignmentsForUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIAMPolicyAssignmentsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIamPolicyAssignmentsForUserResponse listIAMPolicyAssignmentsForUser(
            ListIamPolicyAssignmentsForUserRequest listIamPolicyAssignmentsForUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to
     * the specified user and group or groups that the user belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIamPolicyAssignmentsForUserRequest.Builder}
     * avoiding the need to create one manually via {@link ListIamPolicyAssignmentsForUserRequest#builder()}
     * </p>
     *
     * @param listIamPolicyAssignmentsForUserRequest
     *        A {@link Consumer} that will call methods on {@link ListIAMPolicyAssignmentsForUserRequest.Builder} to
     *        create a request.
     * @return Result of the ListIAMPolicyAssignmentsForUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIAMPolicyAssignmentsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIamPolicyAssignmentsForUserResponse listIAMPolicyAssignmentsForUser(
            Consumer<ListIamPolicyAssignmentsForUserRequest.Builder> listIamPolicyAssignmentsForUserRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return listIAMPolicyAssignmentsForUser(ListIamPolicyAssignmentsForUserRequest.builder()
                .applyMutation(listIamPolicyAssignmentsForUserRequest).build());
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     *
     * @param listIngestionsRequest
     * @return Result of the ListIngestions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsResponse listIngestions(ListIngestionsRequest listIngestionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ResourceExistsException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on {@link ListIngestionsRequest.Builder} to create a request.
     * @return Result of the ListIngestions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsResponse listIngestions(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listIngestions(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client
     *             .listIngestionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation.</b>
     * </p>
     *
     * @param listIngestionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsIterable listIngestionsPaginator(ListIngestionsRequest listIngestionsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client
     *             .listIngestionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on {@link ListIngestionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIngestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsIterable listIngestionsPaginator(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listIngestionsPaginator(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * Lists the namespaces for the specified AWS account.
     * </p>
     *
     * @param listNamespacesRequest
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the namespaces for the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on {@link ListNamespacesRequest.Builder} to create a request.
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listNamespaces(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Lists the namespaces for the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the namespaces for the specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on {@link ListNamespacesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listNamespacesPaginator(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return Result of the ListTemplateAliases operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplateAliasesResponse listTemplateAliases(ListTemplateAliasesRequest listTemplateAliasesRequest)
            throws InvalidNextTokenException, ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateAliasesRequest#builder()}
     * </p>
     *
     * @param listTemplateAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateAliasesRequest.Builder} to create a
     *        request.
     * @return Result of the ListTemplateAliases operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplateAliasesResponse listTemplateAliases(
            Consumer<ListTemplateAliasesRequest.Builder> listTemplateAliasesRequest) throws InvalidNextTokenException,
            ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listTemplateAliases(ListTemplateAliasesRequest.builder().applyMutation(listTemplateAliasesRequest).build());
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client.listTemplateAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client
     *             .listTemplateAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client.listTemplateAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplateAliasesIterable listTemplateAliasesPaginator(ListTemplateAliasesRequest listTemplateAliasesRequest)
            throws InvalidNextTokenException, ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client.listTemplateAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client
     *             .listTemplateAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client.listTemplateAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateAliasesRequest#builder()}
     * </p>
     *
     * @param listTemplateAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateAliasesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplateAliasesIterable listTemplateAliasesPaginator(
            Consumer<ListTemplateAliasesRequest.Builder> listTemplateAliasesRequest) throws InvalidNextTokenException,
            ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return listTemplateAliasesPaginator(ListTemplateAliasesRequest.builder().applyMutation(listTemplateAliasesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return Result of the ListTemplateVersions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateVersionsResponse listTemplateVersions(ListTemplateVersionsRequest listTemplateVersionsRequest)
            throws ThrottlingException, InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTemplateVersions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateVersionsResponse listTemplateVersions(
            Consumer<ListTemplateVersionsRequest.Builder> listTemplateVersionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return listTemplateVersions(ListTemplateVersionsRequest.builder().applyMutation(listTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client.listTemplateVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client
     *             .listTemplateVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client.listTemplateVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateVersionsIterable listTemplateVersionsPaginator(ListTemplateVersionsRequest listTemplateVersionsRequest)
            throws ThrottlingException, InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client.listTemplateVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client
     *             .listTemplateVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client.listTemplateVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateVersionsIterable listTemplateVersionsPaginator(
            Consumer<ListTemplateVersionsRequest.Builder> listTemplateVersionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return listTemplateVersionsPaginator(ListTemplateVersionsRequest.builder().applyMutation(listTemplateVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     *
     * @param listTemplatesRequest
     * @return Result of the ListTemplates operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return Result of the ListTemplates operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesResponse listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest)
            throws ThrottlingException, InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client
     *             .listTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesIterable listTemplatesPaginator(ListTemplatesRequest listTemplatesRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client
     *             .listTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplatesIterable listTemplatesPaginator(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest)
            throws ThrottlingException, InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return listTemplatesPaginator(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all the aliases of a theme.
     * </p>
     *
     * @param listThemeAliasesRequest
     * @return Result of the ListThemeAliases operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemeAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemeAliasesResponse listThemeAliases(ListThemeAliasesRequest listThemeAliasesRequest) throws ConflictException,
            InvalidNextTokenException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the aliases of a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemeAliasesRequest.Builder} avoiding the need
     * to create one manually via {@link ListThemeAliasesRequest#builder()}
     * </p>
     *
     * @param listThemeAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemeAliasesRequest.Builder} to create a request.
     * @return Result of the ListThemeAliases operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemeAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemeAliasesResponse listThemeAliases(Consumer<ListThemeAliasesRequest.Builder> listThemeAliasesRequest)
            throws ConflictException, InvalidNextTokenException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listThemeAliases(ListThemeAliasesRequest.builder().applyMutation(listThemeAliasesRequest).build());
    }

    /**
     * <p>
     * Lists all the versions of the themes in the current AWS account.
     * </p>
     *
     * @param listThemeVersionsRequest
     * @return Result of the ListThemeVersions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemeVersionsResponse listThemeVersions(ListThemeVersionsRequest listThemeVersionsRequest)
            throws AccessDeniedException, InvalidNextTokenException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions of the themes in the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemeVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListThemeVersionsRequest#builder()}
     * </p>
     *
     * @param listThemeVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListThemeVersionsRequest.Builder} to create a request.
     * @return Result of the ListThemeVersions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemeVersionsResponse listThemeVersions(Consumer<ListThemeVersionsRequest.Builder> listThemeVersionsRequest)
            throws AccessDeniedException, InvalidNextTokenException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listThemeVersions(ListThemeVersionsRequest.builder().applyMutation(listThemeVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all the themes in the current AWS account.
     * </p>
     *
     * @param listThemesRequest
     * @return Result of the ListThemes operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListThemesResponse listThemes(ListThemesRequest listThemesRequest) throws AccessDeniedException,
            InvalidParameterValueException, InvalidNextTokenException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the themes in the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThemesRequest#builder()}
     * </p>
     *
     * @param listThemesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemesRequest.Builder} to create a request.
     * @return Result of the ListThemes operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListThemesResponse listThemes(Consumer<ListThemesRequest.Builder> listThemesRequest) throws AccessDeniedException,
            InvalidParameterValueException, InvalidNextTokenException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return listThemes(ListThemesRequest.builder().applyMutation(listThemesRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     * </p>
     *
     * @param listUserGroupsRequest
     * @return Result of the ListUserGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserGroupsResponse listUserGroups(ListUserGroupsRequest listUserGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserGroupsRequest#builder()}
     * </p>
     *
     * @param listUserGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserGroupsRequest.Builder} to create a request.
     * @return Result of the ListUserGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserGroupsResponse listUserGroups(Consumer<ListUserGroupsRequest.Builder> listUserGroupsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listUserGroups(ListUserGroupsRequest.builder().applyMutation(listUserGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return Result of the ListUsers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     *
     * @param registerUserRequest
     * @return Result of the RegisterUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterUserResponse registerUser(RegisterUserRequest registerUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterUserRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterUserRequest#builder()}
     * </p>
     *
     * @param registerUserRequest
     *        A {@link Consumer} that will call methods on {@link RegisterUserRequest.Builder} to create a request.
     * @return Result of the RegisterUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterUserResponse registerUser(Consumer<RegisterUserRequest.Builder> registerUserRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            LimitExceededException, ResourceExistsException, PreconditionNotMetException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return registerUser(RegisterUserRequest.builder().applyMutation(registerUserRequest).build());
    }

    /**
     * <p>
     * Restores an analysis.
     * </p>
     *
     * @param restoreAnalysisRequest
     * @return Result of the RestoreAnalysis operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RestoreAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default RestoreAnalysisResponse restoreAnalysis(RestoreAnalysisRequest restoreAnalysisRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores an analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreAnalysisRequest.Builder} avoiding the need
     * to create one manually via {@link RestoreAnalysisRequest#builder()}
     * </p>
     *
     * @param restoreAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link RestoreAnalysisRequest.Builder} to create a request.
     * @return Result of the RestoreAnalysis operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RestoreAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default RestoreAnalysisResponse restoreAnalysis(Consumer<RestoreAnalysisRequest.Builder> restoreAnalysisRequest)
            throws ThrottlingException, InvalidParameterValueException, ConflictException, ResourceNotFoundException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return restoreAnalysis(RestoreAnalysisRequest.builder().applyMutation(restoreAnalysisRequest).build());
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     *
     * @param searchAnalysesRequest
     * @return Result of the SearchAnalyses operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchAnalysesResponse searchAnalyses(SearchAnalysesRequest searchAnalysesRequest) throws ThrottlingException,
            ResourceNotFoundException, InvalidParameterValueException, UnsupportedUserEditionException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAnalysesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchAnalysesRequest#builder()}
     * </p>
     *
     * @param searchAnalysesRequest
     *        A {@link Consumer} that will call methods on {@link SearchAnalysesRequest.Builder} to create a request.
     * @return Result of the SearchAnalyses operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchAnalysesResponse searchAnalyses(Consumer<SearchAnalysesRequest.Builder> searchAnalysesRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return searchAnalyses(SearchAnalysesRequest.builder().applyMutation(searchAnalysesRequest).build());
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client.searchAnalysesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client
     *             .searchAnalysesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client.searchAnalysesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation.</b>
     * </p>
     *
     * @param searchAnalysesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchAnalysesIterable searchAnalysesPaginator(SearchAnalysesRequest searchAnalysesRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client.searchAnalysesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client
     *             .searchAnalysesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client.searchAnalysesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAnalysesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchAnalysesRequest#builder()}
     * </p>
     *
     * @param searchAnalysesRequest
     *        A {@link Consumer} that will call methods on {@link SearchAnalysesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchAnalysesIterable searchAnalysesPaginator(Consumer<SearchAnalysesRequest.Builder> searchAnalysesRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return searchAnalysesPaginator(SearchAnalysesRequest.builder().applyMutation(searchAnalysesRequest).build());
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     *
     * @param searchDashboardsRequest
     * @return Result of the SearchDashboards operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDashboardsResponse searchDashboards(SearchDashboardsRequest searchDashboardsRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDashboardsRequest.Builder} avoiding the need
     * to create one manually via {@link SearchDashboardsRequest#builder()}
     * </p>
     *
     * @param searchDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link SearchDashboardsRequest.Builder} to create a request.
     * @return Result of the SearchDashboards operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDashboardsResponse searchDashboards(Consumer<SearchDashboardsRequest.Builder> searchDashboardsRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return searchDashboards(SearchDashboardsRequest.builder().applyMutation(searchDashboardsRequest).build());
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client.searchDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client
     *             .searchDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client.searchDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDashboardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDashboardsIterable searchDashboardsPaginator(SearchDashboardsRequest searchDashboardsRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client.searchDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client
     *             .searchDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client.searchDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDashboardsRequest.Builder} avoiding the need
     * to create one manually via {@link SearchDashboardsRequest#builder()}
     * </p>
     *
     * @param searchDashboardsRequest
     *        A {@link Consumer} that will call methods on {@link SearchDashboardsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDashboardsIterable searchDashboardsPaginator(Consumer<SearchDashboardsRequest.Builder> searchDashboardsRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return searchDashboardsPaginator(SearchDashboardsRequest.builder().applyMutation(searchDashboardsRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified QuickSight resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the
     * resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is
     * already associated with the resource, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource. QuickSight supports tagging on data set, data source,
     * dashboard, and template.
     * </p>
     * <p>
     * Tagging for QuickSight works in a similar way to tagging for other AWS services, except for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't use tags to track AWS costs for QuickSight. This restriction is because QuickSight costs are based on
     * users and SPICE capacity, which aren't taggable resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * QuickSight doesn't currently support the Tag Editor for AWS Resource Groups.
     * </p>
     * </li>
     * </ul>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException,
            AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified QuickSight resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the
     * resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is
     * already associated with the resource, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource. QuickSight supports tagging on data set, data source,
     * dashboard, and template.
     * </p>
     * <p>
     * Tagging for QuickSight works in a similar way to tagging for other AWS services, except for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't use tags to track AWS costs for QuickSight. This restriction is because QuickSight costs are based on
     * users and SPICE capacity, which aren't taggable resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * QuickSight doesn't currently support the Tag Editor for AWS Resource Groups.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws LimitExceededException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates Amazon QuickSight customizations the current AWS Region. Currently, the only customization you can use is
     * a theme.
     * </p>
     * <p>
     * You can use customizations for your AWS account or, if you specify a namespace, for a QuickSight namespace
     * instead. Customizations that apply to a namespace override customizations that apply to an AWS account. To find
     * out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation.
     * </p>
     *
     * @param updateAccountCustomizationRequest
     * @return Result of the UpdateAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountCustomizationResponse updateAccountCustomization(
            UpdateAccountCustomizationRequest updateAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates Amazon QuickSight customizations the current AWS Region. Currently, the only customization you can use is
     * a theme.
     * </p>
     * <p>
     * You can use customizations for your AWS account or, if you specify a namespace, for a QuickSight namespace
     * instead. Customizations that apply to a namespace override customizations that apply to an AWS account. To find
     * out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountCustomizationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountCustomizationRequest#builder()}
     * </p>
     *
     * @param updateAccountCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountCustomizationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAccountCustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountCustomizationResponse updateAccountCustomization(
            Consumer<UpdateAccountCustomizationRequest.Builder> updateAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return updateAccountCustomization(UpdateAccountCustomizationRequest.builder()
                .applyMutation(updateAccountCustomizationRequest).build());
    }

    /**
     * <p>
     * Updates the Amazon QuickSight settings in your AWS account.
     * </p>
     *
     * @param updateAccountSettingsRequest
     * @return Result of the UpdateAccountSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountSettingsResponse updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Amazon QuickSight settings in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccountSettingsRequest#builder()}
     * </p>
     *
     * @param updateAccountSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAccountSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountSettingsResponse updateAccountSettings(
            Consumer<UpdateAccountSettingsRequest.Builder> updateAccountSettingsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return updateAccountSettings(UpdateAccountSettingsRequest.builder().applyMutation(updateAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Updates an analysis in Amazon QuickSight
     * </p>
     *
     * @param updateAnalysisRequest
     * @return Result of the UpdateAnalysis operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAnalysisResponse updateAnalysis(UpdateAnalysisRequest updateAnalysisRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, ThrottlingException, ResourceExistsException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an analysis in Amazon QuickSight
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnalysisRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAnalysisRequest#builder()}
     * </p>
     *
     * @param updateAnalysisRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnalysisRequest.Builder} to create a request.
     * @return Result of the UpdateAnalysis operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAnalysisResponse updateAnalysis(Consumer<UpdateAnalysisRequest.Builder> updateAnalysisRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ThrottlingException, ResourceExistsException,
            ConflictException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return updateAnalysis(UpdateAnalysisRequest.builder().applyMutation(updateAnalysisRequest).build());
    }

    /**
     * <p>
     * Updates the read and write permissions for an analysis.
     * </p>
     *
     * @param updateAnalysisPermissionsRequest
     * @return Result of the UpdateAnalysisPermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAnalysisPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAnalysisPermissionsResponse updateAnalysisPermissions(
            UpdateAnalysisPermissionsRequest updateAnalysisPermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the read and write permissions for an analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnalysisPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAnalysisPermissionsRequest#builder()}
     * </p>
     *
     * @param updateAnalysisPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnalysisPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAnalysisPermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAnalysisPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAnalysisPermissionsResponse updateAnalysisPermissions(
            Consumer<UpdateAnalysisPermissionsRequest.Builder> updateAnalysisPermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateAnalysisPermissions(UpdateAnalysisPermissionsRequest.builder()
                .applyMutation(updateAnalysisPermissionsRequest).build());
    }

    /**
     * <p>
     * Updates a dashboard in an AWS account.
     * </p>
     *
     * @param updateDashboardRequest
     * @return Result of the UpdateDashboard operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDashboardResponse updateDashboard(UpdateDashboardRequest updateDashboardRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, ConflictException, LimitExceededException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a dashboard in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDashboardRequest#builder()}
     * </p>
     *
     * @param updateDashboardRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDashboardRequest.Builder} to create a request.
     * @return Result of the UpdateDashboard operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDashboardResponse updateDashboard(Consumer<UpdateDashboardRequest.Builder> updateDashboardRequest)
            throws ThrottlingException, InvalidParameterValueException, ResourceNotFoundException, ConflictException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return updateDashboard(UpdateDashboardRequest.builder().applyMutation(updateDashboardRequest).build());
    }

    /**
     * <p>
     * Updates read and write permissions on a dashboard.
     * </p>
     *
     * @param updateDashboardPermissionsRequest
     * @return Result of the UpdateDashboardPermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDashboardPermissionsResponse updateDashboardPermissions(
            UpdateDashboardPermissionsRequest updateDashboardPermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates read and write permissions on a dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDashboardPermissionsRequest#builder()}
     * </p>
     *
     * @param updateDashboardPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDashboardPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDashboardPermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboardPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDashboardPermissionsResponse updateDashboardPermissions(
            Consumer<UpdateDashboardPermissionsRequest.Builder> updateDashboardPermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateDashboardPermissions(UpdateDashboardPermissionsRequest.builder()
                .applyMutation(updateDashboardPermissionsRequest).build());
    }

    /**
     * <p>
     * Updates the published version of a dashboard.
     * </p>
     *
     * @param updateDashboardPublishedVersionRequest
     * @return Result of the UpdateDashboardPublishedVersion operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboardPublishedVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDashboardPublishedVersionResponse updateDashboardPublishedVersion(
            UpdateDashboardPublishedVersionRequest updateDashboardPublishedVersionRequest) throws InvalidParameterValueException,
            ThrottlingException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the published version of a dashboard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDashboardPublishedVersionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDashboardPublishedVersionRequest#builder()}
     * </p>
     *
     * @param updateDashboardPublishedVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDashboardPublishedVersionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDashboardPublishedVersion operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboardPublishedVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDashboardPublishedVersionResponse updateDashboardPublishedVersion(
            Consumer<UpdateDashboardPublishedVersionRequest.Builder> updateDashboardPublishedVersionRequest)
            throws InvalidParameterValueException, ThrottlingException, ConflictException, ResourceNotFoundException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return updateDashboardPublishedVersion(UpdateDashboardPublishedVersionRequest.builder()
                .applyMutation(updateDashboardPublishedVersionRequest).build());
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     *
     * @param updateDataSetRequest
     * @return Result of the UpdateDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSetResponse updateDataSet(UpdateDataSetRequest updateDataSetRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, LimitExceededException, ThrottlingException,
            ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDataSetRequest#builder()}
     * </p>
     *
     * @param updateDataSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSetRequest.Builder} to create a request.
     * @return Result of the UpdateDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSetResponse updateDataSet(Consumer<UpdateDataSetRequest.Builder> updateDataSetRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, LimitExceededException,
            ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return updateDataSet(UpdateDataSetRequest.builder().applyMutation(updateDataSetRequest).build());
    }

    /**
     * <p>
     * Updates the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param updateDataSetPermissionsRequest
     * @return Result of the UpdateDataSetPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataSetPermissionsResponse updateDataSetPermissions(
            UpdateDataSetPermissionsRequest updateDataSetPermissionsRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSetPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDataSetPermissionsRequest#builder()}
     * </p>
     *
     * @param updateDataSetPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSetPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDataSetPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSetPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataSetPermissionsResponse updateDataSetPermissions(
            Consumer<UpdateDataSetPermissionsRequest.Builder> updateDataSetPermissionsRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateDataSetPermissions(UpdateDataSetPermissionsRequest.builder().applyMutation(updateDataSetPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Updates a data source.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, ThrottlingException,
            ResourceNotFoundException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourceRequest.Builder} to create a request.
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, ThrottlingException,
            ResourceNotFoundException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates the permissions to a data source.
     * </p>
     *
     * @param updateDataSourcePermissionsRequest
     * @return Result of the UpdateDataSourcePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataSourcePermissionsResponse updateDataSourcePermissions(
            UpdateDataSourcePermissionsRequest updateDataSourcePermissionsRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the permissions to a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourcePermissionsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDataSourcePermissionsRequest#builder()}
     * </p>
     *
     * @param updateDataSourcePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourcePermissionsRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDataSourcePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSourcePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataSourcePermissionsResponse updateDataSourcePermissions(
            Consumer<UpdateDataSourcePermissionsRequest.Builder> updateDataSourcePermissionsRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateDataSourcePermissions(UpdateDataSourcePermissionsRequest.builder()
                .applyMutation(updateDataSourcePermissionsRequest).build());
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that
     * are specified in the request.
     * </p>
     *
     * @param updateIamPolicyAssignmentRequest
     * @return Result of the UpdateIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIamPolicyAssignmentResponse updateIAMPolicyAssignment(
            UpdateIamPolicyAssignmentRequest updateIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that
     * are specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIamPolicyAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIamPolicyAssignmentRequest#builder()}
     * </p>
     *
     * @param updateIamPolicyAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIAMPolicyAssignmentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateIAMPolicyAssignment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIamPolicyAssignmentResponse updateIAMPolicyAssignment(
            Consumer<UpdateIamPolicyAssignmentRequest.Builder> updateIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateIAMPolicyAssignment(UpdateIamPolicyAssignmentRequest.builder()
                .applyMutation(updateIamPolicyAssignmentRequest).build());
    }

    /**
     * <p>
     * Updates a template from an existing Amazon QuickSight analysis or another template.
     * </p>
     *
     * @param updateTemplateRequest
     * @return Result of the UpdateTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTemplateResponse updateTemplate(UpdateTemplateRequest updateTemplateRequest)
            throws InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConflictException, LimitExceededException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a template from an existing Amazon QuickSight analysis or another template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTemplateRequest#builder()}
     * </p>
     *
     * @param updateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateRequest.Builder} to create a request.
     * @return Result of the UpdateTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTemplateResponse updateTemplate(Consumer<UpdateTemplateRequest.Builder> updateTemplateRequest)
            throws InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConflictException, LimitExceededException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return updateTemplate(UpdateTemplateRequest.builder().applyMutation(updateTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the template alias of a template.
     * </p>
     *
     * @param updateTemplateAliasRequest
     * @return Result of the UpdateTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTemplateAliasResponse updateTemplateAlias(UpdateTemplateAliasRequest updateTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, ConflictException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the template alias of a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateAliasRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTemplateAliasRequest#builder()}
     * </p>
     *
     * @param updateTemplateAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateAliasRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTemplateAliasResponse updateTemplateAlias(
            Consumer<UpdateTemplateAliasRequest.Builder> updateTemplateAliasRequest) throws ThrottlingException,
            ResourceNotFoundException, ConflictException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return updateTemplateAlias(UpdateTemplateAliasRequest.builder().applyMutation(updateTemplateAliasRequest).build());
    }

    /**
     * <p>
     * Updates the resource permissions for a template.
     * </p>
     *
     * @param updateTemplatePermissionsRequest
     * @return Result of the UpdateTemplatePermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTemplatePermissionsResponse updateTemplatePermissions(
            UpdateTemplatePermissionsRequest updateTemplatePermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the resource permissions for a template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplatePermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTemplatePermissionsRequest#builder()}
     * </p>
     *
     * @param updateTemplatePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplatePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTemplatePermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplatePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTemplatePermissionsResponse updateTemplatePermissions(
            Consumer<UpdateTemplatePermissionsRequest.Builder> updateTemplatePermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateTemplatePermissions(UpdateTemplatePermissionsRequest.builder()
                .applyMutation(updateTemplatePermissionsRequest).build());
    }

    /**
     * <p>
     * Updates a theme.
     * </p>
     *
     * @param updateThemeRequest
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateThemeResponse updateTheme(UpdateThemeRequest updateThemeRequest) throws AccessDeniedException,
            InvalidParameterValueException, LimitExceededException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateThemeRequest#builder()}
     * </p>
     *
     * @param updateThemeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThemeRequest.Builder} to create a request.
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTheme
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateThemeResponse updateTheme(Consumer<UpdateThemeRequest.Builder> updateThemeRequest)
            throws AccessDeniedException, InvalidParameterValueException, LimitExceededException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return updateTheme(UpdateThemeRequest.builder().applyMutation(updateThemeRequest).build());
    }

    /**
     * <p>
     * Updates an alias of a theme.
     * </p>
     *
     * @param updateThemeAliasRequest
     * @return Result of the UpdateThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateThemeAliasResponse updateThemeAlias(UpdateThemeAliasRequest updateThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an alias of a theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThemeAliasRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateThemeAliasRequest#builder()}
     * </p>
     *
     * @param updateThemeAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThemeAliasRequest.Builder} to create a request.
     * @return Result of the UpdateThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateThemeAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateThemeAliasResponse updateThemeAlias(Consumer<UpdateThemeAliasRequest.Builder> updateThemeAliasRequest)
            throws ConflictException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return updateThemeAlias(UpdateThemeAliasRequest.builder().applyMutation(updateThemeAliasRequest).build());
    }

    /**
     * <p>
     * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on,
     * for example <code>"quicksight:DescribeTheme"</code>.
     * </p>
     * <p>
     * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions,
     * which are user, owner, or no permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Owner
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:CreateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemePermissions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemePermissions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To specify no permissions, omit the permissions list.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateThemePermissionsRequest
     * @return Result of the UpdateThemePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateThemePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateThemePermissionsResponse updateThemePermissions(UpdateThemePermissionsRequest updateThemePermissionsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on,
     * for example <code>"quicksight:DescribeTheme"</code>.
     * </p>
     * <p>
     * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions,
     * which are user, owner, or no permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Owner
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:CreateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemePermissions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemePermissions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To specify no permissions, omit the permissions list.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThemePermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateThemePermissionsRequest#builder()}
     * </p>
     *
     * @param updateThemePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThemePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateThemePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon QuickSight currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateThemePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateThemePermissionsResponse updateThemePermissions(
            Consumer<UpdateThemePermissionsRequest.Builder> updateThemePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return updateThemePermissions(UpdateThemePermissionsRequest.builder().applyMutation(updateThemePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("quicksight");
    }
}
