/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dataset reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetReference implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetReference.Builder, DataSetReference> {
    private static final SdkField<String> DATA_SET_PLACEHOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetPlaceholder").getter(getter(DataSetReference::dataSetPlaceholder))
            .setter(setter(Builder::dataSetPlaceholder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetPlaceholder").build())
            .build();

    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetArn").getter(getter(DataSetReference::dataSetArn)).setter(setter(Builder::dataSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_PLACEHOLDER_FIELD,
            DATA_SET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSetPlaceholder;

    private final String dataSetArn;

    private DataSetReference(BuilderImpl builder) {
        this.dataSetPlaceholder = builder.dataSetPlaceholder;
        this.dataSetArn = builder.dataSetArn;
    }

    /**
     * <p>
     * Dataset placeholder.
     * </p>
     * 
     * @return Dataset placeholder.
     */
    public String dataSetPlaceholder() {
        return dataSetPlaceholder;
    }

    /**
     * <p>
     * Dataset Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Dataset Amazon Resource Name (ARN).
     */
    public String dataSetArn() {
        return dataSetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetPlaceholder());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetReference)) {
            return false;
        }
        DataSetReference other = (DataSetReference) obj;
        return Objects.equals(dataSetPlaceholder(), other.dataSetPlaceholder())
                && Objects.equals(dataSetArn(), other.dataSetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSetReference").add("DataSetPlaceholder", dataSetPlaceholder())
                .add("DataSetArn", dataSetArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetPlaceholder":
            return Optional.ofNullable(clazz.cast(dataSetPlaceholder()));
        case "DataSetArn":
            return Optional.ofNullable(clazz.cast(dataSetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetReference, T> g) {
        return obj -> g.apply((DataSetReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetReference> {
        /**
         * <p>
         * Dataset placeholder.
         * </p>
         * 
         * @param dataSetPlaceholder
         *        Dataset placeholder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetPlaceholder(String dataSetPlaceholder);

        /**
         * <p>
         * Dataset Amazon Resource Name (ARN).
         * </p>
         * 
         * @param dataSetArn
         *        Dataset Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArn(String dataSetArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetPlaceholder;

        private String dataSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetReference model) {
            dataSetPlaceholder(model.dataSetPlaceholder);
            dataSetArn(model.dataSetArn);
        }

        public final String getDataSetPlaceholder() {
            return dataSetPlaceholder;
        }

        @Override
        public final Builder dataSetPlaceholder(String dataSetPlaceholder) {
            this.dataSetPlaceholder = dataSetPlaceholder;
            return this;
        }

        public final void setDataSetPlaceholder(String dataSetPlaceholder) {
            this.dataSetPlaceholder = dataSetPlaceholder;
        }

        public final String getDataSetArn() {
            return dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        @Override
        public DataSetReference build() {
            return new DataSetReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
