/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that creates calculated columns. Columns created in one such operation form a lexical closure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateColumnsOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateColumnsOperation.Builder, CreateColumnsOperation> {
    private static final SdkField<List<CalculatedColumn>> COLUMNS_FIELD = SdkField
            .<List<CalculatedColumn>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(CreateColumnsOperation::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CalculatedColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(CalculatedColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CalculatedColumn> columns;

    private CreateColumnsOperation(BuilderImpl builder) {
        this.columns = builder.columns;
    }

    /**
     * Returns true if the Columns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Calculated columns to create.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Calculated columns to create.
     */
    public List<CalculatedColumn> columns() {
        return columns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateColumnsOperation)) {
            return false;
        }
        CreateColumnsOperation other = (CreateColumnsOperation) obj;
        return hasColumns() == other.hasColumns() && Objects.equals(columns(), other.columns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateColumnsOperation").add("Columns", hasColumns() ? columns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateColumnsOperation, T> g) {
        return obj -> g.apply((CreateColumnsOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateColumnsOperation> {
        /**
         * <p>
         * Calculated columns to create.
         * </p>
         * 
         * @param columns
         *        Calculated columns to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<CalculatedColumn> columns);

        /**
         * <p>
         * Calculated columns to create.
         * </p>
         * 
         * @param columns
         *        Calculated columns to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(CalculatedColumn... columns);

        /**
         * <p>
         * Calculated columns to create.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CalculatedColumn>.Builder} avoiding the
         * need to create one manually via {@link List<CalculatedColumn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CalculatedColumn>.Builder#build()} is called immediately and
         * its result is passed to {@link #columns(List<CalculatedColumn>)}.
         * 
         * @param columns
         *        a consumer that will call methods on {@link List<CalculatedColumn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(List<CalculatedColumn>)
         */
        Builder columns(Consumer<CalculatedColumn.Builder>... columns);
    }

    static final class BuilderImpl implements Builder {
        private List<CalculatedColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateColumnsOperation model) {
            columns(model.columns);
        }

        public final Collection<CalculatedColumn.Builder> getColumns() {
            if (columns instanceof SdkAutoConstructList) {
                return null;
            }
            return columns != null ? columns.stream().map(CalculatedColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columns(Collection<CalculatedColumn> columns) {
            this.columns = CalculatedColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(CalculatedColumn... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<CalculatedColumn.Builder>... columns) {
            columns(Stream.of(columns).map(c -> CalculatedColumn.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumns(Collection<CalculatedColumn.BuilderImpl> columns) {
            this.columns = CalculatedColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public CreateColumnsOperation build() {
            return new CreateColumnsOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
